/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignDto;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignTestPlanItemDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.validators.helper.CampaignDtoValidationHelper;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.internal.repository.CampaignTestPlanItemDao;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.UserDao;

@Component
public class CampaignTestPlanItemValidator
implements Validator {
    private static final String POST_CAMPAIGN_TEST_PLAN = "post-campaign-test-plan";
    private static final String PATCH_CAMPAIGN_TEST_PLAN = "patch-campaign-test-plan";
    @Inject
    private UserDao userDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private CampaignTestPlanItemDao ctpiDao;
    @Inject
    private CampaignDtoValidationHelper campaignDtoValidationHelper;
    @Inject
    private CampaignTestPlanManagerService campaignTestPlanManagerService;

    public boolean supports(Class<?> clazz) {
        return CampaignDto.class.equals(clazz);
    }

    public void validatePostTestPlanItem(CampaignTestPlanItemDto ctpiDto, Long campaignId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)ctpiDto, POST_CAMPAIGN_TEST_PLAN);
        this.campaignDtoValidationHelper.checkEntityExist((Errors)validation, RestType.CAMPAIGN, campaignId);
        this.validate(ctpiDto, (Errors)validation);
        this.validateAssignedTo(campaignId, ctpiDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(ctpiDto, errors, POST_CAMPAIGN_TEST_PLAN);
    }

    public void validatePatchTestPlanItem(CampaignTestPlanItemDto ctpiDto, Long testPlanId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)ctpiDto, PATCH_CAMPAIGN_TEST_PLAN);
        this.campaignDtoValidationHelper.checkEntityExist((Errors)validation, RestType.CAMPAIGN_TEST_PLAN_ITEM, testPlanId);
        CampaignTestPlanItem ctpi = (CampaignTestPlanItem)this.ctpiDao.findById(testPlanId.longValue());
        if (ctpi != null) {
            this.validatePatch(ctpi, ctpiDto, (Errors)validation);
            Long campaignId = ctpi.getCampaign().getId();
            this.validateAssignedTo(campaignId, ctpiDto, (Errors)validation);
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(ctpiDto, errors, PATCH_CAMPAIGN_TEST_PLAN);
    }

    public void validate(Object target, Errors errors) {
        CampaignTestPlanItemDto ctpiDto = (CampaignTestPlanItemDto)target;
        TestCaseDto referencedTcDTo = ctpiDto.getReferencedTestCase();
        DatasetDto referencedDatasetDto = ctpiDto.getReferencedDataset();
        if (ctpiDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing campaign test plan item , please do a patch request to the campaign test plan item  id. ");
        }
        if (!referencedTcDTo.getRestType().equals((Object)RestType.TEST_CASE)) {
            errors.rejectValue("_type", "invalid type", "Type test-case expected");
        } else if (referencedTcDTo.getId() == null) {
            errors.rejectValue("id", "generated value", "The test case id must not be null ");
        }
        this.campaignDtoValidationHelper.checkEntityExist(errors, RestType.TEST_CASE, referencedTcDTo.getId());
        if (referencedDatasetDto != null) {
            this.campaignDtoValidationHelper.checkEntityExist(errors, RestType.DATASET, referencedDatasetDto.getId());
            Dataset ds = (Dataset)this.datasetDao.getReferenceById((Object)referencedDatasetDto.getId());
            if (!ds.getTestCase().getId().equals(referencedTcDTo.getId())) {
                errors.rejectValue("id", "invalid value", "This dataset is not attached to this test case");
            }
        }
    }

    public void validateAssignedTo(Long campaignId, CampaignTestPlanItemDto ctpiDto, Errors errors) {
        if (ctpiDto.getUser() != null) {
            User assignedTo;
            User user = assignedTo = ctpiDto.getUser() != null ? this.userDao.findUserByLogin(ctpiDto.getUser()) : null;
            if (assignedTo == null) {
                errors.rejectValue("user", "not found value", "this user does not exist");
            } else {
                List listUser = this.campaignTestPlanManagerService.findAssignableUserForTestPlan(campaignId.longValue());
                if (listUser.isEmpty()) {
                    errors.rejectValue("user", "empty value", "no user are assignable for this campaign");
                } else if (listUser.stream().noneMatch(c -> c.getLogin().equals(assignedTo.getLogin()))) {
                    errors.rejectValue("user", "not found value", "this user is not assignable for this test plan");
                }
            }
        }
    }

    public void validatePatch(CampaignTestPlanItem ctpi, CampaignTestPlanItemDto ctpiDto, Errors errors) {
        TestCase referencedTc = ctpi.getReferencedTestCase();
        DatasetDto referencedDatasetDto = ctpiDto.getReferencedDataset();
        if (referencedDatasetDto != null && referencedDatasetDto.getId() != null) {
            Dataset ds;
            this.campaignDtoValidationHelper.checkEntityExist(errors, RestType.DATASET, referencedDatasetDto.getId());
            Dataset dataset = ds = referencedDatasetDto.getId() != null ? (Dataset)this.datasetDao.getReferenceById((Object)referencedDatasetDto.getId()) : null;
            if (!ds.getTestCase().getId().equals(referencedTc.getId())) {
                errors.rejectValue("id", "invalid value", "This dataset is not attached to this test case");
            }
        }
    }
}

