/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignFolderDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.validators.helper.CampaignFolderDtoValidationHelper;

@Component
public class CampaignFolderPostValidator
implements Validator {
    private static final String POST_CAMPAIGN_FOLDER = "post-campaign-folder";
    @Inject
    private CampaignFolderDtoValidationHelper campaignFolderDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return CampaignFolderDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        CampaignFolderDto folderDto = (CampaignFolderDto)target;
        if (folderDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing campaign folder, please do a patch request to the campaign folder id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.campaignFolderDtoValidationHelper.checkParent(errors, folderDto, RestType.CAMPAIGN_FOLDER);
        if (errors.hasErrors()) {
            return;
        }
        this.campaignFolderDtoValidationHelper.assignProject(folderDto);
        this.campaignFolderDtoValidationHelper.checkCufs(errors, folderDto, BindableEntity.CAMPAIGN_FOLDER);
    }

    public void validatePostCampaignFolder(CampaignFolderDto folderDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)folderDto, POST_CAMPAIGN_FOLDER);
        this.validate(folderDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(folderDto, errors, POST_CAMPAIGN_FOLDER);
    }
}

