/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import com.google.common.collect.ListMultimap;
import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyProjectPermissionsBean;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectCopyParameterDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectTemplateDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyClearance;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyPermission;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyProfileDto;
import org.squashtest.tm.plugin.rest.jackson.serializer.SnakeCaseSerializer;
import org.squashtest.tm.plugin.rest.repository.RestGenericProjectRepository;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.service.RestProjectService;
import org.squashtest.tm.plugin.rest.service.TestCaseLibraryFinderService;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.internal.repository.display.SingleHierarchyTreeBrowserDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.project.ProjectManagerService;
import org.squashtest.tm.service.project.ProjectTemplateManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional
public class RestProjectServiceImpl
implements RestProjectService {
    private static final String NAMESPACE = "squashtest.acl.group.tm.";
    private static final String ACCESS_DENIED_MESSAGE = "access is denied";
    @Inject
    private RestGenericProjectRepository dao;
    @Inject
    private PermissionEvaluationService permService;
    @Inject
    private GenericProjectManagerService genericProjectManager;
    @Inject
    private ProjectManagerService projectManager;
    @Inject
    private ProjectTemplateManagerService projectTemplateManagerService;
    @Inject
    private RestPartyService restPartyService;
    @Inject
    private ProfileDao profileDao;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private TestCaseLibraryFinderService testCaseLibraryFinderService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    SingleHierarchyTreeBrowserDao treeBrowserDao;

    @Override
    @PreAuthorize(value="hasPermission(#id, 'org.squashtest.tm.domain.project.Project' , 'MANAGE_PROJECT') or hasPermission(#id, 'org.squashtest.tm.domain.project.ProjectTemplate' , 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public Boolean isGenericProjectExist(long id) {
        return this.dao.existsById(id);
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'org.squashtest.tm.domain.project.Project' , 'MANAGE_PROJECT') or hasPermission(#id, 'org.squashtest.tm.domain.project.ProjectTemplate' , 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public GenericProject getOne(long id) {
        return this.dao.getReferenceById(id);
    }

    @Override
    public GenericProject getOneByName(String projectName) {
        GenericProject project = this.dao.getOneByName(projectName);
        if (Objects.isNull(project)) {
            throw new EntityNotFoundException("Unable to find org.squashtest.tm.domain.project.GenericProject with name " + projectName);
        }
        if (!this.permService.hasPermissionOnObject(Permissions.MANAGE_PROJECT.name(), (Object)project) && !this.permService.hasRole("ROLE_ADMIN")) {
            throw new AccessDeniedException(ACCESS_DENIED_MESSAGE);
        }
        return project;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<GenericProject> findAllReadable(Long milestoneId, String milestoneLabel, Pageable pageable) {
        return this.userAccountService.findCurrentUserDto().isAdmin() ? this.dao.findAllWithMilestones(milestoneId, milestoneLabel, pageable) : this.findAllReadableStandardProject(milestoneId, milestoneLabel, pageable);
    }

    @Override
    public Page<GenericProject> findAllReadableProjectTemplate(Long milestoneId, String milestoneLabel, Pageable pageable) {
        return this.userAccountService.findCurrentUserDto().isAdmin() ? this.dao.findAllTemplates(milestoneId, milestoneLabel, pageable) : PaginationUtils.emptyPage(pageable);
    }

    @Override
    public Page<GenericProject> findAllReadableStandardProject(Long milestoneId, String milestoneLabel, Pageable pageable) {
        List readableProjectIds = this.projectFinder.findAllReadableIds();
        return readableProjectIds.isEmpty() ? PaginationUtils.emptyPage(pageable) : this.dao.findProjectByIdAndMilestones(milestoneId, milestoneLabel, readableProjectIds, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<RequirementLibraryNode<Resource>> findRequirementLibraryAllContent(long id, Pageable paging) {
        this.checkReadOnRequirements(id);
        return this.dao.findRequirementLibraryAllContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<RequirementLibraryNode<Resource>> findRequirementLibraryRootContent(long id, Pageable paging) {
        this.checkReadOnRequirements(id);
        return this.dao.findRequirementLibraryRootContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCaseLibraryNode> findTestCaseLibraryAllContent(long id, Pageable paging) {
        this.checkReadOnTestCases(id);
        return this.dao.findTestCaseLibraryAllContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCaseLibraryNode> findTestCaseLibraryRootContent(long id, Pageable paging) {
        this.checkReadOnTestCases(id);
        return this.dao.findTestCaseLibraryRootContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<CampaignLibraryNode> findCampaignLibraryAllContent(long id, Pageable paging) {
        this.checkReadOnCampaigns(id);
        return this.dao.findCampaignLibraryAllContent(id, paging);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<CampaignLibraryNode> findCampaignLibraryRootContent(long id, Pageable paging) {
        this.checkReadOnCampaigns(id);
        return this.dao.findCampaignLibraryRootContent(id, paging);
    }

    @Override
    public GenericProject createGenericProject(GenericProjectDto genericProjectDto) {
        final GenericProject genericProject = GenericProjectDto.convertDto(genericProjectDto);
        GenericProjectDtoVisitor visitor = new GenericProjectDtoVisitor(){

            @Override
            public void visit(ProjectDto projectDto) {
                if (projectDto.getTemplateId() != null) {
                    RestProjectServiceImpl.this.projectManager.addProjectFromTemplate((Project)genericProject, projectDto.getTemplateId().longValue(), GenericProjectCopyParameterDto.convertDto(projectDto.getParams()));
                } else {
                    RestProjectServiceImpl.this.genericProjectManager.persist(genericProject);
                }
            }

            @Override
            public void visit(ProjectTemplateDto projectTemplateDto) {
                if (projectTemplateDto.getProjectId() != null) {
                    RestProjectServiceImpl.this.projectTemplateManagerService.addTemplateFromProject((ProjectTemplate)genericProject, projectTemplateDto.getProjectId().longValue(), GenericProjectCopyParameterDto.convertDto(projectTemplateDto.getParams()));
                } else {
                    RestProjectServiceImpl.this.genericProjectManager.persist(genericProject);
                }
            }
        };
        genericProjectDto.accept(visitor);
        return genericProject;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#projectId, 'org.squashtest.tm.domain.project.GenericProject', 'MANAGE_PROJECT_CLEARANCE')")
    public RestPartyClearance findAllClearancesByProjectId(long projectId) {
        List beanList = this.genericProjectManager.findPartyPermissionsBeansByProject(projectId);
        RestPartyClearance clearances = new RestPartyClearance();
        List<Long> partyIds = beanList.stream().map(bean -> bean.getParty().getId()).toList();
        Map<Long, Party> partyMap = this.restPartyService.findByIds(partyIds).stream().collect(Collectors.toMap(Party::getId, p -> p));
        for (PartyProjectPermissionsBean item : beanList) {
            AclGroup profile = item.getPermissionGroup();
            String profileName = profile.getSimpleName();
            if ("advanceTester".equalsIgnoreCase(profileName)) {
                profileName = "advancedTester";
            }
            Party target = partyMap.get(item.getParty().getId());
            RestPartyProfileDto targetList = clearances.getPartyClearances().get(profileName);
            if (targetList == null) {
                long profileId = profile.getId();
                boolean isSystem = profile.isSystem();
                ArrayList<Party> parties = new ArrayList<Party>();
                parties.add(target);
                targetList = new RestPartyProfileDto(profileId, profileName, isSystem, parties);
                clearances.getPartyClearances().put(profileName, targetList);
                continue;
            }
            targetList.getUsers().add(target);
        }
        return clearances;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#projectId, 'org.squashtest.tm.domain.project.GenericProject', 'MANAGE_PROJECT_CLEARANCE')")
    public RestPartyPermission findAllPermissionsByProjectId(long projectId) {
        List beanList = this.genericProjectManager.findPartyPermissionsBeansByProject(projectId);
        RestPartyPermission permissions = new RestPartyPermission();
        for (PartyProjectPermissionsBean item : beanList) {
            String groupName = item.getPermissionGroup().getSimpleName();
            if ("advanceTester".equalsIgnoreCase(groupName)) {
                groupName = "advancedTester";
            }
            Party target = this.restPartyService.findById(item.getParty().getId());
            List<Party> targetList = permissions.getPartyPermissions().get(groupName);
            if (targetList == null) {
                targetList = new ArrayList<Party>();
                targetList.add(target);
                permissions.getPartyPermissions().put(groupName, targetList);
                continue;
            }
            targetList.add(target);
        }
        return permissions;
    }

    @Override
    public RestPartyClearance buildPartyClearanceDataModel(long profileId, List<Long> partyIds) {
        List<Party> parties = this.restPartyService.findByIds(partyIds);
        Optional optionalProfile = this.profileDao.findById((Object)profileId);
        if (optionalProfile.isPresent()) {
            AclGroup profile = (AclGroup)optionalProfile.get();
            RestPartyClearance clearances = new RestPartyClearance();
            RestPartyProfileDto partyProfile = new RestPartyProfileDto(profileId, profile.getSimpleName(), profile.isSystem(), parties);
            String profileNameKey = SnakeCaseSerializer.toSnakeCase(profile.getSimpleName());
            clearances.getPartyClearances().put(profileNameKey, partyProfile);
            return clearances;
        }
        throw new EntityNotFoundException("The profile with id: " + profileId + " does not exist.");
    }

    @Override
    public RestPartyPermission buildPartyPermissionDataModel(String permissionGroup, List<Long> partyIds) {
        ArrayList<Party> parties = new ArrayList<Party>();
        for (Long partyId : partyIds) {
            parties.add(this.restPartyService.findById(partyId));
        }
        RestPartyPermission permissions = new RestPartyPermission();
        permissions.getPartyPermissions().put(permissionGroup, parties);
        return permissions;
    }

    @Override
    public void addNewPermissionToProject(long userId, long projectId, String permissionGroup) {
        this.genericProjectManager.addNewPermissionToProject(Collections.singletonList(userId), projectId, NAMESPACE + permissionGroup);
    }

    @Override
    public void addNewPermissionToProject(long userId, long projectId, long profileId) {
        this.genericProjectManager.addNewPermissionToProject(Collections.singletonList(userId), projectId, profileId);
    }

    @Override
    public List<AclGroup> findAllPossiblePermission() {
        return this.genericProjectManager.findAllPossiblePermission();
    }

    @Override
    public Page<Requirement> findRequirementsByProject(long projectId, Pageable paging) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.READ.name(), Project.class.getName());
        return this.dao.findAllRequirementByProjectId(projectId, paging);
    }

    @Override
    public Page<TestCase> findTestCasesByProject(long projectId, Pageable paging, List<String> fields) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.READ.name(), Project.class.getName());
        return this.testCaseLibraryFinderService.findAllTestCaseByProjectId(projectId, paging, fields);
    }

    @Override
    public Page<Campaign> findCampaignsByProject(long projectId, Pageable paging) {
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.READ.name(), Project.class.getName());
        return this.dao.findAllCampaignByProjectId(projectId, paging);
    }

    @Override
    public void deletePartyFromProject(Long partyId, long projectId) {
        this.genericProjectManager.removeProjectPermission(Collections.singletonList(partyId), projectId);
    }

    @Override
    public Map<Long, String> findNamesByProjectIds(List<Long> projectIds) {
        HashMap<Long, String> projectNameByIdMap = new HashMap<Long, String>();
        List<Object[]> projectNameByIdObjectList = this.dao.findNamesByProjectIds(projectIds);
        projectNameByIdObjectList.forEach(projectIdentityTab -> {
            if (((Object[])projectIdentityTab).length <= 0) {
                throw new IllegalArgumentException("Project identity table cannot be empty. Check the validation and your rights on the project ids");
            }
            projectNameByIdMap.put((Long)projectIdentityTab[0], (String)projectIdentityTab[1]);
        });
        return projectNameByIdMap;
    }

    @Override
    public List<Long> getReadableProjectIdsOnRequirementLibrary(List<Long> projectIds) {
        List allReadableIds = this.projectFinder.findReadableProjectIdsOnRequirementLibrary();
        projectIds.retainAll(allReadableIds);
        return projectIds;
    }

    @Override
    public List<Long> getReadableProjectIdsOnTestCaseLibrary(List<Long> projectIds) {
        List allReadableIds = this.projectFinder.findReadableProjectIdsOnTestCaseLibrary();
        projectIds.retainAll(allReadableIds);
        return projectIds;
    }

    @Override
    public List<Long> getReadableProjectIdsOnCampaignLibrary(List<Long> projectIds) {
        List allReadableIds = this.projectFinder.findReadableProjectIdsOnCampaignLibrary();
        projectIds.retainAll(allReadableIds);
        return projectIds;
    }

    @Override
    public Page<CustomReportLibraryNode> findCustomReportLibraryAllContent(long projectId, Pageable paging) {
        this.dao.findById(projectId).orElseThrow(() -> ExceptionUtils.entityNotFoundException(Project.class, (Long)projectId));
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.READ.name(), Project.class.getName());
        return this.dao.findAllCustomReportLibraryByProjectId(projectId, paging);
    }

    @Override
    public Page<CustomReportLibraryNode> findCustomReportLibraryRootContent(long projectId, Pageable paging) {
        this.dao.findById(projectId).orElseThrow(() -> ExceptionUtils.entityNotFoundException(Project.class, (Long)projectId));
        this.permissionEvaluationService.checkPermission(Collections.singletonList(projectId), Permissions.READ.name(), Project.class.getName());
        Set nodesToCollect = this.treeBrowserDao.findLibraryReferences(NodeWorkspace.CUSTOM_REPORT, Collections.singleton(projectId));
        ListMultimap childrenReferences = this.treeBrowserDao.findChildrenReference(nodesToCollect);
        nodesToCollect.addAll(childrenReferences.values());
        List<Long> nodeIds = nodesToCollect.stream().map(NodeReference::getId).toList();
        return this.dao.findAllCustomReportLibraryByCustomReportLibraryNodeIds(nodeIds, paging);
    }

    private void checkReadOnRequirements(long projectId) {
        GenericProject p = this.dao.getReferenceById(projectId);
        if (p == null) {
            throw new EntityNotFoundException();
        }
        if (!this.permService.canRead((Object)p.getRequirementLibrary())) {
            throw new EntityNotFoundException(ACCESS_DENIED_MESSAGE);
        }
    }

    private void checkReadOnTestCases(long projectId) {
        GenericProject p = this.dao.getReferenceById(projectId);
        if (p == null) {
            throw new EntityNotFoundException();
        }
        if (!this.permService.canRead((Object)p.getTestCaseLibrary())) {
            throw new AccessDeniedException(ACCESS_DENIED_MESSAGE);
        }
    }

    private void checkReadOnCampaigns(long projectId) {
        GenericProject p = this.dao.getReferenceById(projectId);
        if (p == null) {
            throw new EntityNotFoundException();
        }
        if (!this.permService.canRead((Object)p.getCampaignLibrary())) {
            throw new AccessDeniedException(ACCESS_DENIED_MESSAGE);
        }
    }
}

