/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestReportingService;
import org.squashtest.tm.plugin.rest.service.helper.CustomSelfLinksHelper;

@RestApiController(value=CustomReportLibraryNode.class)
@UseDefaultRestApiConfiguration
public class RestReportingController
extends BaseRestController {
    private static final String CANNOT_DELETE_ENTITIES_MESSAGE = "reporting entities cannot be deleted. They don't exist, you don't have permissions on them or they are not ";
    @Inject
    private RestReportingService resChartsService;

    @GetMapping(value={"/charts/{id}"})
    @EntityGetter(value={CustomReportLibraryNode.class})
    public ResponseEntity<EntityModel<CustomReportLibraryNode>> getChart(@PathVariable(value="id") Long id) {
        CustomReportLibraryNode customReportLibraryNode = this.resChartsService.getReportingEntity(id, "CHART");
        EntityModel res = this.toEntityModel((Identified)customReportLibraryNode);
        CustomSelfLinksHelper.replaceLinksByCustomSelfLinks(res, ((CustomReportLibraryNode)res.getContent()).getEntityType().getTypeName());
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/custom-exports/{id}"})
    @EntityGetter(value={CustomReportLibraryNode.class})
    public ResponseEntity<EntityModel<CustomReportLibraryNode>> getCustomExport(@PathVariable(value="id") Long id) {
        CustomReportLibraryNode customReportLibraryNode = this.resChartsService.getReportingEntity(id, "CUSTOM_EXPORT");
        EntityModel res = this.toEntityModel((Identified)customReportLibraryNode);
        CustomSelfLinksHelper.replaceLinksByCustomSelfLinks(res, ((CustomReportLibraryNode)res.getContent()).getEntityType().getTypeName());
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/dashboards/{id}"})
    @EntityGetter(value={CustomReportLibraryNode.class})
    public ResponseEntity<EntityModel<CustomReportLibraryNode>> getDashoard(@PathVariable(value="id") Long id) {
        CustomReportLibraryNode customReportLibraryNode = this.resChartsService.getReportingEntity(id, "DASHBOARD");
        EntityModel res = this.toEntityModel((Identified)customReportLibraryNode);
        CustomSelfLinksHelper.replaceLinksByCustomSelfLinks(res, ((CustomReportLibraryNode)res.getContent()).getEntityType().getTypeName());
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/reporting-folders/{id}"})
    @EntityGetter(value={CustomReportLibraryNode.class})
    public ResponseEntity<EntityModel<CustomReportLibraryNode>> getFolder(@PathVariable(value="id") Long id) {
        CustomReportLibraryNode customReportLibraryNode = this.resChartsService.getReportingEntity(id, "FOLDER");
        EntityModel res = this.toEntityModel((Identified)customReportLibraryNode);
        String entityTypeName = "reporting-%s".formatted(((CustomReportLibraryNode)res.getContent()).getEntityType().getTypeName());
        CustomSelfLinksHelper.replaceLinksByCustomSelfLinks(res, entityTypeName);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/reports/{id}"})
    @EntityGetter(value={CustomReportLibraryNode.class})
    public ResponseEntity<EntityModel<CustomReportLibraryNode>> getReport(@PathVariable(value="id") Long id) {
        CustomReportLibraryNode customReportLibraryNode = this.resChartsService.getReportingEntity(id, "REPORT");
        EntityModel res = this.toEntityModel((Identified)customReportLibraryNode);
        CustomSelfLinksHelper.replaceLinksByCustomSelfLinks(res, ((CustomReportLibraryNode)res.getContent()).getEntityType().getTypeName());
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/charts/{ids}"})
    public ResponseEntity<String> deleteCharts(@PathVariable(value="ids") List<Long> ids) {
        return this.deleteReportingEntities("charts", ids, "CHART");
    }

    @DeleteMapping(value={"/custom-exports/{ids}"})
    public ResponseEntity<String> deleteCustomExports(@PathVariable(value="ids") List<Long> ids) {
        return this.deleteReportingEntities("custom exports", ids, "CUSTOM_EXPORT");
    }

    @DeleteMapping(value={"/dashboards/{ids}"})
    public ResponseEntity<String> deleteDashboards(@PathVariable(value="ids") List<Long> ids) {
        return this.deleteReportingEntities("dashboards", ids, "DASHBOARD");
    }

    @DeleteMapping(value={"/reporting-folders/{ids}"})
    public ResponseEntity<String> deleteFolders(@PathVariable(value="ids") List<Long> ids) {
        return this.deleteReportingEntities("folders", ids, "FOLDER");
    }

    @DeleteMapping(value={"/reports/{ids}"})
    public ResponseEntity<String> deleteReports(@PathVariable(value="ids") List<Long> ids) {
        return this.deleteReportingEntities("reports", ids, "REPORT");
    }

    private ResponseEntity<String> deleteReportingEntities(String entityType, List<Long> ids, String internalEntityType) {
        List<Long> deletableIds = this.resChartsService.fetchAndDeleteReportingDeletableIds(ids, internalEntityType);
        if (deletableIds.containsAll(ids)) {
            return ResponseEntity.noContent().build();
        }
        ArrayList<Long> invalidIds = new ArrayList<Long>(ids);
        invalidIds.removeAll(deletableIds);
        if (invalidIds.size() == ids.size()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)("The reporting entities cannot be deleted. They don't exist, you don't have permissions on them or they are not " + entityType + ": " + String.valueOf(invalidIds)));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.MULTI_STATUS).body((Object)("Some reporting entities cannot be deleted. They don't exist, you don't have permissions on them or they are not " + entityType + ": " + String.valueOf(invalidIds)));
    }
}

