/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal;

import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Project;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.NameValuePair;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.utils.URIBuilder;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.message.BasicNameValuePair;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedRole;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedWorkflows;

public class ExtendedURIConfigurator {
    private static final String URL_POSTFIX = ".json";
    private static final Map<Class<?>, String> URLS = new HashMap();
    private final URI baseURI;
    private final String apiAccessKey;

    static {
        URLS.put(ExtendedCustomField.class, "extended_custom_fields");
        URLS.put(ExtendedTracker.class, "extended_tracker");
        URLS.put(ExtendedRole.class, "extended_role");
        URLS.put(IssueCategory.class, "extended_category");
        URLS.put(Project.class, "projects");
        URLS.put(Membership.class, "memberships");
        URLS.put(ExtendedWorkflows.class, "extended_workflows");
    }

    public ExtendedURIConfigurator(String host, String apiAccessKey) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("The host parameter is NULL or empty");
        }
        try {
            this.baseURI = this.normalizeAndCreateURIFromHost(host);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal host URL " + host, e);
        }
        this.apiAccessKey = apiAccessKey;
    }

    private URI normalizeAndCreateURIFromHost(String host) throws URISyntaxException {
        host = StringUtils.appendIfMissing((String)host, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return new URI(host);
    }

    public URI createURI(String query, NameValuePair ... param) {
        return this.createURI(query, Arrays.asList(param));
    }

    private URI createURI(String query, Collection<? extends NameValuePair> origParams) {
        ArrayList<? extends NameValuePair> params = new ArrayList<NameValuePair>(origParams);
        if (this.apiAccessKey != null) {
            params.add(new BasicNameValuePair("key", this.apiAccessKey));
        }
        try {
            String normalizedQuery = query.startsWith("/") ? query.substring(1) : query;
            URIBuilder builder = new URIBuilder(this.baseURI.resolve(normalizedQuery));
            params.forEach(p -> {
                URIBuilder uRIBuilder2 = builder.addParameter(p.getName(), p.getValue());
            });
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RedmineInternalError(e);
        }
    }

    public URI getChildObjectsURI(Class<?> parent, String parentId, Class<?> child, NameValuePair ... args) {
        String base = this.getConfig(parent);
        String detal = this.getConfig(child);
        return this.createURI(base + "/" + parentId + "/" + detal + URL_POSTFIX, args);
    }

    public URI getChildIdURI(Class<?> parent, String parentId, Class<?> child, int value) {
        String base = this.getConfig(parent);
        String detal = this.getConfig(child);
        return this.createURI(base + "/" + parentId + "/" + detal + "/" + value + URL_POSTFIX, new NameValuePair[0]);
    }

    public URI getObjectsURI(Class<?> child, NameValuePair ... args) {
        String detal = this.getConfig(child);
        return this.createURI(detal + URL_POSTFIX, args);
    }

    public URI getObjectsURI(Class<?> child, Collection<? extends NameValuePair> args) {
        String detal = this.getConfig(child);
        return this.createURI(detal + URL_POSTFIX, args);
    }

    public URI getObjectURI(Class<?> object, String id, NameValuePair ... args) {
        String detal = this.getConfig(object);
        return this.createURI(detal + "/" + id + URL_POSTFIX, args);
    }

    public URI getObjectURI(Class<?> object, NameValuePair ... args) {
        String detal = this.getConfig(object);
        return this.createURI(detal + URL_POSTFIX, args);
    }

    private String getConfig(Class<?> item) {
        String guess = URLS.get(item);
        if (guess == null) {
            throw new RedmineInternalError("Unsupported item class " + item.getCanonicalName());
        }
        return guess;
    }

    public URI getUploadURI() {
        return this.createURI("uploads.json", new NameValuePair[0]);
    }
}

