/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.plugin.redminereq.controller.AuthenticationBugTracker;
import org.squashtest.tm.plugin.redminereq.controller.ConfigPageConfiguration;
import org.squashtest.tm.plugin.redminereq.domain.BuiltinRedmineLinkField;
import org.squashtest.tm.plugin.redminereq.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.redminereq.domain.Configuration;
import org.squashtest.tm.plugin.redminereq.domain.FieldMapping;
import org.squashtest.tm.plugin.redminereq.domain.RestThirdPartyServer;
import org.squashtest.tm.plugin.redminereq.dto.FilterBindingDto;
import org.squashtest.tm.plugin.redminereq.service.ConfigurationService;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@RestController(value="squash.tm.plugin.redminereq.configurationController")
@RequestMapping(value={"backend/plugin/redminereq/project/{projectId}/configuration"})
public class ConfigurationController {
    private static final String REDMINE3_REST_KIND = "redmine3.rest";
    private static final String LANG_FIELD_PREFIX = "henix.redminereq.fields.";
    private static final String REQUIREMENT_VERSION_LINK_TYPE_LABEL = "requirement-version.link.type";
    private static final String REGULAR_LINK_TYPE_VALUE_FORMAT = "%1s - %2s (%3s - %4s)";
    private static final String CRITICALITY_MINOR = "minor";
    private static final String CRITICALITY_MAJOR = "major";
    private static final String CRITICALITY_CRITICAL = "critical";
    private static final String CRITICALITY_UNDEFINED = "undefined";
    private static final String STATUS_WORK_IN_PROGRESS = "work_in_progress";
    private static final String STATUS_UNDER_REVIEW = "under_review";
    private static final String STATUS_APPROVED = "approved";
    private static final String STATUS_OBSOLETE = "obsolete";
    private static final String DEF_REQ_CAT = "DEF_REQ_CAT";
    private static final String CONF_YAML_CATEGORY = "category";
    private static final String CONF_YAML_CRITICALITY = "criticality";
    private static final String CONF_YAML_STATUS = "status";
    private static final String REQUEST_BODY_LABEL_VALUE = "value";
    private final BugTrackerManagerService btService;
    private final BugTrackersLocalService bugTrackersLocalService;
    private final InternationalizationHelper i18nhelper;
    private final ConfigurationService pluginService;
    private final CustomFieldBindingFinderService cufService;
    private final GenericProjectFinder genericProjectFinder;
    private final ProjectFinder projectFinder;
    private final LinkedRequirementVersionManagerService linkedRequirementVersionManagerService;

    public ConfigurationController(BugTrackerManagerService btService, BugTrackersLocalService bugTrackersLocalService, InternationalizationHelper i18nhelper, ConfigurationService pluginService, CustomFieldBindingFinderService cufService, GenericProjectFinder genericProjectFinder, ProjectFinder projectFinder, LinkedRequirementVersionManagerService linkedRequirementVersionManagerService) {
        this.btService = btService;
        this.bugTrackersLocalService = bugTrackersLocalService;
        this.i18nhelper = i18nhelper;
        this.pluginService = pluginService;
        this.cufService = cufService;
        this.genericProjectFinder = genericProjectFinder;
        this.projectFinder = projectFinder;
        this.linkedRequirementVersionManagerService = linkedRequirementVersionManagerService;
    }

    @GetMapping
    @ResponseBody
    public ConfigPageConfiguration getConfigurationPanel(@PathVariable Long projectId) {
        ConfigPageConfiguration pageconf = new ConfigPageConfiguration();
        pageconf.setProjectId(projectId);
        List bugtrackers = this.btService.findByKind(REDMINE3_REST_KIND);
        pageconf.setServers(this.toRestServers(bugtrackers));
        Map<String, String> fieldList = this.makeFieldList(projectId);
        pageconf.setAvailableFields(fieldList);
        Map<String, String> redmineLinksFieldList = this.makeRedmineLinksFieldList();
        pageconf.setAvailableRedmineLinksFields(redmineLinksFieldList);
        Map<Long, String> types = this.makeLinkTypesList();
        pageconf.setLinkTypes(types);
        Map<String, List<String>> valueMappings = this.makeValueMappingsList(projectId);
        pageconf.setValueMappingsHelper(valueMappings);
        Configuration conf = this.pluginService.getConfigurationForProject(projectId);
        pageconf.setConfiguration(conf);
        return pageconf;
    }

    @PostMapping(value={"/server"}, params={"value"})
    @ResponseBody
    public void setServer(@PathVariable(value="projectId") Long projectId, @RequestParam(value="value") Long serverId) {
        this.pluginService.setServerId(projectId, serverId);
    }

    @GetMapping(value={"/server"})
    @ResponseBody
    public ResponseEntity<AuthenticationBugTracker> getServer(@PathVariable(value="projectId") long requirementLibraryId) {
        Long projectId = this.projectFinder.findByRequirementLibraryId(requirementLibraryId);
        Configuration conf = this.pluginService.getConfigurationForProject(projectId);
        Long serverId = conf.getServerId();
        BugTracker bt = this.btService.findById(serverId.longValue());
        AuthenticationStatus status = this.bugTrackersLocalService.checkAuthenticationStatus(serverId);
        AuthenticationBugTracker authBugTracker = new AuthenticationBugTracker(serverId, bt.getAuthenticationProtocol(), status);
        if (serverId == 0L) {
            return new ResponseEntity((Object)authBugTracker, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)authBugTracker, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/systemconf"}, produces={"application/json"})
    @ResponseBody
    public Configuration getSystemConfiguration(@PathVariable(value="projectId") Long projectId) {
        return this.pluginService.getConfigurationForProject(projectId);
    }

    @PostMapping(value={"/conf"})
    @ResponseBody
    public void saveConfig(@PathVariable(value="projectId") Long projectId, @RequestBody Configuration config) {
        this.pluginService.storeConfigurationForProject(projectId, config);
    }

    @PostMapping(value={"/options"})
    @ResponseBody
    public void changeOptions(@PathVariable(value="projectId") Long projectId, @RequestBody ChangeOptionsRequestBody requestBody) {
        this.pluginService.changeOptions(projectId, requestBody.isAllowToDeleteReq());
    }

    @PostMapping(value={"/filters"}, consumes={"application/json"})
    @ResponseBody
    public void addFilter(@PathVariable(value="projectId") Long projectId, @RequestBody FilterBindingDto filter) {
        this.pluginService.addFilter(projectId, filter.toFilterBinding());
    }

    @DeleteMapping(value={"/filters/**"})
    @ResponseBody
    public void removeFilters(@PathVariable(value="projectId") Long projectId, HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String bestMatchPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        AntPathMatcher apm = new AntPathMatcher();
        List<String> filterIds = Arrays.asList(apm.extractPathWithinPattern(bestMatchPattern, path).split(","));
        this.pluginService.removeFiltersById(projectId, filterIds);
    }

    @PostMapping(value={"/filters/key"})
    @ResponseBody
    public void changeFilterKey(@PathVariable Long projectId, @RequestBody ModificationRequestBody patch) {
        this.pluginService.updateFilterKey(projectId, patch.getId(), patch.getValue());
    }

    @PostMapping(value={"/filters/filter"})
    @ResponseBody
    public void changeFilterFilter(@PathVariable Long projectId, @RequestBody ModificationRequestBody patch) {
        this.pluginService.updateFilterFilter(projectId, patch.getId(), patch.getValue());
    }

    @PostMapping(value={"/filters/path"})
    @ResponseBody
    public void changeFilterPath(@PathVariable Long projectId, @RequestBody ModificationRequestBody patch) {
        this.pluginService.updateFilterPath(projectId, patch.getId(), patch.getValue());
    }

    @PostMapping(value={"/links/{id}/squashfield"})
    @ResponseBody
    public void changeLinkSquashField(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") String linkId, @RequestBody Map<String, String> requestBody) {
        this.pluginService.updateFieldLinkSquashField(projectId, linkId, requestBody.get(REQUEST_BODY_LABEL_VALUE));
    }

    @PostMapping(value={"/links/{ids}"})
    @ResponseBody
    public void resetFieldLinks(@PathVariable(value="projectId") Long projectId, @PathVariable(value="ids") List<String> linkIds) {
        this.pluginService.resetFieldLinksByIds(projectId, linkIds);
    }

    @PostMapping(value={"/mappings"})
    @ResponseBody
    public void addFieldMapping(@PathVariable(value="projectId") Long projectId, @RequestBody FieldMapping newMapping) {
        this.pluginService.addFieldMapping(projectId, newMapping);
    }

    @PostMapping(value={"/mappings/squashfield"})
    @ResponseBody
    public void changeMappingSquashField(@PathVariable(value="projectId") Long projectId, @RequestParam(value="id") String mappingId, @RequestBody Map<String, String> requestBody) {
        this.pluginService.updateFieldMappingSquashField(projectId, mappingId, requestBody.get(REQUEST_BODY_LABEL_VALUE));
    }

    @PostMapping(value={"/mappings/redminefield"})
    @ResponseBody
    public void changeMappingRedmineField(@PathVariable(value="projectId") Long projectId, @RequestParam(value="id") String mappingId, @RequestBody Map<String, String> requestBody) {
        this.pluginService.updateFieldMappingRedmineField(projectId, mappingId, requestBody.get(REQUEST_BODY_LABEL_VALUE));
    }

    @DeleteMapping(value={"/mappings/{ids}"})
    @ResponseBody
    public void removeFieldMappings(@PathVariable(value="projectId") Long projectId, @PathVariable(value="ids") List<String> mappingIds) {
        this.pluginService.removeFieldMappingsByIds(projectId, mappingIds);
    }

    @PostMapping(value={"/valuemappings"})
    @ResponseBody
    public void changeValueMappings(@PathVariable(value="projectId") Long projectId, @RequestBody Map<String, String> requestBody) {
        this.pluginService.updateValueMappings(projectId, requestBody.get(REQUEST_BODY_LABEL_VALUE));
    }

    @GetMapping(value={"/valuemappings"})
    @ResponseBody
    public String retrieveValueMappings(@PathVariable(value="projectId") Long projectId) {
        Configuration conf = this.pluginService.getConfigurationForProject(projectId);
        return conf.getYamlFieldvalueMapping();
    }

    private List<RestThirdPartyServer> toRestServers(List<BugTracker> bugtrackers) {
        ArrayList<RestThirdPartyServer> servers = new ArrayList<RestThirdPartyServer>();
        for (BugTracker bt : bugtrackers) {
            RestThirdPartyServer server = new RestThirdPartyServer(bt.getId(), bt.getName(), bt.getUrl());
            servers.add(server);
        }
        servers.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        String nullServerName = this.i18nhelper.internationalize("label.None", LocaleContextHolder.getLocale());
        RestThirdPartyServer nullServer = new RestThirdPartyServer(0L, nullServerName, null);
        servers.add(0, nullServer);
        return servers;
    }

    private Map<String, String> makeFieldList(Long projectId) {
        String code;
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, String> fields = new HashMap<String, String>();
        BuiltinSquashField[] builtinSquashFieldArray = BuiltinSquashField.values();
        int n = builtinSquashFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinSquashField f = builtinSquashFieldArray[n2];
            code = f.toString();
            String label = this.i18nhelper.getMessage(LANG_FIELD_PREFIX + code, null, "translation of " + code, locale);
            fields.put(code, label);
            ++n2;
        }
        List cufs = this.cufService.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.REQUIREMENT_VERSION);
        for (CustomFieldBinding cufB : cufs) {
            CustomField cf = cufB.getCustomField();
            code = cf.getCode();
            String name = cf.getName();
            fields.put(code, name);
        }
        return fields;
    }

    private Map<String, String> makeRedmineLinksFieldList() {
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, String> fields = new HashMap<String, String>();
        BuiltinRedmineLinkField[] builtinRedmineLinkFieldArray = BuiltinRedmineLinkField.values();
        int n = builtinRedmineLinkFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinRedmineLinkField f = builtinRedmineLinkFieldArray[n2];
            String code = f.toString();
            String label = this.i18nhelper.getMessage(LANG_FIELD_PREFIX + code, null, "translation of " + code, locale);
            fields.put(code, label);
            ++n2;
        }
        return fields;
    }

    private Map<Long, String> makeLinkTypesList() {
        List requirementVersionLinkTypes = this.linkedRequirementVersionManagerService.getAllReqVersionLinkTypes();
        HashMap<Long, String> types = new HashMap<Long, String>();
        for (RequirementVersionLinkType req : requirementVersionLinkTypes) {
            String role1 = this.tryRoleInternationalization(req.getRole1());
            String role2 = this.tryRoleInternationalization(req.getRole2());
            String typeValue = REGULAR_LINK_TYPE_VALUE_FORMAT.formatted(role1, role2, req.getRole1Code(), req.getRole2Code());
            types.put(req.getId(), typeValue);
        }
        return types;
    }

    private String tryRoleInternationalization(String role) {
        if (role.contains(REQUIREMENT_VERSION_LINK_TYPE_LABEL)) {
            role = this.i18nhelper.internationalize(role, LocaleContextHolder.getLocale());
        }
        return role;
    }

    private Map<String, List<String>> makeValueMappingsList(Long projectId) {
        LinkedHashMap<String, List<String>> valueMappings = new LinkedHashMap<String, List<String>>();
        GenericProject p = this.genericProjectFinder.findById(projectId.longValue());
        InfoList categories = p.getRequirementCategories();
        List<String> strCrits = Arrays.asList(CRITICALITY_CRITICAL, CRITICALITY_MAJOR, CRITICALITY_MINOR, CRITICALITY_UNDEFINED);
        List<String> strStats = Arrays.asList(STATUS_WORK_IN_PROGRESS, STATUS_UNDER_REVIEW, STATUS_APPROVED, STATUS_OBSOLETE);
        ArrayList<String> strCats = new ArrayList<String>(categories.getItems().size());
        boolean canLowercase = categories.getCode().equals(DEF_REQ_CAT);
        for (InfoListItem item : categories.getItems()) {
            String code = canLowercase ? item.getCode().toLowerCase() : item.getCode();
            strCats.add(code);
        }
        valueMappings.put(CONF_YAML_CRITICALITY, strCrits);
        valueMappings.put(CONF_YAML_CATEGORY, strCats);
        valueMappings.put(CONF_YAML_STATUS, strStats);
        return valueMappings;
    }

    static class ChangeOptionsRequestBody {
        boolean allowToDeleteReq;

        ChangeOptionsRequestBody() {
        }

        public boolean isAllowToDeleteReq() {
            return this.allowToDeleteReq;
        }

        public void setAllowToDeleteReq(boolean allowToDeleteReq) {
            this.allowToDeleteReq = allowToDeleteReq;
        }
    }

    static class ModificationRequestBody {
        String id;
        String value;

        ModificationRequestBody() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

