/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.service;

import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.bugtracker.advanceddomain.exception.InvalidRemoteIssueSearchRequestException;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsValueCacheManager;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClient;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.GenericListResponse;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Process;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItem;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItemType;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.ProjectNameFormatter;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.RemoteIssueContextFormatter;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.AzureDevOpsAdvancedIssue;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.CommonReferenceNames;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.ProjectReferentialData;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.SchemeBuilder;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.SquashCompositeKey;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.WorkItemDefinition;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.service.AzureDevOpsService;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.utils.ExceptionHandler;

@Service(value="squash.tm.plugin.bugtracker.azure.devops.AzureDevOpsServiceImpl")
public class AzureDevOpsServiceImpl
implements AzureDevOpsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureDevOpsServiceImpl.class);
    private static final String PROJECT_PATH = "projectPath";
    private static final String KEY = "key";
    private final RemoteIssueContextFormatter remoteIssueContextFormatter;
    private final SchemeBuilder schemeBuilder;
    private final MessageSource messageSource;
    private final ExceptionHandler exceptionHandler;
    private final AzureDevopsValueCacheManager azureDevopsValueCacheManager;

    public AzureDevOpsServiceImpl(RemoteIssueContextFormatter remoteIssueContextFormatter, @Named(value="squash.tm.plugin.bugtracker.azure.devops.SchemeBuilder") SchemeBuilder schemeBuilder, @Named(value="azureDevOpsConnectorMessageSource") MessageSource messageSource, ExceptionHandler exceptionHandler, AzureDevopsValueCacheManager azureDevopsValueCacheManager) {
        this.remoteIssueContextFormatter = remoteIssueContextFormatter;
        this.schemeBuilder = schemeBuilder;
        this.messageSource = messageSource;
        this.exceptionHandler = exceptionHandler;
        this.azureDevopsValueCacheManager = azureDevopsValueCacheManager;
    }

    @Override
    public AdvancedIssue createIssue(RemoteIssue remoteIssue, AzureDevOpsClient client) {
        if (!(remoteIssue instanceof AdvancedIssue)) {
            throw new RuntimeException("Expected AdvancedIssue");
        }
        AdvancedIssue advancedIssue = (AdvancedIssue)remoteIssue;
        WorkItemDefinition workItemDefinition = WorkItemDefinition.from(advancedIssue);
        WorkItem newItem = client.createWorkItem(workItemDefinition);
        advancedIssue.setId(this.buildSquashId(workItemDefinition.organizationName, workItemDefinition.projectName, newItem.getId()));
        return advancedIssue;
    }

    private String buildSquashId(String organizationName, String projectName, String issueId) {
        return new SquashCompositeKey(organizationName, projectName, issueId).toString();
    }

    @Override
    public AzureDevOpsAdvancedIssue createIssueReportTemplate(String projectPath, RemoteIssueContext context, AzureDevOpsClient client, BugTracker bugTracker) {
        ProjectReferentialData projectReferentialData = this.getProjectReferentialData(projectPath, client);
        AzureDevOpsAdvancedIssue issue = this.getAdvancedIssueBase(this.getDetailedAzureDevOpsProject(projectReferentialData, client, bugTracker));
        issue.setRemoteIssueContext(context);
        issue.setCurrentScheme(CommonReferenceNames.WorkItemType.value + ":" + projectReferentialData.workItemTypes.get(0).getName());
        String description = context != null ? this.remoteIssueContextFormatter.buildDescription(context) : "";
        projectReferentialData.workItemTypes.forEach(workItemType -> {
            String prefixedKey = SchemeBuilder.buildPrefixedId(workItemType, CommonReferenceNames.Description.value);
            issue.setFieldValue(prefixedKey, new FieldValue(null, description));
        });
        this.appendPrefixedDefaultValues(projectReferentialData, (AdvancedIssue)issue);
        issue.setHasLastCacheUpdateFailed(this.azureDevopsValueCacheManager.hasLastCacheUpdateFailed(bugTracker.getId(), projectPath));
        return issue;
    }

    private AdvancedProject getDetailedAzureDevOpsProject(ProjectReferentialData projectReferentialData, AzureDevOpsClient client, BugTracker bugTracker) {
        Map<String, List<Field>> schemes = this.schemeBuilder.buildSchemes(projectReferentialData, client, bugTracker);
        String projectPath = projectReferentialData.getProjectPath();
        return AdvancedProject.create((String)projectPath, (String)ProjectNameFormatter.projectPathToDisplayValue(projectPath), schemes);
    }

    private void appendPrefixedDefaultValues(ProjectReferentialData projectReferentialData, AdvancedIssue issue) {
        projectReferentialData.workItemTypes.forEach(wit -> wit.getAzureDevOpsFieldList().forEach(field -> {
            String defaultValue = field.getDefaultValue();
            if (defaultValue != null) {
                String fullRefName = SchemeBuilder.buildPrefixedId(wit, field.getReferenceName());
                issue.setFieldValue(fullRefName, new FieldValue(defaultValue, defaultValue));
            }
        }));
    }

    private AzureDevOpsAdvancedIssue getAdvancedIssueBase(AdvancedProject advancedProject) {
        AzureDevOpsAdvancedIssue advancedIssue = new AzureDevOpsAdvancedIssue();
        advancedIssue.setProject(advancedProject);
        return advancedIssue;
    }

    @Override
    public ProjectReferentialData getProjectReferentialData(String projectPath, AzureDevOpsClient client) {
        Project project = client.findProject(projectPath);
        String processId = client.getProjectProcessTemplateTypeId(projectPath, project.getId());
        String organizationName = Project.extractOrganizationName(projectPath);
        GenericListResponse<WorkItemType> workItemTypes = client.getWorkItemTypes(organizationName, processId);
        Process process = client.getProcess(organizationName, processId);
        Process rootProcess = this.findRootProcess(organizationName, process, client);
        for (WorkItemType wit : workItemTypes.getValue()) {
            wit.setAzureDevOpsFieldList(client.getWorkItemTypeFields(organizationName, project.getName(), wit.getName()));
        }
        return new ProjectReferentialData(organizationName, project, processId, workItemTypes.getValue(), process, rootProcess);
    }

    private Process findRootProcess(String organizationName, Process process, AzureDevOpsClient client) {
        Process currentProcess = process;
        while (currentProcess.getCustomizationType().equals("inherited")) {
            currentProcess = client.getProcess(organizationName, currentProcess.getParentProcessTypeId());
        }
        return currentProcess;
    }

    @Override
    public List<AdvancedIssue> findKnownIssues(List<String> issueKeys, AzureDevOpsClient client) {
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, List> issueIdByProjectPath = new HashMap<String, List>();
        for (String key : issueKeys) {
            SquashCompositeKey compositeKey = SquashCompositeKey.fromString(key);
            String projectPath2 = compositeKey.getProjectPath();
            String issueId = compositeKey.workItemId;
            issueIdByProjectPath.computeIfAbsent(projectPath2, k -> new ArrayList());
            ((List)issueIdByProjectPath.get(projectPath2)).add(issueId);
        }
        ArrayList<AdvancedIssue> result = new ArrayList<AdvancedIssue>();
        issueIdByProjectPath.forEach((projectPath, issueIds) -> {
            try {
                AdvancedProject project = AdvancedProject.create((String)projectPath, (String)ProjectNameFormatter.projectPathToDisplayValue(projectPath), Collections.emptyMap());
                GenericListResponse<WorkItem> items = client.findWorkItems((String)projectPath, (List<String>)issueIds);
                List advancedIssues = items.getValue().stream().map(item -> this.convertToKnownIssue((WorkItem)item, (String)projectPath, project)).collect(Collectors.toList());
                result.addAll(advancedIssues);
                if (items.getCount() < (long)issueIds.size()) {
                    this.stubMissingWorkItems(locale, (List<AdvancedIssue>)result, (String)projectPath, (List<String>)issueIds, project, items);
                }
            }
            catch (Exception e) {
                LOGGER.error("Encountered exception while fetching work items", (Throwable)e);
                this.subWorkItemsWithMissingProject(locale, (List<AdvancedIssue>)result, (String)projectPath, (List<String>)issueIds);
            }
        });
        return result;
    }

    private void subWorkItemsWithMissingProject(Locale locale, List<AdvancedIssue> result, String projectPath, List<String> issueIds) {
        AdvancedProject missingProject = new AdvancedProject();
        missingProject.setName(ProjectNameFormatter.projectPathToDisplayValue(projectPath));
        for (String id : issueIds) {
            AzureDevOpsAdvancedIssue missingIssue = new AzureDevOpsAdvancedIssue();
            missingIssue.setId(SquashCompositeKey.withProjectPath(projectPath, id).toString());
            missingIssue.setProject(missingProject);
            missingIssue.setSummary(this.messageSource.getMessage("interface.table.missing-project.label", null, locale));
            missingIssue.setFieldValue("priority", new FieldValue(null, null));
            missingIssue.setFieldValue("assignee", new FieldValue(null, null));
            result.add((AdvancedIssue)missingIssue);
        }
    }

    private void stubMissingWorkItems(Locale locale, List<AdvancedIssue> result, String projectPath, List<String> issueIds, AdvancedProject project, GenericListResponse<WorkItem> items) {
        List missingIds = issueIds.stream().filter(id -> !items.getValue().stream().map(WorkItem::getId).collect(Collectors.toList()).contains(id)).collect(Collectors.toList());
        for (String id2 : missingIds) {
            AzureDevOpsAdvancedIssue missingIssue = new AzureDevOpsAdvancedIssue();
            missingIssue.setId(SquashCompositeKey.withProjectPath(projectPath, id2).toString());
            missingIssue.setProject(project);
            missingIssue.setSummary(this.messageSource.getMessage("interface.table.missing-issue.label", null, locale));
            missingIssue.setFieldValue("priority", new FieldValue(null, null));
            missingIssue.setFieldValue("assignee", new FieldValue(null, null));
            result.add((AdvancedIssue)missingIssue);
        }
    }

    private AzureDevOpsAdvancedIssue convertToKnownIssue(WorkItem workItem, String projectPath, AdvancedProject project) {
        AzureDevOpsAdvancedIssue advancedIssue = this.getAdvancedIssueBase(project);
        advancedIssue.setId(SquashCompositeKey.withProjectPath(projectPath, workItem.getId()).toString());
        advancedIssue.setCurrentScheme(CommonReferenceNames.WorkItemType.value + ":" + this.getWorkItemType(workItem));
        advancedIssue.setSummary((String)workItem.getFields().get(CommonReferenceNames.Title.value));
        FieldValue descriptionValue = new FieldValue(CommonReferenceNames.Description.value, this.getWorkItemDescription(workItem));
        advancedIssue.setFieldValue(CommonReferenceNames.Description.value, descriptionValue);
        advancedIssue.setFieldValue(this.getWorkItemType(workItem) + "~" + CommonReferenceNames.Description.value, descriptionValue);
        advancedIssue.setFieldValue("priority", new FieldValue(CommonReferenceNames.SeverityKey.value, this.getWorkItemSeverity(workItem)));
        advancedIssue.setFieldValue("status", new FieldValue(CommonReferenceNames.State.value, this.getWorkItemState(workItem)));
        advancedIssue.setFieldValue(CommonReferenceNames.Title.value, new FieldValue(CommonReferenceNames.Title.value, this.getWorkItemTitle(workItem)));
        advancedIssue.setFieldValue("assignee", new FieldValue(null, workItem.getAssigneeDisplayName()));
        return advancedIssue;
    }

    @Override
    public Optional<AdvancedIssue> searchIssue(RemoteIssueSearchRequest searchRequest, AzureDevOpsClient client, BugTracker bugTracker) {
        if (searchRequest.hasSearchTerm(PROJECT_PATH) && searchRequest.hasSearchTerm(KEY)) {
            String projectPath = searchRequest.getSearchTermStringValue(PROJECT_PATH);
            ArrayList<String> expectedWorkItemIds = new ArrayList<String>();
            expectedWorkItemIds.add(searchRequest.getSearchTermStringValue(KEY));
            GenericListResponse<WorkItem> workItemsFound = client.findWorkItems(projectPath, expectedWorkItemIds);
            String expectedWorkItemId = (String)expectedWorkItemIds.getFirst();
            if (workItemsFound.getValue().isEmpty()) {
                throw this.exceptionHandler.workItemNotFound(expectedWorkItemId);
            }
            if (!this.isWorkItemInTargetProject(client, projectPath, workItemsFound)) {
                throw this.exceptionHandler.workItemNotFound(expectedWorkItemId);
            }
            WorkItem workItem = workItemsFound.getValue().getFirst();
            ProjectReferentialData projectReferentialData = this.getProjectReferentialData(projectPath, client);
            AdvancedProject advancedProject = this.getDetailedAzureDevOpsProject(projectReferentialData, client, bugTracker);
            AzureDevOpsAdvancedIssue advancedIssue = this.convertToKnownIssue(workItem, projectPath, advancedProject);
            return Optional.of(advancedIssue);
        }
        throw new InvalidRemoteIssueSearchRequestException("The search terms should contain %s and %s.".formatted(PROJECT_PATH, KEY));
    }

    private boolean isWorkItemInTargetProject(AzureDevOpsClient client, String projectPath, GenericListResponse<WorkItem> workItemsFound) {
        String requiredProjectName = client.findProject(projectPath).getName();
        String workItemProjectName = (String)workItemsFound.getValue().getFirst().getFields().get("System.TeamProject");
        return workItemProjectName.equals(requiredProjectName);
    }

    @Override
    public RemoteIssueSearchForm createIssueSearchForm(BugTrackerBindingInfo bugTrackerBindingInfo) {
        Locale locale = LocaleContextHolder.getLocale();
        String projectPathLabel = this.messageSource.getMessage("interface.attach.project-path.label", null, locale);
        String workItemIdLabel = this.messageSource.getMessage("interface.attach.issue-id.label", null, locale);
        Field projectPathField = new Field(PROJECT_PATH, projectPathLabel);
        InputType inputType = new InputType();
        inputType.setName(InputType.TypeName.COMBO_BOX.value);
        Rendering rendering = new Rendering(new String[0], inputType, true);
        projectPathField.setRendering(rendering);
        projectPathField.setPossibleValues((FieldValue[])bugTrackerBindingInfo.getRemoteProjectNames().stream().map(projectPath -> new FieldValue(projectPath, projectPath)).toArray(FieldValue[]::new));
        Field workItemIdField = RemoteIssueSearchForm.textField((String)KEY, (String)workItemIdLabel);
        workItemIdField.getRendering().setRequired(true);
        return new RemoteIssueSearchForm(Arrays.asList(projectPathField, workItemIdField), KEY, List.of(PROJECT_PATH));
    }

    private String getWorkItemSeverity(WorkItem workItem) {
        return (String)workItem.getFields().get(CommonReferenceNames.SeverityKey.value);
    }

    private String getWorkItemState(WorkItem workItem) {
        return (String)workItem.getFields().get(CommonReferenceNames.State.value);
    }

    private String getWorkItemDescription(WorkItem workItem) {
        return (String)workItem.getFields().get(CommonReferenceNames.Description.value);
    }

    private String getWorkItemType(WorkItem workItem) {
        return (String)workItem.getFields().get(CommonReferenceNames.WorkItemType.value);
    }

    private String getWorkItemTitle(WorkItem workItem) {
        return (String)workItem.getFields().get(CommonReferenceNames.Title.value);
    }
}

