/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.ApiVersion;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClient;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.PathBuilder;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.exception.WrongProjectPathFormatException;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.AzureField;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.FieldDetails;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.FileUploadResponse;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.GenericListResponse;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Layout;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Nodes;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.PicklistField;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Process;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Tag;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Team;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.TeamMember;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Template;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.User;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItem;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItemPath;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItemType;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.JsonPatchBuilder;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.WorkItemDefinition;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.utils.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.utils.RestTemplateFactory;

public class AzureDevOpsClientImpl
implements AzureDevOpsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureDevOpsClientImpl.class);
    private static final String API_VERSION = "api-version";
    private static final String APPLICATION_JSON_PATCH_VALUE = "application/json-patch+json";
    private final RestTemplateFactory restTemplateFactory;
    private RestTemplate restTemplate;
    private final ExceptionHandler exceptionHandler;

    public AzureDevOpsClientImpl(RestTemplateFactory restTemplateFactory, ExceptionHandler exceptionHandler) {
        this.restTemplateFactory = restTemplateFactory;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void init(BugTracker bugTracker, Credentials credentials) {
        if (!AuthenticationProtocol.BASIC_AUTH.equals((Object)credentials.getImplementedProtocol())) {
            throw new IllegalArgumentException("Only Basic Auth credentials are supported.");
        }
        BasicAuthenticationCredentials basicAuthenticationCredentials = (BasicAuthenticationCredentials)credentials;
        this.checkEmptyCredentials(basicAuthenticationCredentials);
        this.restTemplate = this.restTemplateFactory.restTemplate(bugTracker, basicAuthenticationCredentials);
    }

    @Override
    public User getActualUser() {
        String path = "https://app.vssps.visualstudio.com/_apis/profile/profiles/me?api-version=6.0";
        return (User)this.get("https://app.vssps.visualstudio.com/_apis/profile/profiles/me?api-version=6.0", (Type)((Object)User.class));
    }

    @Override
    public GenericListResponse<Project> findAllProjects(String organizationName) {
        String path = PathBuilder.buildProjectsPath(organizationName).build();
        return this.getGenericList(path, Project.class);
    }

    @Override
    public Project findProject(String projectPath) {
        try {
            String organizationName = Project.extractOrganizationName(projectPath);
            String projectName = Project.extractProjectName(projectPath);
            String path = PathBuilder.buildProjectPath(organizationName, projectName).build();
            return (Project)this.get(path, (Type)((Object)Project.class));
        }
        catch (WrongProjectPathFormatException e) {
            throw this.exceptionHandler.wrongProjectPath(e.projectPath);
        }
        catch (Exception e) {
            throw this.exceptionHandler.projectNotFound(projectPath);
        }
    }

    @Override
    public GenericListResponse<WorkItemType> getWorkItemTypes(String organizationName, String processTemplateTypeId) {
        String path = PathBuilder.buildProcessWorkItemTypesPath(organizationName, processTemplateTypeId).withQueryParam(API_VERSION, ApiVersion.v6_1_preview_2.value).build();
        return this.getGenericList(path, WorkItemType.class);
    }

    @Override
    public String getProjectProcessTemplateTypeId(String projectPath, String projectId) {
        String organizationName = Project.extractOrganizationName(projectPath);
        String path = PathBuilder.buildProjectPropertiesPath(organizationName, projectId).withQueryParam("keys", "System.ProcessTemplateType").build();
        ResolvableType resolvableItemType = ResolvableType.forClassWithGenerics(HashMap.class, (Class[])new Class[]{String.class, String.class});
        ResolvableType resolvableListType = ResolvableType.forClassWithGenerics(GenericListResponse.class, (ResolvableType[])new ResolvableType[]{resolvableItemType});
        ParameterizedTypeReference parameterizedTypeReference = ParameterizedTypeReference.forType((Type)resolvableListType.getType());
        GenericListResponse properties = (GenericListResponse)this.get(path, parameterizedTypeReference);
        return this.extractPropertiesStringValue(Objects.requireNonNull(properties));
    }

    @Override
    public Process getProcess(String organizationName, String processId) {
        String path = PathBuilder.buildProcessPath(organizationName, processId).withQueryParam(API_VERSION, ApiVersion.v6_1_preview_2.value).build();
        return (Process)this.get(path, (Type)((Object)Process.class));
    }

    private String extractPropertiesStringValue(GenericListResponse<Map<String, String>> genericList) {
        if (!genericList.getValue().isEmpty()) {
            return genericList.getValue().get(0).get("value");
        }
        throw new RuntimeException("Couldn't extract String value from generic list");
    }

    @Override
    public WorkItem createWorkItem(WorkItemDefinition definition) {
        String typeParameter = "$" + PathBuilder.encodeValue(definition.workItemType);
        String path = PathBuilder.buildWorkItemTypesBasePath(definition.organizationName, definition.projectName, "workitems", typeParameter).withQueryParam(API_VERSION, ApiVersion.v6_0.value).build();
        HttpEntity httpEntity = new HttpEntity(definition.operations, (MultiValueMap)this.getJsonPatchHttpHeaders());
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(path, (Object)httpEntity, WorkItem.class, new Object[0]);
            return (WorkItem)responseEntity.getBody();
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusText().equals("Unauthorized")) {
                throw this.exceptionHandler.missingRightError();
            }
            throw this.exceptionHandler.azureHttpError(ex);
        }
    }

    @Override
    public GenericListResponse<WorkItem> findWorkItems(String projectPath, List<String> ids) {
        try {
            String organizationName = Project.extractOrganizationName(projectPath);
            String projectName = Project.extractProjectName(projectPath);
            String lastPart = "workitems?ids=" + String.join((CharSequence)",", ids);
            String path = PathBuilder.buildWorkItemTypesBasePath(organizationName, projectName, lastPart).build();
            GenericListResponse<WorkItem> workItems = new GenericListResponse();
            try {
                workItems = this.getGenericList(path, WorkItem.class);
            }
            catch (Exception e) {
                for (String id : ids) {
                    try {
                        String specificLastPart = "workitems?ids=" + id;
                        String specificPath = PathBuilder.buildWorkItemTypesBasePath(organizationName, projectName, specificLastPart).build();
                        workItems.getValue().addAll(this.getGenericList(specificPath, WorkItem.class).getValue());
                        workItems.setCount(workItems.getCount() + 1L);
                    }
                    catch (Exception ex) {
                        LOGGER.info(this.exceptionHandler.workItemNotFound(id).getMessage());
                    }
                }
            }
            return workItems;
        }
        catch (WrongProjectPathFormatException e) {
            throw this.exceptionHandler.wrongProjectPath(e.projectPath);
        }
    }

    @Override
    public Set<TeamMember> findTeamMembers(String projectPath, GenericListResponse<Team> teams) {
        List teamIds = teams.getValue().stream().map(Team::getId).collect(Collectors.toList());
        return teamIds.stream().map(teamId -> this.getTeamMembers(projectPath, (String)teamId)).flatMap(teamMembers -> teamMembers.getValue().stream()).collect(Collectors.toSet());
    }

    @Override
    public GenericListResponse<Team> getTeams(String projectPath) {
        String organizationName = Project.extractOrganizationName(projectPath);
        String projectName = Project.extractProjectName(projectPath);
        String path = PathBuilder.buildTeamsPath(organizationName, projectName).withQueryParam(API_VERSION, ApiVersion.v6_0.value).build();
        return this.getGenericList(path, Team.class);
    }

    private GenericListResponse<TeamMember> getTeamMembers(String projectPath, String teamId) {
        String organizationName = Project.extractOrganizationName(projectPath);
        String projectName = Project.extractProjectName(projectPath);
        String path = PathBuilder.buildTeamMembersPath(organizationName, projectName, teamId).withQueryParam(API_VERSION, ApiVersion.v6_0.value).build();
        return this.getGenericList(path, TeamMember.class);
    }

    @Override
    public List<Tag> findAllTags(String projectPath) {
        String organizationName = Project.extractOrganizationName(projectPath);
        GenericListResponse<Project> projects = this.findAllProjects(organizationName);
        ArrayList<Tag> organizationTags = new ArrayList<Tag>();
        projects.getValue().forEach(project -> {
            try {
                GenericListResponse<Tag> projectTags = this.findProjectTags(organizationName, project.getName());
                projectTags.getValue().forEach(tag -> {
                    Optional<Tag> foundTag = organizationTags.stream().filter(existingTag -> existingTag.getName().equals(tag.getName())).findAny();
                    if (foundTag.isEmpty()) {
                        organizationTags.add((Tag)tag);
                    }
                });
            }
            catch (HttpClientErrorException ex) {
                if (ex.getStatusCode().value() == 403) {
                    LOGGER.warn(String.format("Tried to get tags for project '%s' but user is not authorized. These tags will be ignored.", project.getName()), (Throwable)ex);
                }
                LOGGER.warn("Error while getting tags of project '%s'.".formatted(project.getName()), (Throwable)ex);
            }
        });
        return organizationTags;
    }

    @Override
    public GenericListResponse<Tag> findProjectTags(String organizationName, String projectName) {
        String path = PathBuilder.buildWorkItemTypesBasePath(organizationName, projectName, "tags").withQueryParam(API_VERSION, ApiVersion.v6_0_preview_1.value).build();
        return this.getGenericList(path, Tag.class);
    }

    @Override
    public Nodes getProjectAreas(String projectPath) {
        String organizationName = Project.extractOrganizationName(projectPath);
        String projectName = Project.extractProjectName(projectPath);
        String path = PathBuilder.buildWorkItemTypesBasePath(organizationName, projectName, "classificationnodes", "Areas").withQueryParam(API_VERSION, ApiVersion.v6_0.value).withQueryParam("$depth", "7").build();
        try {
            return (Nodes)this.restTemplate.getForObject(path, Nodes.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            throw this.exceptionHandler.azureHttpError(e);
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    @Override
    public Nodes getProjectIterations(String projectPath) {
        String organizationName = Project.extractOrganizationName(projectPath);
        String projectName = Project.extractProjectName(projectPath);
        String path = PathBuilder.buildWorkItemTypesBasePath(organizationName, projectName, "classificationnodes", "Iterations").withQueryParam(API_VERSION, ApiVersion.v6_0.value).withQueryParam("$depth", "7").build();
        try {
            return (Nodes)this.restTemplate.getForObject(path, Nodes.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            throw this.exceptionHandler.azureHttpError(e);
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    @Override
    public List<FieldDetails> getFieldDetails(String organizationName, String projectName, List<AzureField> witFields) {
        GenericListResponse<FieldDetails> allFields = this.getAllProcessFields(organizationName, projectName);
        return witFields.stream().map(azureField -> allFields.getValue().stream().filter(f -> f.getReferenceName().equals(azureField.getReferenceName())).findAny()).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private GenericListResponse<FieldDetails> getAllProcessFields(String organizationName, String projectName) {
        String path = PathBuilder.buildAllFieldsPath(organizationName, projectName).build();
        return this.getGenericList(path, FieldDetails.class);
    }

    @Override
    public List<AzureField> getWorkItemTypeFields(String organizationName, String projectName, String workItemType) {
        String path = PathBuilder.buildWorkItemTypesFields(organizationName, projectName, workItemType).withQueryParam(API_VERSION, ApiVersion.v6_0.value).build();
        try {
            return Objects.requireNonNull((WorkItemType)this.restTemplate.getForObject(path, WorkItemType.class, new Object[0])).getAzureDevOpsFieldList();
        }
        catch (HttpClientErrorException e) {
            throw this.exceptionHandler.azureHttpError(e);
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    @Override
    public List<String> findPickListValues(String organizationName, String processTemplateTypeId, String witRefName, String fieldRefName) {
        String path = PathBuilder.buildExpandedWorkItemFieldPath(organizationName, processTemplateTypeId, witRefName, fieldRefName).withQueryParam("$expand", "All").withQueryParam(API_VERSION, ApiVersion.v6_1_preview_2.value).build();
        try {
            PicklistField pickListField = (PicklistField)this.restTemplate.getForObject(path, PicklistField.class, new Object[0]);
            assert (pickListField != null);
            return pickListField.getAllowedValues();
        }
        catch (HttpClientErrorException e) {
            throw this.exceptionHandler.azureHttpError(e);
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    @Override
    public FileUploadResponse uploadFile(WorkItemPath workItemPath, File tempFile) throws IOException {
        GenericListResponse<WorkItem> workItems = this.findWorkItems(workItemPath.getProjectPath(), Collections.singletonList(workItemPath.workItemId));
        this.messageConverter(this.restTemplate);
        if (workItems.getValue().size() > 0) {
            String organizationName = workItemPath.getOrganizationName();
            String projectName = workItemPath.getProjectName();
            String path = PathBuilder.buildWorkItemTypesBasePath(organizationName, projectName, "attachments").withQueryParam("fileName", URLEncoder.encode(tempFile.getName(), StandardCharsets.UTF_8.name())).withQueryParam("uploadType", "Simple").withQueryParam(API_VERSION, ApiVersion.v6_1_preview_3.value).build();
            HttpEntity requestEntity = new HttpEntity((Object)Files.readAllBytes(tempFile.toPath()), (MultiValueMap)this.getAttachmentHeaders());
            try {
                ResponseEntity responseEntity = this.restTemplate.exchange(path, HttpMethod.POST, requestEntity, FileUploadResponse.class, new Object[0]);
                return (FileUploadResponse)responseEntity.getBody();
            }
            catch (Exception e) {
                throw this.exceptionHandler.cantUploadFile(tempFile.getName());
            }
        }
        throw new BugTrackerRemoteException("Cannot find work item with ID '%s'.".formatted(workItemPath.workItemId), null);
    }

    @Override
    public void linkAttachmentToWorkItem(List<String> urls, WorkItemPath workItemPath) {
        String path = PathBuilder.buildWorkItemTypesBasePath(workItemPath.getOrganizationName(), workItemPath.getProjectName(), "workitems", workItemPath.workItemId).withQueryParam(API_VERSION, ApiVersion.v6_0.value).build();
        JsonPatchBuilder jsonPatchBuilder = new JsonPatchBuilder();
        urls.forEach(url -> {
            String fixedUrl = this.fixUrlWithHashInFileName((String)url);
            HashMap<String, Map<String, String>> attachedFile = new HashMap<String, Map<String, String>>(Map.of("rel", "AttachedFile", "url", fixedUrl, "attributes", Collections.singletonMap("comment", "")));
            jsonPatchBuilder.add("/relations/-", attachedFile);
        });
        HttpEntity httpEntity = new HttpEntity(jsonPatchBuilder.getOperations(), (MultiValueMap)this.getJsonPatchHttpHeaders());
        this.restTemplate.patchForObject(path, (Object)httpEntity, WorkItem.class, new Object[0]);
    }

    public String fixUrlWithHashInFileName(String url) {
        String fileNameInUrl = "fileName=";
        if (url.contains(fileNameInUrl)) {
            int fileNameStart = url.indexOf(fileNameInUrl) + fileNameInUrl.length();
            int fileNameEnd = url.indexOf("&", fileNameStart);
            if (fileNameEnd == -1) {
                fileNameEnd = url.length();
            }
            String fileNameValue = url.substring(fileNameStart, fileNameEnd);
            String fixedFileNameValue = fileNameValue.replace("#", "%23");
            return url.substring(0, fileNameStart) + fixedFileNameValue + url.substring(fileNameEnd);
        }
        return url;
    }

    @Override
    public Layout getLayout(String organizationName, String processId, String witRefName) {
        String path = PathBuilder.buildLayoutPath(organizationName, processId, witRefName).withQueryParam(API_VERSION, ApiVersion.v6_0_preview_1.value).build();
        return (Layout)this.get(path, (Type)((Object)Layout.class));
    }

    @Override
    public GenericListResponse<Template> getTemplates(String organizationName, String projectId, String teamIdOrName) {
        String path = PathBuilder.buildTemplatesPath(organizationName, projectId, teamIdOrName).withQueryParam(API_VERSION, ApiVersion.v6_0_preview_1.value).build();
        return this.getGenericList(path, Template.class);
    }

    @Override
    public Template getTemplateFields(String url) {
        return (Template)this.get(url, (Type)((Object)Template.class));
    }

    private <T> GenericListResponse<T> getGenericList(String path, Class<T> itemClass) {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(GenericListResponse.class, (Class[])new Class[]{itemClass});
        return (GenericListResponse)this.get(path, resolvableType.getType());
    }

    private <T> T get(String path, Type type) {
        ParameterizedTypeReference parameterizedTypeReference = ParameterizedTypeReference.forType((Type)type);
        return this.get(path, parameterizedTypeReference);
    }

    private <T> T get(String path, ParameterizedTypeReference<T> parameterizedTypeReference) {
        HttpEntity<?> entity = this.getHttpEntity();
        ResponseEntity responseEntity = this.restTemplate.exchange(path, HttpMethod.GET, entity, parameterizedTypeReference, new Object[0]);
        try {
            return (T)responseEntity.getBody();
        }
        catch (HttpClientErrorException e) {
            throw this.exceptionHandler.azureHttpError(e);
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    private HttpEntity<?> getHttpEntity() {
        HttpHeaders headers = this.getHttpHeaders();
        return new HttpEntity((MultiValueMap)headers);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        return headers;
    }

    private HttpHeaders getJsonPatchHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        headers.set("Content-Type", APPLICATION_JSON_PATCH_VALUE);
        return headers;
    }

    private HttpHeaders getAttachmentHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return headers;
    }

    private HttpHeaders getAttachmentChunkHeaders(Long fileLength) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentLength(fileLength.longValue());
        return headers;
    }

    private void messageConverter(RestTemplate restTemplate) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM));
        restTemplate.getMessageConverters().add(converter);
    }

    private void checkEmptyCredentials(BasicAuthenticationCredentials credentials) {
        if (credentials == null) {
            throw new NullArgumentException("credentials");
        }
        String username = credentials.getUsername();
        String password = String.valueOf(credentials.getPassword());
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new NullArgumentException("username");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new NullArgumentException("password");
        }
    }
}

