/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.squashtest.tm.plugin.bugtracker.azuredevops.licensevalidator.LicenseValidator;

@Component(value="org.squashtest.tm.plugin.azuredevops.PluginValidator")
public class PluginValidator
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginValidator.class);
    private static final String BUGTRACKER_AZURE_DEVOPS = "bugtracker-azure-devops";
    @Inject
    @Named(value="org.squashtest.tm.plugin.bugtracker.azuredevops.LicenseValidator")
    private LicenseValidator validator;
    @Inject
    private Environment environment;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Boolean isLogUsed = Boolean.valueOf(this.environment.getProperty("squash.validator.log.activate"));
        if (isLogUsed.booleanValue()) {
            LOGGER.debug("Plugin Validator has been enabled for plugin {}...", (Object)BUGTRACKER_AZURE_DEVOPS);
        }
        this.validator.validate(BUGTRACKER_AZURE_DEVOPS);
    }
}

