/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.impl.AuthnStatementValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Statement;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.DefaultSaml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.plugin.saml.SAMLProviderFeatures;
import org.squashtest.tm.plugin.saml.SquashSAMLUserDetailsService;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformation;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformationSAMLExpirationToken;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformationUser;
import org.squashtest.tm.plugin.saml.beans.FeatureAwareSAMLExpirationToken;
import org.squashtest.tm.plugin.saml.properties.SessionProperties;

public class SquashSamlAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashSamlAuthenticationProvider.class);
    private final OpenSaml4AuthenticationProvider delegate;
    private final SquashSAMLUserDetailsService samlUserDetailsService;
    private final SAMLProviderFeatures features;

    public SquashSamlAuthenticationProvider(OpenSaml4AuthenticationProvider delegate, SquashSAMLUserDetailsService samlUserDetailsService, SAMLProviderFeatures features) {
        this.delegate = delegate;
        this.samlUserDetailsService = samlUserDetailsService;
        this.features = features;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Saml2Authentication samlAuthentication = (Saml2Authentication)this.delegate.authenticate(authentication);
        UserDetails userDetails = this.samlUserDetailsService.loadUserBySAML((DefaultSaml2AuthenticatedPrincipal)samlAuthentication.getPrincipal());
        return this.authenticate(samlAuthentication, userDetails);
    }

    private FeatureAwareSAMLExpirationToken authenticate(Saml2Authentication authentication, UserDetails user) throws AuthenticationException {
        FeatureAwareSAMLExpirationToken augmentedAuth;
        if (this.containsExtraInfo(user)) {
            ExtraAccountInformation extraInformation = this.retrieveExtraInformation(user);
            augmentedAuth = new ExtraAccountInformationSAMLExpirationToken(authentication, this.features, user.getAuthorities(), extraInformation);
        } else {
            augmentedAuth = new FeatureAwareSAMLExpirationToken(authentication, this.features, user.getAuthorities());
        }
        return augmentedAuth;
    }

    private boolean containsExtraInfo(UserDetails user) {
        return ExtraAccountInformationUser.class.isAssignableFrom(user.getClass());
    }

    private ExtraAccountInformation retrieveExtraInformation(UserDetails user) {
        return ((ExtraAccountInformationUser)user).getExtraInformation();
    }

    public void setAssertionValidator(SessionProperties sessionProperties) {
        this.delegate.setAssertionValidator(assertionToken -> {
            Saml2ResponseValidatorResult result = (Saml2ResponseValidatorResult)OpenSaml4AuthenticationProvider.createDefaultAssertionValidatorWithParameters(params -> {
                params.put("saml2.ClockSkew", Duration.ofSeconds(sessionProperties.getClockSkew()));
                params.put("saml2.Lifetime", Duration.ofSeconds(sessionProperties.getMaxAssertionTime()));
            }).convert(assertionToken);
            if (result == null) {
                throw new IllegalArgumentException("Assertion validation failed");
            }
            if (result.hasErrors()) {
                return result;
            }
            Saml2ResponseValidatorResult customResult = this.validateAuthnStatements((OpenSaml4AuthenticationProvider.AssertionToken)assertionToken, sessionProperties);
            return result.concat(customResult);
        });
    }

    private Saml2ResponseValidatorResult validateAuthnStatements(OpenSaml4AuthenticationProvider.AssertionToken assertionToken, SessionProperties sessionProperties) {
        Assertion assertion = assertionToken.getAssertion();
        List authnStatements = assertion.getAuthnStatements();
        if (authnStatements == null || authnStatements.isEmpty()) {
            return Saml2ResponseValidatorResult.success();
        }
        AuthnStatementValidator authnStatementValidator = new AuthnStatementValidator();
        ValidationContext context = new ValidationContext(Map.of("saml2.Statement.Authn.MaxTimeSinceAuthn", Duration.ofSeconds(sessionProperties.getMaxAuthTime())));
        for (AuthnStatement statement : authnStatements) {
            try {
                ValidationResult validationResult = authnStatementValidator.validate((Statement)statement, assertion, context);
                if (validationResult == ValidationResult.VALID) continue;
                String message = "Invalid assertion for SAML response: Authentication statement is too old";
                return Saml2ResponseValidatorResult.failure((Saml2Error[])new Saml2Error[]{new Saml2Error("invalid_assertion", message)});
            }
            catch (Exception e) {
                LOGGER.error("Error validating SAML AuthnStatement", (Throwable)e);
                String message = "Invalid assertion for SAML response: %s".formatted(e.getMessage());
                return Saml2ResponseValidatorResult.failure((Saml2Error[])new Saml2Error[]{new Saml2Error("invalid_assertion", message)});
            }
        }
        return Saml2ResponseValidatorResult.success();
    }

    public boolean supports(Class<?> authentication) {
        return this.delegate.supports(authentication);
    }
}

