/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2MetadataConfigurer;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSaml4AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.squashtest.tm.plugin.saml.SAMLActivationSwitch;
import org.squashtest.tm.plugin.saml.SAMLProviderFeatures;
import org.squashtest.tm.plugin.saml.SquashSAMLUserDetailsService;
import org.squashtest.tm.plugin.saml.SquashSamlProviderPostProcessor;
import org.squashtest.tm.plugin.saml.config.SamlLoginRedirectFilter;
import org.squashtest.tm.plugin.saml.properties.DefaultWebSSOProfileOptions;
import org.squashtest.tm.plugin.saml.properties.MetadataProperties;
import org.squashtest.tm.plugin.saml.properties.ReverseProxyProperties;
import org.squashtest.tm.plugin.saml.properties.SAMLProperties;
import org.squashtest.tm.plugin.saml.properties.SPProperties;

@Configuration
@EnableConfigurationProperties(value={SAMLProperties.class})
@SAMLActivationSwitch
public class SAMLConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAMLConfig.class);
    public static final String SAML_PROVIDER_NAME = "saml";
    private static final String METADATA_URL = "/auth/saml/metadata/{registrationId}";
    private static final String LOGIN_PROCESSING_URL = "/auth/saml/sso/{registrationId}";
    private static final String SINGLE_LOGOUT_PROCESSING_URL = "/auth/saml/SingleLogout";
    private static final String AUTHENTICATION_REQUEST_URI = "/auth/saml/login/{registrationId}";
    private final SAMLProperties samlProperties;
    private final UserDetailsService userDetailsService;

    public SAMLConfig(SAMLProperties samlProperties, UserDetailsService userDetailsService) {
        this.samlProperties = samlProperties;
        this.userDetailsService = userDetailsService;
    }

    @Bean
    @Order(value=28)
    public SecurityFilterChain samlSecurityFilterChain(HttpSecurity http) throws Exception {
        http.securityMatcher(new String[]{"/auth/saml/**"}).authorizeHttpRequests(authz -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new String[]{"/auth/saml/authentication-failure"})).permitAll().anyRequest()).authenticated();
        }).saml2Login(saml2 -> {
            AbstractAuthenticationFilterConfigurer abstractAuthenticationFilterConfigurer = ((Saml2LoginConfigurer)((Saml2LoginConfigurer)saml2.withObjectPostProcessor((ObjectPostProcessor)new SquashSamlProviderPostProcessor(this.samlUserDetailsService(), this.samlProviderFeatures(), this.samlProperties.getSession()))).loginProcessingUrl(LOGIN_PROCESSING_URL).authenticationRequestUriQuery(AUTHENTICATION_REQUEST_URI).successHandler((AuthenticationSuccessHandler)this.samlSuccessRedirectHandler())).failureHandler((AuthenticationFailureHandler)this.samlAuthenticationFailureHandler());
        }).saml2Metadata(saml2 -> {
            Saml2MetadataConfigurer saml2MetadataConfigurer = saml2.metadataUrl(METADATA_URL);
        }).saml2Logout(logout -> {
            Saml2LogoutConfigurer saml2LogoutConfigurer = logout.logoutRequest(req -> {
                Saml2LogoutConfigurer.LogoutRequestConfigurer logoutRequestConfigurer = req.logoutUrl(SINGLE_LOGOUT_PROCESSING_URL);
            });
        });
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public Saml2AuthenticationRequestResolver authenticationRequestResolver(RelyingPartyRegistrationRepository registrations) {
        DefaultRelyingPartyRegistrationResolver registrationResolver = new DefaultRelyingPartyRegistrationResolver(registrations);
        OpenSaml4AuthenticationRequestResolver resolver = new OpenSaml4AuthenticationRequestResolver((RelyingPartyRegistrationResolver)registrationResolver);
        resolver.setRequestMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher(AUTHENTICATION_REQUEST_URI));
        DefaultWebSSOProfileOptions sso = this.samlProperties.getSso();
        resolver.setAuthnRequestCustomizer(context -> sso.configureAuthnRequest(context.getAuthnRequest()));
        if (sso.containRelayState()) {
            resolver.setRelayStateResolver(request -> request.getParameter(sso.getRelayState()));
        }
        return resolver;
    }

    @Bean
    public SquashSAMLUserDetailsService samlUserDetailsService() {
        return new SquashSAMLUserDetailsService(this.samlProperties.getUserMapping(), this.userDetailsService);
    }

    @Bean
    public RelyingPartyRegistrationRepository relyingPartyRegistrations() {
        LOGGER.info("initializing : relyingPartyRegistrationRepository");
        String idpMetadataUrl = this.samlProperties.getIdp().getMetadataUrl();
        SPProperties sp = this.samlProperties.getSp();
        MetadataProperties spMetadata = sp.getMetadata();
        String baseUrl = this.buildBaseUrl();
        RelyingPartyRegistration.Builder builder = RelyingPartyRegistrations.fromMetadataLocation((String)idpMetadataUrl).registrationId(sp.getRegistrationId()).entityId(sp.getEntityId()).assertionConsumerServiceLocation(baseUrl + LOGIN_PROCESSING_URL).singleLogoutServiceLocation(baseUrl + SINGLE_LOGOUT_PROCESSING_URL);
        this.configureCredentials(builder);
        spMetadata.configureAdditionalProperties(builder);
        return new InMemoryRelyingPartyRegistrationRepository(new RelyingPartyRegistration[]{builder.build()});
    }

    private String buildBaseUrl() {
        ReverseProxyProperties proxy = this.samlProperties.getProxy();
        if (!proxy.isEnabled()) {
            return "{baseUrl}";
        }
        LOGGER.trace("Building base URL with proxy settings");
        StringBuilder baseUrl = new StringBuilder();
        baseUrl.append(proxy.getScheme()).append("://").append(proxy.getServerName());
        if (proxy.isIncludePortInUrl()) {
            baseUrl.append(":").append(proxy.getServerPort());
        }
        baseUrl.append(proxy.getContextPath());
        return baseUrl.toString();
    }

    private void configureCredentials(RelyingPartyRegistration.Builder builder) {
        MetadataProperties spMetadata = this.samlProperties.getSp().getMetadata();
        try {
            RSAPrivateKey privateKey = this.readPrivateKey(spMetadata.getPrivateKey());
            X509Certificate certificate = this.readCertificate(spMetadata.getCertificate());
            Saml2X509Credential signingCredential = Saml2X509Credential.signing((PrivateKey)privateKey, (X509Certificate)certificate);
            Saml2X509Credential decryptionCredential = Saml2X509Credential.decryption((PrivateKey)privateKey, (X509Certificate)certificate);
            builder.signingX509Credentials(creds -> {
                boolean bl = creds.add(signingCredential);
            });
            builder.decryptionX509Credentials(creds -> {
                boolean bl = creds.add(decryptionCredential);
            });
        }
        catch (Exception e) {
            throw new Saml2Exception("Error loading credentials", (Throwable)e);
        }
    }

    private RSAPrivateKey readPrivateKey(Resource location) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = location.getInputStream();){
                return (RSAPrivateKey)RsaKeyConverters.pkcs8().convert((Object)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private X509Certificate readCertificate(Resource location) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = location.getInputStream();){
                return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Bean
    @ConditionalOnProperty(value={"authentication.provider"}, havingValue="saml")
    public SamlLoginRedirectFilter samlLoginRedirectFilter() {
        LOGGER.info("initializing : samlLoginRedirectFilter");
        return new SamlLoginRedirectFilter(this.samlProperties.getSp().getRegistrationId());
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler samlSuccessRedirectHandler() {
        LOGGER.info("initializing : samlSuccessRedirectHandler");
        SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successRedirectHandler.setDefaultTargetUrl("/home-workspace");
        return successRedirectHandler;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler samlAuthenticationFailureHandler() {
        LOGGER.info("initializing : samlAuthenticationFailureHandler");
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setDefaultFailureUrl("/auth/saml/authentication-failure");
        return failureHandler;
    }

    @Bean
    public SAMLProviderFeatures samlProviderFeatures() {
        return new SAMLProviderFeatures();
    }
}

