/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.client;

import gitlabbt.org.gitlab4j.api.AncestorEpicsApi;
import gitlabbt.org.gitlab4j.api.AncestorMilestonesApi;
import gitlabbt.org.gitlab4j.api.ExtendedIssueApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.models.Epic;
import gitlabbt.org.gitlab4j.api.models.FileUpload;
import gitlabbt.org.gitlab4j.api.models.Issue;
import gitlabbt.org.gitlab4j.api.models.IssueFilter;
import gitlabbt.org.gitlab4j.api.models.IssueLink;
import gitlabbt.org.gitlab4j.api.models.Label;
import gitlabbt.org.gitlab4j.api.models.LinkType;
import gitlabbt.org.gitlab4j.api.models.Milestone;
import gitlabbt.org.gitlab4j.api.models.Project;
import gitlabbt.org.gitlab4j.api.models.ProjectUser;
import gitlabbt.org.gitlab4j.api.models.TreeItem;
import gitlabbt.org.gitlab4j.api.models.Version;
import gitlabbt.org.gitlab4j.models.Constants;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.exception.issue.WrongIdFormatException;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiProvider;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.GitLabIssueCreationParameters;

public class GitLabApiWrapper
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabApiWrapper.class);
    private static final String TEMP_DIRECTORY_PREFIX = "gitlab-uploads";
    private static final String DESCRIPTION_TEMPLATES_PATH = ".gitlab/issue_templates";
    private static final String MARKDOWN_EXTENSION = ".md";
    private final BugTracker bugTracker;
    private final GitLabApi gitLabApi;

    public GitLabApiWrapper(BugTracker bugTracker, Credentials credentials) {
        this.bugTracker = bugTracker;
        this.gitLabApi = this.createGitLabApi(bugTracker, credentials);
    }

    protected final GitLabApi createGitLabApi(BugTracker bugTracker, Credentials credentials) {
        return GitLabApiProvider.createGitLabApi(bugTracker.getUrl(), credentials);
    }

    public BugTracker getBugTracker() {
        return this.bugTracker;
    }

    public Version getVersion() throws GitLabApiException {
        return this.getGitLabApi().getVersion();
    }

    protected GitLabApi getGitLabApi() {
        return this.gitLabApi;
    }

    public List<Issue> getAllProjectIssues(String projectPath) throws GitLabApiException {
        try {
            return this.getIssues(projectPath, new IssueFilter().withScope(Constants.IssueScope.ALL));
        }
        catch (NumberFormatException exception) {
            throw new WrongIdFormatException();
        }
    }

    public List<Issue> getIssues(String projectPath, String issueId) throws GitLabApiException {
        try {
            return this.getIssues(projectPath, new IssueFilter().withIids(Collections.singletonList(Long.parseLong(issueId))).withScope(Constants.IssueScope.ALL));
        }
        catch (NumberFormatException exception) {
            throw new WrongIdFormatException();
        }
    }

    public List<Issue> getIssuesWithTitle(String projectPath, String issueTitle, boolean displayClosedIssues, int maxResultsPerSearch) throws GitLabApiException {
        return this.getFirstPageOfIssues(projectPath, maxResultsPerSearch, new IssueFilter().withSearch(issueTitle).withState(displayClosedIssues ? null : Constants.IssueState.OPENED).withScope(Constants.IssueScope.ALL));
    }

    public List<Issue> getFirstPageOfIssues(String projectPath, int maxResultsPerSearch, IssueFilter issueFilter) throws GitLabApiException {
        return this.getGitLabApi().getIssuesApi().getIssues(projectPath, issueFilter, 1, maxResultsPerSearch);
    }

    public List<Issue> getIssues(String projectPath, IssueFilter issueFilter) throws GitLabApiException {
        return this.getGitLabApi().getIssuesApi().getIssues((Object)projectPath, issueFilter);
    }

    public Issue createIssue(GitLabIssueCreationParameters parameters) throws GitLabApiException {
        for (GitLabIssueCreationParameters.LinkedIssue issueToLink : parameters.linkedIssues) {
            this.assertIssueToLinkExists(parameters.projectPath, issueToLink);
        }
        Issue issue = this.createIssue(parameters.projectPath, parameters.title, parameters.description, parameters.confidential, parameters.assigneeIds, parameters.milestoneId, parameters.labels, parameters.createdAt, parameters.dueDate, parameters.mergeRequestToResolveId, parameters.discussionToResolveId, parameters.epicId);
        for (GitLabIssueCreationParameters.LinkedIssue issueToLink : parameters.linkedIssues) {
            Optional<ScopedIssueIid> scopedIssueIid = GitLabApiWrapper.tryToExtractScopedIssueIid(issue.getProjectId(), issueToLink);
            if (!scopedIssueIid.isPresent()) continue;
            this.linkIssues(issue, scopedIssueIid.get());
        }
        return issue;
    }

    private Issue createIssue(String projectPath, String title, String description, Boolean confidential, List<Integer> assigneeIds, Integer milestoneId, String labels, Date createdAt, Date dueDate, Integer mergeRequestToResolveId, Integer discussionToResolveId, Integer epicId) throws GitLabApiException {
        return new ExtendedIssueApi(this.getGitLabApi()).createIssue((Object)projectPath, title, description, confidential, assigneeIds, milestoneId, labels, createdAt, dueDate, mergeRequestToResolveId, discussionToResolveId, epicId);
    }

    private void assertIssueToLinkExists(String currentIssueProjectPath, GitLabIssueCreationParameters.LinkedIssue linkedIssue) throws BugTrackerRemoteException {
        Optional<ScopedIssueIid> scopedIssueIid = GitLabApiWrapper.tryToExtractScopedIssueIid(currentIssueProjectPath, linkedIssue);
        if (scopedIssueIid.isPresent()) {
            try {
                this.getGitLabApi().getIssuesApi().getIssue(scopedIssueIid.get().projectIdOrPath, scopedIssueIid.get().issueIid);
            }
            catch (GitLabApiException ex) {
                String errorMessage = "Could not find issue #%s in project %s".formatted(scopedIssueIid.get().issueIid, scopedIssueIid.get().projectIdOrPath);
                throw new BugTrackerRemoteException(errorMessage, (Throwable)ex);
            }
        } else {
            String errorMessage = "Could not parse issue iid and project path from %s".formatted(linkedIssue.issueIidOrUrl);
            throw new BugTrackerRemoteException(errorMessage, null);
        }
    }

    private IssueLink linkIssues(Issue issueToLinkTo, ScopedIssueIid scopedIssueIid) throws GitLabApiException {
        return this.getGitLabApi().getIssuesApi().createIssueLink(issueToLinkTo.getProjectId(), issueToLinkTo.getIid(), scopedIssueIid.projectIdOrPath, scopedIssueIid.issueIid);
    }

    private static Optional<ScopedIssueIid> tryToExtractScopedIssueIid(Object currentIssueProjectPathOrId, GitLabIssueCreationParameters.LinkedIssue linkedIssue) {
        Optional<ScopedIssueIid> keys = GitLabApiWrapper.tryToExtractKeysFromUrl(linkedIssue.issueIidOrUrl);
        if (keys.isPresent()) {
            return keys;
        }
        try {
            Long issueIid = Long.parseLong(linkedIssue.issueIidOrUrl);
            return Optional.of(new ScopedIssueIid(currentIssueProjectPathOrId, issueIid));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static Optional<ScopedIssueIid> tryToExtractKeysFromUrl(String candidate) {
        try {
            URI uri = new URI(candidate);
            String path = uri.getPath().replaceFirst("/", "");
            List<String> parts = Arrays.asList(path.split("/"));
            int positionOfMinusPart = parts.indexOf("-");
            String projectPath = String.join((CharSequence)"/", parts.subList(0, positionOfMinusPart));
            Long issueIid = Long.parseLong(parts.get(parts.size() - 1));
            return Optional.of(new ScopedIssueIid(projectPath, issueIid));
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            LOGGER.warn("Failed to extract keys from URL. Error message is: {}", (Object)exception.getMessage());
            return Optional.empty();
        }
    }

    public Project getProject(String projectPath) throws GitLabApiException {
        return this.getGitLabApi().getProjectApi().getProject(projectPath);
    }

    public List<Label> getProjectLabels(Object projectIdOrPath) throws GitLabApiException {
        return this.getGitLabApi().getLabelsApi().getProjectLabels(projectIdOrPath);
    }

    public List<ProjectUser> getProjectUsers(Long projectId) throws GitLabApiException {
        return this.getGitLabApi().getProjectApi().getProjectUsers(projectId);
    }

    public List<ProjectUser> getProjectUsers(String projectPath) throws GitLabApiException {
        return this.getGitLabApi().getProjectApi().getProjectUsers(projectPath);
    }

    public List<Milestone> getProjectMilestones(Object projectIdOrPath) throws GitLabApiException {
        return new AncestorMilestonesApi(this.getGitLabApi()).getMilestonesWithAncestors(projectIdOrPath);
    }

    public static boolean isPremiumProjectOrHigher(Project project) {
        return project.getApprovalsBeforeMerge() != null;
    }

    public Map<Attachment, FileUpload> addProjectUploads(String projectPath, List<Attachment> attachments) {
        try {
            HashMap<Attachment, FileUpload> fileUploadByAttachment = new HashMap<Attachment, FileUpload>();
            File tempDirectory = Files.createTempDirectory(TEMP_DIRECTORY_PREFIX, new FileAttribute[0]).toFile();
            for (Attachment attachment : attachments) {
                File tempFile = new File(tempDirectory, attachment.getName());
                Files.copy(attachment.getStreamContent(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                FileUpload fileUpload = this.getGitLabApi().getProjectApi().uploadFile(projectPath, tempFile);
                fileUploadByAttachment.put(attachment, fileUpload);
                Files.delete(tempFile.toPath());
            }
            Files.delete(tempDirectory.toPath());
            return fileUploadByAttachment;
        }
        catch (GitLabApiException | IOException ex) {
            throw new BugTrackerLocalException((Throwable)ex);
        }
    }

    public void setIssueDescription(String projectPath, Long issueId, String newDescription) throws GitLabApiException {
        this.getGitLabApi().getIssuesApi().updateIssue(projectPath, issueId, null, newDescription, null, null, null, null, null, null, null);
    }

    public List<Epic> getEpics(Project project) throws GitLabApiException {
        Long maybeGroupId = project.getNamespace().getId();
        boolean belongsToGroup = project.getNamespace().getKind().equals(NamespaceKind.GROUP.value);
        return belongsToGroup ? this.getGroupEpics(maybeGroupId) : Collections.emptyList();
    }

    private List<Epic> getGroupEpics(Long groupId) throws GitLabApiException {
        return new AncestorEpicsApi(this.getGitLabApi()).getEpicsWithAncestors(groupId);
    }

    public List<String> getDescriptionTemplates(Project project) throws GitLabApiException {
        Long projectId = project.getId();
        String defaultBranch = project.getDefaultBranch();
        try {
            return this.getGitLabApi().getRepositoryApi().getTree(projectId, DESCRIPTION_TEMPLATES_PATH, defaultBranch).stream().map(TreeItem::getName).filter(treeItemName -> treeItemName.toLowerCase().endsWith(MARKDOWN_EXTENSION)).collect(Collectors.toList());
        }
        catch (GitLabApiException ex) {
            if (ex.getHttpStatus() == 403 || ex.getHttpStatus() == 404) {
                LOGGER.info("Could not fetch description templates.", (Throwable)ex);
                return Collections.emptyList();
            }
            throw ex;
        }
    }

    public String getDescriptionTemplateContent(String projectPath, String fileName) throws GitLabApiException {
        Project project = this.getProject(projectPath);
        String path = "%s/%s".formatted(DESCRIPTION_TEMPLATES_PATH, fileName);
        return this.getGitLabApi().getRepositoryFileApi().getFile(project.getId(), path, project.getDefaultBranch()).getDecodedContentAsString();
    }

    public void createIssueLink(String sourceProjectPath, Long sourceIssueIid, String targetProjectId, Long targetIssueIid, LinkType linkType) throws GitLabApiException {
        this.getGitLabApi().getIssuesApi().createIssueLink(sourceProjectPath, sourceIssueIid, targetProjectId, targetIssueIid, linkType);
    }

    @Override
    public void close() {
        this.getGitLabApi().close();
    }

    public static <T> T withGitLabExceptionWrapping(CheckedFunction<T> function) {
        try {
            return function.run();
        }
        catch (GitLabApiException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }

    public static class ScopedIssueIid {
        public final Object projectIdOrPath;
        public final Long issueIid;

        public ScopedIssueIid(Object projectIdOrPath, Long issueIid) {
            this.projectIdOrPath = projectIdOrPath;
            this.issueIid = issueIid;
        }
    }

    private static enum NamespaceKind {
        GROUP("group"),
        USER("user");

        public final String value;

        private NamespaceKind(String value) {
            this.value = value;
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction<T> {
        public T run() throws GitLabApiException;
    }
}

