/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.jsonext;

import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.squashtest.tm.plugin.jirasync.jsonext.JsonPrimitiveParser;

public class MultipurposeStringJsonParser
implements JsonPrimitiveParser<String> {
    private static final String STRINGFIED_SPRINT_MARKER = "greenhopper.service.sprint.Sprint";
    private static final ValueHandler SIMPLE_OBJECT_HANDLER = value -> {
        JSONObject object = (JSONObject)value;
        return object.getString("value");
    };
    public static final String NAME_MARKER = "name=";
    public static final String START_DATE_MARKER = ",startDate=";
    public static final String GOAL_MARKER = ",goal=";
    public static final int NAME_MARKER_LENGTH = 5;
    private static final ValueHandler STRINGIFIED_SPRINT_HANDLER = value -> {
        String string = (String)value;
        int idxName = string.indexOf(NAME_MARKER);
        int idxStartDate = string.indexOf(START_DATE_MARKER, idxName);
        int idxGoal = string.indexOf(GOAL_MARKER, idxName);
        String newValue = "";
        newValue = idxGoal != -1 ? (idxGoal < idxStartDate ? string.substring(idxName + 5, idxGoal) : string.substring(idxName + 5, idxStartDate)) : string.substring(idxName + 5, idxStartDate);
        return newValue;
    };
    private static final ValueHandler PLAIN_STRING_HANDLER = String.class::cast;
    private ValueHandler handler = null;

    @Override
    public String parse(Object json) throws JSONException {
        if (this.handler == null) {
            this.initHandler(json);
        }
        return this.handler.handle(json);
    }

    private void initHandler(Object json) {
        if (JSONObject.class.isAssignableFrom(json.getClass())) {
            this.handler = SIMPLE_OBJECT_HANDLER;
        } else if (json instanceof String) {
            String jsonString = (String)json;
            this.handler = jsonString.contains(STRINGFIED_SPRINT_MARKER) ? STRINGIFIED_SPRINT_HANDLER : PLAIN_STRING_HANDLER;
        } else {
            throw new IllegalArgumentException("expected a String or a JSONObject but got '" + json.getClass().getName() + "'");
        }
    }

    @FunctionalInterface
    private static interface ValueHandler {
        public String handle(Object var1) throws JSONException;
    }
}

