/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.client;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.jira.rest.client.api.RestClientException;
import jirasync.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirasync.com.sun.ws.rs.core.UriBuilder;
import jirasync.io.atlassian.util.concurrent.Promise;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;
import org.squashtest.tm.plugin.jirasync.client.JiraReport;
import org.squashtest.tm.plugin.jirasync.domain.JiraFilter;
import org.squashtest.tm.plugin.jirasync.domain.JiraSprintState;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraAgileIssue;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraAgileIssueListResponse;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraAgileIssueListResponseParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoard;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoardIssueResponse;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoardIssueResponseParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoardParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoardResponse;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoardResponseParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraFilterParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraHtmlIssueDescription;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraHtmlIssueDescriptionResponse;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraHtmlIssueDescriptionResponseParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraReportResponse;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraReportResponseParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprint;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprintResponse;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprintResponseParser;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationManager;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingEffectiveConfiguration;

@Configurable
public class AsynchronousPluginRestClient
extends AbstractAsynchronousRestClient
implements ConfigurableObject {
    private static final Logger LOGGER;
    public static final String JQL_ATTRIBUTE = "jql";
    private static final String EXPAND_KEY = "expand";
    private static final String MAX_RESULTS_PARAM_KEY = "maxResults";
    private static final String START_AT_PARAM_KEY = "startAt";
    private static final String FIELDS_PARAM_KEY = "fields";
    private static final String STATE_PARAM_KEY = "state";
    private static final String JIRA_API_BOARD_URL = "/rest/agile/1.0/board";
    private static final String JIRA_API_SPRINT_URL = "/rest/agile/1.0/sprint";
    private static final String JIRA_REST_API_SEARCH_URL = "/rest/api/latest/search";
    private static final String JIRA_CLOUD_REST_API_SEARCH_URL = "/rest/api/latest/search/jql";
    private static final String JIRA_REST_API_FILTER_URL = "/rest/api/latest/filter";
    private final URI serverUri;
    @Inject
    @Named(value="org.squashtest.tm.plugin.jirasync.ConfigurationManager")
    private ConfigurationManager configurationManager;
    private final JiraBoardResponseParser jiraBoardResponseParser;
    private final JiraBoardParser jiraBoardParser;
    private final JiraFilterParser jiraFilterParser;
    private final JiraSprintResponseParser jiraSprintResponseParser;
    private final JiraAgileIssueListResponseParser jiraAgileIssueListResponseParser;
    private final JiraBoardIssueResponseParser jiraBoardIssueResponseParser;
    private final JiraHtmlIssueDescriptionResponseParser jiraHtmlIssueDescriptionResponseParser;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        AsynchronousPluginRestClient.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(AsynchronousPluginRestClient.class);
    }

    protected AsynchronousPluginRestClient(URI serverUri, HttpClient client) {
        super(client);
        URI uRI = serverUri;
        HttpClient httpClient = client;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)uRI, (Object)httpClient);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.jiraBoardResponseParser = new JiraBoardResponseParser();
        this.jiraBoardParser = new JiraBoardParser();
        this.jiraFilterParser = new JiraFilterParser();
        this.jiraSprintResponseParser = new JiraSprintResponseParser();
        this.jiraAgileIssueListResponseParser = new JiraAgileIssueListResponseParser();
        this.jiraBoardIssueResponseParser = new JiraBoardIssueResponseParser();
        this.jiraHtmlIssueDescriptionResponseParser = new JiraHtmlIssueDescriptionResponseParser();
        this.serverUri = serverUri;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public String getBoardJQL(String boardName) {
        Long boardId = this.getBoardId(boardName);
        if (boardId == null) {
            throw new IllegalArgumentException("the board " + boardName + "doesn't exist");
        }
        return this.getBoardJQL(boardId);
    }

    public JiraBoard getBoard(String boardName) {
        Long boardId = this.getBoardId(boardName);
        if (boardId == null) {
            throw new IllegalArgumentException("the board " + boardName + "doesn't exist");
        }
        return this.getBoard(boardId);
    }

    public Long getBoardId(String name) {
        boolean isLast;
        URI uri = UriBuilder.fromUri(this.serverUri).path(JIRA_API_BOARD_URL).queryParam(MAX_RESULTS_PARAM_KEY, this.configurationManager.getBatchSize()).queryParam("name", name).build(new Object[0]);
        do {
            Promise<JiraBoardResponse> responsePromise = this.getAndParse(uri, this.jiraBoardResponseParser);
            JiraBoardResponse jiraBoardResponse = responsePromise.claim();
            isLast = jiraBoardResponse.isLast();
            Iterable<JiraBoard> boards = jiraBoardResponse.getBoards();
            Optional<JiraBoard> jiraBoardOptional = StreamSupport.stream(boards.spliterator(), false).filter(b -> b.getName().equals(name)).findFirst();
            if (!jiraBoardOptional.isPresent()) continue;
            return jiraBoardOptional.get().getId();
        } while (!isLast);
        return null;
    }

    private String getBoardJQL(Long boardId) {
        URI boardUri = UriBuilder.fromUri(this.serverUri).path(JIRA_API_BOARD_URL).path(boardId.toString()).path("configuration").build(new Object[0]);
        JiraBoard jiraBoard = this.getAndParse(boardUri, this.jiraBoardParser).claim();
        URI filterUri = UriBuilder.fromUri(this.serverUri).path(JIRA_REST_API_FILTER_URL).path(jiraBoard.getFilterId()).build(new Object[0]);
        JiraFilter filter = this.getAndParse(filterUri, this.jiraFilterParser).claim();
        return filter.getJql();
    }

    private JiraBoard getBoard(Long boardId) {
        URI boardUri = UriBuilder.fromUri(this.serverUri).path(JIRA_API_BOARD_URL).path(boardId.toString()).path("configuration").build(new Object[0]);
        return this.getAndParse(boardUri, this.jiraBoardParser).claim();
    }

    public List<JiraSprint> getSprints(Long boardId, JiraSprintState ... validStates) {
        boolean isLast;
        ArrayList<JiraSprint> allSprints = new ArrayList<JiraSprint>();
        int startAt = 0;
        int batchSize = this.configurationManager.getBatchSize();
        String statePrm = null;
        if (validStates != null && validStates.length > 0) {
            statePrm = Arrays.stream(validStates).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(","));
        }
        do {
            UriBuilder uriBuilder = UriBuilder.fromUri(this.serverUri).path(JIRA_API_BOARD_URL).path(boardId.toString()).path("sprint").queryParam(MAX_RESULTS_PARAM_KEY, batchSize).queryParam(START_AT_PARAM_KEY, startAt);
            if (statePrm != null) {
                uriBuilder.queryParam(STATE_PARAM_KEY, statePrm);
            }
            URI boardUri = uriBuilder.build(new Object[0]);
            JiraSprintResponse sprintResponse = this.getAndParse(boardUri, this.jiraSprintResponseParser).claim();
            isLast = sprintResponse.isLast();
            startAt += batchSize;
            allSprints.addAll(sprintResponse.getSprints());
        } while (!isLast);
        return allSprints;
    }

    public Set<String> getBacklogIssueKeys(Long boardId) {
        HashSet<String> keys = new HashSet<String>();
        long total = 0L;
        long processed = 0L;
        int batchSize = this.configurationManager.getBatchSize();
        try {
            JiraAgileIssueListResponse response;
            do {
                URI sprintIssuesUri = UriBuilder.fromUri(this.serverUri).path(JIRA_API_BOARD_URL).path(boardId.toString()).path("backlog").queryParam(MAX_RESULTS_PARAM_KEY, batchSize).queryParam(START_AT_PARAM_KEY, processed).queryParam(FIELDS_PARAM_KEY, "key").build(new Object[0]);
                response = this.getAndParse(sprintIssuesUri, this.jiraAgileIssueListResponseParser).claim();
                keys.addAll(response.getIssueKeys());
            } while ((processed += (long)batchSize) < (total = response.getTotal().longValue()));
        }
        catch (RestClientException ex) {
            if (ex.getStatusCode().isPresent() && (Integer)ex.getStatusCode().get() == 400) {
                LOGGER.warn("Cannot fetch backlog for board " + String.valueOf(boardId) + " : " + ex.toString());
            }
            throw ex;
        }
        return keys;
    }

    public Set<JiraAgileIssue> getAgileIssues(Long boardId, Collection<String> keys) {
        int toProcess;
        LOGGER.debug("retrieving agile issues from board");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("board id: {}, # issues : {}, keys are : '{}'", new Object[]{boardId, keys.size(), keys});
        }
        int total = keys.size();
        int processed = 0;
        HashSet<JiraAgileIssue> agileIssues = new HashSet<JiraAgileIssue>();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        int batchSize = this.configurationManager.getBatchSize();
        do {
            toProcess = Math.min(total, batchSize + processed);
            List keysToProcess = keyList.subList(processed, toProcess);
            String keysAsString = StringUtils.join(keysToProcess, (String)",");
            URI sprintIssuesUri = UriBuilder.fromUri(this.serverUri).path(JIRA_API_BOARD_URL).path(boardId.toString()).path("issue").queryParam(FIELDS_PARAM_KEY, "key,sprint,closedSprints").queryParam(JQL_ATTRIBUTE, "key IN (" + keysAsString + ")").build(new Object[0]);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("calling GET {}", (Object)sprintIssuesUri);
            }
            JiraBoardIssueResponse response = this.getAndParse(sprintIssuesUri, this.jiraBoardIssueResponseParser).claim();
            agileIssues.addAll(response.getIssues());
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("retrieved {} issues", (Object)response.getIssues().size());
        } while ((processed = toProcess) < total);
        LOGGER.debug("done retrieving agile issues from board");
        return agileIssues;
    }

    public Iterable<JiraHtmlIssueDescription> getHtmlDescriptionIssues(Collection<String> keys, int fetchBatchSize, boolean isJiraCloudServer) {
        String keysAsString = StringUtils.join(keys, (String)",");
        URI sprintIssuesUri = UriBuilder.fromUri(this.serverUri).path(this.getSearchPath(isJiraCloudServer)).queryParam(MAX_RESULTS_PARAM_KEY, fetchBatchSize).queryParam(FIELDS_PARAM_KEY, "description").queryParam(EXPAND_KEY, "renderedFields").queryParam(JQL_ATTRIBUTE, "key IN (" + keysAsString + ")").build(new Object[0]);
        JiraHtmlIssueDescriptionResponse response = this.getAndParse(sprintIssuesUri, this.jiraHtmlIssueDescriptionResponseParser).claim();
        return response.getIssues();
    }

    private String getSearchPath(boolean isJiraCloudServer) {
        return isJiraCloudServer ? JIRA_CLOUD_REST_API_SEARCH_URL : JIRA_REST_API_SEARCH_URL;
    }

    public Set<String> getSprintIssueKeys(Long sprintId) {
        JiraAgileIssueListResponse response;
        HashSet<String> keys = new HashSet<String>();
        long total = 0L;
        long processed = 0L;
        int batchSize = this.configurationManager.getBatchSize();
        do {
            URI sprintIssuesUri = UriBuilder.fromUri(this.serverUri).path(JIRA_API_SPRINT_URL).path(sprintId.toString()).path("issue").queryParam(MAX_RESULTS_PARAM_KEY, batchSize).queryParam(START_AT_PARAM_KEY, processed).queryParam(FIELDS_PARAM_KEY, "key").build(new Object[0]);
            response = this.getAndParse(sprintIssuesUri, this.jiraAgileIssueListResponseParser).claim();
            keys.addAll(response.getIssueKeys());
        } while ((processed += (long)batchSize) < (total = response.getTotal().longValue()));
        return keys;
    }

    public Iterable<JiraReport> getInitialReport(List<String> keys, JiraReportingEffectiveConfiguration configuration, boolean isJiraCloudServer) {
        String keysAsString = StringUtils.join((Iterable)keys.stream().map(String::toLowerCase).collect(Collectors.toList()), (String)",");
        String validFields = StringUtils.join(configuration.getValidFieldIds(), (String)",");
        URI initialReportURI = UriBuilder.fromUri(this.serverUri).path(this.getSearchPath(isJiraCloudServer)).queryParam(JQL_ATTRIBUTE, "key IN (" + keysAsString + ")").queryParam(FIELDS_PARAM_KEY, validFields).build(new Object[0]);
        try {
            JiraReportResponse response = this.getAndParse(initialReportURI, JiraReportResponseParser.createParserForConfiguration(configuration)).claim();
            return response.getJiraReports();
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch Jira issues with keys {}. Verify that declared reporting fields exist in Jira issues.", (Object)keysAsString);
            throw e;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AsynchronousPluginRestClient.java", AsynchronousPluginRestClient.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 97);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("4", "org.squashtest.tm.plugin.jirasync.client.AsynchronousPluginRestClient", "java.net.URI:com.atlassian.httpclient.api.HttpClient", "serverUri:client", ""), 97);
    }
}

