/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.client;

import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsDetailedException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.CredentialHolder;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.MantisClient;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.PathBuilder;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.exception.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Issue;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.MantisFiles;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.User;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.response.MantisConfigsResponse;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.response.MantisIssueResponse;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.response.MantisIssuesResponse;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.response.MantisProjectsResponse;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.utils.RestTemplateFactory;

@Component
@Scope(value="prototype")
public class MantisClientImpl
implements MantisClient {
    private RestTemplate restTemplate;
    private final RestTemplateFactory restTemplateFactory;
    private final ExceptionHandler exceptionHandler;
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisClientImpl.class);

    public MantisClientImpl(RestTemplateFactory restTemplateFactory, ExceptionHandler exceptionHandler) {
        this.restTemplateFactory = restTemplateFactory;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void init(BugTracker bugTracker, CredentialHolder credentialHolder) {
        this.restTemplate = this.restTemplateFactory.restTemplate(bugTracker);
        this.verifyCredentialsValidity(credentialHolder);
    }

    @Override
    public MantisIssuesResponse findIssues(Long issueId, CredentialHolder credentialHolder) {
        String path = PathBuilder.buildIssuePath(issueId.toString()).build();
        try {
            return (MantisIssuesResponse)this.get(path, (Type)((Object)MantisIssuesResponse.class), credentialHolder.getCredentials().getToken());
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.NotFound e) {
            LOGGER.error("Forbidden connection, access denied for user!", e);
            throw this.exceptionHandler.issueNotFound();
        }
    }

    @Override
    public MantisProjectsResponse findProjectById(String id, CredentialHolder credentialHolder) {
        String path = PathBuilder.buildProjectPath(id).build();
        try {
            return (MantisProjectsResponse)this.get(path, (Type)((Object)MantisProjectsResponse.class), credentialHolder.getCredentials().getToken());
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.NotFound e) {
            LOGGER.error("Forbidden connection, access denied for user!", e);
            throw this.exceptionHandler.projectNotFound(id);
        }
    }

    @Override
    public MantisProjectsResponse findAllProjects(CredentialHolder credentialHolder) {
        String path = PathBuilder.buildAllProjectsPath().build();
        return (MantisProjectsResponse)this.getMantisEntity(credentialHolder, (Type)((Object)MantisProjectsResponse.class), path);
    }

    @Override
    public MantisConfigsResponse getSeverities(CredentialHolder credentialHolder) {
        String path = PathBuilder.buildSeveritiesPath().build();
        return (MantisConfigsResponse)this.getMantisEntity(credentialHolder, (Type)((Object)MantisConfigsResponse.class), path);
    }

    @Override
    public MantisConfigsResponse getPriorities(CredentialHolder credentialHolder) {
        String path = PathBuilder.buildPrioritiesPath().build();
        return (MantisConfigsResponse)this.getMantisEntity(credentialHolder, (Type)((Object)MantisConfigsResponse.class), path);
    }

    @Override
    public MantisConfigsResponse getReproducibilities(CredentialHolder credentialHolder) {
        String path = PathBuilder.buildReproducibilityPath().build();
        return (MantisConfigsResponse)this.getMantisEntity(credentialHolder, (Type)((Object)MantisConfigsResponse.class), path);
    }

    private void verifyCredentialsValidity(CredentialHolder credentialHolder) {
        String path = PathBuilder.buildCurrentUserPath().build();
        this.getMantisEntity(credentialHolder, (Type)((Object)User.class), path);
    }

    private <T> T getMantisEntity(CredentialHolder credentialHolder, Type type, String path) {
        try {
            return this.get(path, type, credentialHolder.getCredentials().getToken());
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.NotFound e) {
            throw this.logAndThrowConnectionDeniedException((HttpClientErrorException)e);
        }
    }

    private <T> T get(String path, Type type, String token) throws RestClientException {
        ParameterizedTypeReference parameterizedTypeReference = ParameterizedTypeReference.forType((Type)type);
        return this.sendRequest(path, parameterizedTypeReference, token, HttpMethod.GET, null);
    }

    @Override
    public MantisIssueResponse createIssue(Issue issue, CredentialHolder credentialHolder) {
        String path = PathBuilder.buildAddIssuePath().build();
        try {
            return (MantisIssueResponse)this.post(path, (Type)((Object)MantisIssueResponse.class), credentialHolder.getCredentials().getToken(), issue);
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.NotFound e) {
            throw this.logAndThrowConnectionDeniedException((HttpClientErrorException)e);
        }
    }

    @Override
    public MantisIssuesResponse uploadFiles(String id, MantisFiles files, CredentialHolder credentialHolder) {
        String path = PathBuilder.buildAttachmentsPath(id).build();
        try {
            return (MantisIssuesResponse)this.post(path, (Type)((Object)MantisIssuesResponse.class), credentialHolder.getCredentials().getToken(), files);
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.NotFound e) {
            throw this.logAndThrowConnectionDeniedException((HttpClientErrorException)e);
        }
    }

    private BugTrackerNoCredentialsDetailedException logAndThrowConnectionDeniedException(HttpClientErrorException e) {
        LOGGER.error("Forbidden connection, token is not correct!", (Throwable)e);
        return this.exceptionHandler.connexionDenied();
    }

    private <T> T post(String path, Type type, String token, Object body) throws HttpClientErrorException.Forbidden, HttpClientErrorException.NotFound {
        ParameterizedTypeReference parameterizedTypeReference = ParameterizedTypeReference.forType((Type)type);
        return this.sendRequest(path, parameterizedTypeReference, token, HttpMethod.POST, body);
    }

    private <T> T sendRequest(String path, ParameterizedTypeReference<T> parameterizedTypeReference, String token, HttpMethod method, @Nullable Object body) throws HttpClientErrorException.Forbidden, HttpClientErrorException.NotFound {
        HttpEntity<?> entity = body == null ? this.getHttpEntity(token) : this.getHttpEntityWithBody(token, body);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(path, method, entity, parameterizedTypeReference, new Object[0]);
            return (T)responseEntity.getBody();
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.NotFound e) {
            throw e;
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("Forbidden connection");
            throw this.exceptionHandler.mantisHttpError(e);
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    private HttpEntity<?> getHttpEntity(String token) {
        HttpHeaders headers = this.getHttpHeaders(token);
        return new HttpEntity((MultiValueMap)headers);
    }

    private HttpEntity<?> getHttpEntityWithBody(String token, Object body) {
        HttpHeaders headers = this.getHttpHeaders(token);
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    private HttpHeaders getHttpHeaders(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        headers.set("Authorization", token);
        return headers;
    }
}

