/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.openid.connect;

import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class EnableOAuth2Condition
implements Condition {
    private static final String OIDC_PROPERTY_PREFIX = "spring.security.oauth2.client";

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment env = context.getEnvironment();
        for (PropertySource propertySource : ((AbstractEnvironment)env).getPropertySources()) {
            if (!this.doesPropertySourceContainOidcProperty(propertySource)) continue;
            return true;
        }
        return false;
    }

    private boolean doesPropertySourceContainOidcProperty(PropertySource<?> propertySource) {
        if (propertySource instanceof MapPropertySource) {
            MapPropertySource mapPropertySource = (MapPropertySource)propertySource;
            for (String propertyName : ((Map)mapPropertySource.getSource()).keySet()) {
                if (!propertyName.startsWith(OIDC_PROPERTY_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }
}

