-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-oodrqmrh (100.64.7.242)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-10.0.0.xml
-- Ran at: 16/02/2026 15:06
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.31.1
-- *********************************************************************

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-export-right-in-custom-report-workspace::bmarejus
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT ACL_GROUP.ID AS ACL_GROUP_ID,
             64           AS PERMISSION_MASK,
             ACL_CLASS.ID AS CLASS_ID
      FROM ACL_GROUP_PERMISSION
             INNER JOIN ACL_GROUP ON ACL_GROUP_PERMISSION.ACL_GROUP_ID = ACL_GROUP.ID
             INNER JOIN ACL_CLASS ON ACL_GROUP_PERMISSION.CLASS_ID = ACL_CLASS.ID
      WHERE ACL_GROUP_PERMISSION.PERMISSION_MASK = 1
        AND ACL_CLASS.CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'
        AND ACL_GROUP.QUALIFIED_NAME != 'squashtest.acl.group.tm.ProjectViewer';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-export-right-in-custom-report-workspace', 'bmarejus', 'tm/tm.changelog-10.0.0.xml', NOW(), 1, '9:82e6480dadeb2840ba7b81a5b9ba15e5', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-delete-execution-permission::bmarejus
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT ACL_GROUP.ID,
             131072,
             ACL_CLASS.ID
      FROM ACL_GROUP_PERMISSION
             INNER JOIN ACL_GROUP ON ACL_GROUP_PERMISSION.ACL_GROUP_ID = ACL_GROUP.ID
             INNER JOIN ACL_CLASS ON ACL_GROUP_PERMISSION.CLASS_ID = ACL_CLASS.ID
      WHERE ACL_GROUP_PERMISSION.PERMISSION_MASK = 8
        AND ACL_CLASS.CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-delete-execution-permission', 'bmarejus', 'tm/tm.changelog-10.0.0.xml', NOW(), 2, '9:97a59d379e93ac4c96c767e7d3a0f4d1', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-automated_suite_workflows-foreign-key::ssviridov
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS DROP CONSTRAINT fk_automated_suite_workflows_suite_id;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-automated_suite_workflows-foreign-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 3, '9:afb4edaf144aeffd70beb90b462167cd', 'dropForeignKeyConstraint baseTableName=AUTOMATED_SUITE_WORKFLOWS, constraintName=fk_automated_suite_workflows_suite_id', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-automated_execution_extender-foreign-key::ssviridov
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER DROP CONSTRAINT fk_auto_exec_suite;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-automated_execution_extender-foreign-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 4, '9:51cd90365b7ebad8c0859c376087c078', 'dropForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_EXTENDER, constraintName=fk_auto_exec_suite', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-uuid-column::ssviridov
ALTER TABLE AUTOMATED_SUITE ADD UUID VARCHAR(50);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-uuid-column', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 5, '9:415c6e5bfb1a4a8dc6fc2ff99de280a2', 'addColumn tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-data-to-uuid-column::ssviridov
UPDATE AUTOMATED_SUITE SET UUID = SUITE_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-data-to-uuid-column', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 6, '9:248a4df5b7a03816eb207ddfcfb34139', 'update tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-replace-varchar-suite_id-column-by-bigint-suite_id-column-in-automated_suites::ssviridov
ALTER TABLE AUTOMATED_SUITE DROP COLUMN SUITE_ID;

ALTER TABLE AUTOMATED_SUITE ADD SUITE_ID BIGINT;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-replace-varchar-suite_id-column-by-bigint-suite_id-column-in-automated_suites', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 7, '9:1d795624d2736c2aa1528cd0b1f7afe0', 'dropColumn columnName=SUITE_ID, tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-populate-suite-id-postgres-h2::ssviridov
CREATE SEQUENCE TEMP_SEQUENCE
        INCREMENT BY 1 START WITH 1;

UPDATE AUTOMATED_SUITE SET SUITE_ID = NEXTVAL('TEMP_SEQUENCE');

DROP SEQUENCE TEMP_SEQUENCE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-populate-suite-id-postgres-h2', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 8, '9:d7b9b98e8d14c2843990aada8618718f', 'sql; sql; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite-id-primary-key::ssviridov
ALTER TABLE AUTOMATED_SUITE ALTER COLUMN  SUITE_ID SET NOT NULL;

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT pk_automated_suite PRIMARY KEY (SUITE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite-id-primary-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 9, '9:5fc100e3d7ac7e379e5c12692a160c73', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_SUITE; addPrimaryKey constraintName=pk_automated_suite, tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-auto-increment-to-suite-id-postgres::ssviridov
ALTER TABLE AUTOMATED_SUITE
      ALTER COLUMN SUITE_ID ADD GENERATED BY DEFAULT AS IDENTITY;

SELECT setval('automated_suite_suite_id_seq', (SELECT MAX(SUITE_ID) FROM AUTOMATED_SUITE));

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-auto-increment-to-suite-id-postgres', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 10, '9:cb55c03d56168f38852ad14a3f8314c4', 'sql; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_suite_workflows::ssviridov
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS RENAME COLUMN SUITE_ID TO UUID;

ALTER TABLE AUTOMATED_SUITE_WORKFLOWS ADD SUITE_ID BIGINT;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 11, '9:ec3dc24946bb776d421bedf0ff860062', 'renameColumn newColumnName=UUID, oldColumnName=SUITE_ID, tableName=AUTOMATED_SUITE_WORKFLOWS; addColumn tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_execution_extender::ssviridov
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER RENAME COLUMN SUITE_ID TO UUID;

ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD SUITE_ID BIGINT;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 12, '9:25c3b59a0b5e356dec93b59671cf618d', 'renameColumn newColumnName=UUID, oldColumnName=SUITE_ID, tableName=AUTOMATED_EXECUTION_EXTENDER; addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-update-automated_suite-constraints::ssviridov
ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT uq_automated_suite_uuid UNIQUE (UUID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-update-automated_suite-constraints', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 13, '9:a5597c31763134fc900117f0ce7622b8', 'addUniqueConstraint constraintName=uq_automated_suite_uuid, tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-fill-out-suite_id-column-in-automated_suite_workflows-based-on-existing-references-posgres::ssviridov
UPDATE AUTOMATED_SUITE_WORKFLOWS SET suite_id = AUTOMATED_SUITE.suite_id FROM AUTOMATED_SUITE WHERE AUTOMATED_SUITE_WORKFLOWS.uuid = AUTOMATED_SUITE.uuid;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-fill-out-suite_id-column-in-automated_suite_workflows-based-on-existing-references-posgres', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 14, '9:81b7bb9cde82165cecac6a0073c04226', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-fill-out-suite_id-column-in-automated_execution_extender-based-on-existing-references-postgres::ssviridov
UPDATE AUTOMATED_EXECUTION_EXTENDER SET suite_id = AUTOMATED_SUITE.suite_id FROM AUTOMATED_SUITE WHERE AUTOMATED_EXECUTION_EXTENDER.uuid = AUTOMATED_SUITE.uuid;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-fill-out-suite_id-column-in-automated_execution_extender-based-on-existing-references-postgres', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 15, '9:e67fd62138fc6afc9bb5859a3585ae04', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_suite_workflows::ssviridov
CREATE INDEX idx_fk_automated_suite_workflows_suite_id ON AUTOMATED_SUITE_WORKFLOWS(SUITE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 16, '9:43252ff1bdc9b52d8a91c8916764ee2c', 'createIndex indexName=idx_fk_automated_suite_workflows_suite_id, tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_execution_extender::ssviridov
CREATE INDEX idx_fk_automated_execution_extender_suite_id ON AUTOMATED_EXECUTION_EXTENDER(SUITE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 17, '9:a9ff19ce080f815180e3485f3d33457b', 'createIndex indexName=idx_fk_automated_execution_extender_suite_id, tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite_id-fk-constraint-to-automated_suite_workflows::ssviridov
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS ADD CONSTRAINT fk_automated_suite_workflows_automated_suite FOREIGN KEY (SUITE_ID) REFERENCES AUTOMATED_SUITE (SUITE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-to-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 18, '9:bd0c9a55b1da9f652de6143b849d1e7d', 'addForeignKeyConstraint baseTableName=AUTOMATED_SUITE_WORKFLOWS, constraintName=fk_automated_suite_workflows_automated_suite, referencedTableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite_id-fk-constraint-to-automated_execution_extender::ssviridov
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD CONSTRAINT fk_automated_execution_extender_automated_suite FOREIGN KEY (SUITE_ID) REFERENCES AUTOMATED_SUITE (SUITE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-to-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 19, '9:4d321ab3c02545affd02205c2c565370', 'addForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_EXTENDER, constraintName=fk_automated_execution_extender_automated_suite, referencedTableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-uuid-column-in-automated_suite_workflows::ssviridov
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS DROP COLUMN UUID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-uuid-column-in-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 20, '9:7022bc31160990571dfc0a0408297ee7', 'dropColumn columnName=UUID, tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-uuid-column-in-automated_execution_extender::ssviridov
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER DROP COLUMN UUID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-uuid-column-in-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 21, '9:710cf945d3ab462aca7b6d2c4b979046', 'dropColumn columnName=UUID, tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-table-clean-orphan-execution::mouahioune
CREATE TABLE ITEM_TEST_PLAN_EXECUTION_TMP (ITEM_TEST_PLAN_ID BIGINT, EXECUTION_ID BIGINT, EXECUTION_ORDER BIGINT);

CREATE INDEX idx_item_test_plan_execution_tmp_item_test_plan_id ON ITEM_TEST_PLAN_EXECUTION_TMP(ITEM_TEST_PLAN_ID, EXECUTION_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-table-clean-orphan-execution', 'mouahioune', 'tm/tm.changelog-10.0.0.xml', NOW(), 22, '9:33b88a7963d39e1e686788a62c463c9a', 'createTable tableName=ITEM_TEST_PLAN_EXECUTION_TMP; createIndex indexName=idx_item_test_plan_execution_tmp_item_test_plan_id, tableName=ITEM_TEST_PLAN_EXECUTION_TMP', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-insert-clean-orphan-execution::llecrocq
INSERT INTO ITEM_TEST_PLAN_EXECUTION_TMP SELECT ITEM_TEST_PLAN_ID, EXECUTION_ID, min(EXECUTION_ORDER) EXECUTION_ORDER
      FROM ITEM_TEST_PLAN_EXECUTION
      GROUP BY ITEM_TEST_PLAN_ID, EXECUTION_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-insert-clean-orphan-execution', 'llecrocq', 'tm/tm.changelog-10.0.0.xml', NOW(), 23, '9:b7e5c222e50385b55d9f918e41e33c1d', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-update-clean-orphan-execution-pg::llecrocq
UPDATE ITEM_TEST_PLAN_EXECUTION_TMP t1
      SET EXECUTION_ORDER=t2.ligne - 1
      FROM (SELECT ITEM_TEST_PLAN_ID, EXECUTION_ID, (SELECT count(*)
                                                     FROM ITEM_TEST_PLAN_EXECUTION_TMP b
                                                     WHERE a.ITEM_TEST_PLAN_ID=b.ITEM_TEST_PLAN_ID
                                                       AND a.EXECUTION_ORDER>=b.EXECUTION_ORDER) ligne
            FROM ITEM_TEST_PLAN_EXECUTION_TMP a) t2
      WHERE t1.ITEM_TEST_PLAN_ID=t2.ITEM_TEST_PLAN_ID and t1.EXECUTION_ID=t2.EXECUTION_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-update-clean-orphan-execution-pg', 'llecrocq', 'tm/tm.changelog-10.0.0.xml', NOW(), 24, '9:70ccb238f3ee7b3f4f250a34a1fe5b81', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-truncate-clean-orphan-execution::llecrocq
TRUNCATE TABLE ITEM_TEST_PLAN_EXECUTION;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-truncate-clean-orphan-execution', 'llecrocq', 'tm/tm.changelog-10.0.0.xml', NOW(), 25, '9:81b5f8438c7cdbb8b0ff7c41ce1fe2f6', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-insert-itpe-clean-orphan-execution::llecrocq
INSERT INTO ITEM_TEST_PLAN_EXECUTION
      SELECT a.ITEM_TEST_PLAN_ID, a.EXECUTION_ID,
             a.EXECUTION_ORDER+1-(SELECT count(*) FROM ITEM_TEST_PLAN_EXECUTION_TMP b
                                  WHERE a.ITEM_TEST_PLAN_ID=b.ITEM_TEST_PLAN_ID
                                    AND a.EXECUTION_ORDER=b.EXECUTION_ORDER
                                    AND a.EXECUTION_ID<=b.EXECUTION_ID
                                  GROUP BY b.ITEM_TEST_PLAN_ID, b.EXECUTION_ORDER) EXECUTION_ORDER
      FROM ITEM_TEST_PLAN_EXECUTION_TMP a;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-insert-itpe-clean-orphan-execution', 'llecrocq', 'tm/tm.changelog-10.0.0.xml', NOW(), 26, '9:f16f03268228bd69e01ac53dd46af372', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-clean-orphan-execution::llecrocq
DROP TABLE ITEM_TEST_PLAN_EXECUTION_TMP;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-clean-orphan-execution', 'llecrocq', 'tm/tm.changelog-10.0.0.xml', NOW(), 27, '9:e7478a9060c1eb8a535d2b4a2b013ad9', 'dropTable tableName=ITEM_TEST_PLAN_EXECUTION_TMP', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-tmp_executions_to_delete::pckerneis
CREATE TABLE TMP_EXECUTIONS_TO_DELETE (EXECUTION_ID BIGINT);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 28, '9:83d158dd232e6fff162886c273857bd1', 'createTable tableName=TMP_EXECUTIONS_TO_DELETE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-truncate-tmp_executions_to_delete::pckerneis
TRUNCATE TABLE TMP_EXECUTIONS_TO_DELETE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-truncate-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 29, '9:0b871fa255e9370143292962bccd6cf8', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-TMP_ORPHAN_ITERATIONS-table::pckerneis
CREATE TABLE TMP_ORPHAN_ITERATIONS (ITERATION_ID BIGINT);

CREATE INDEX idx_tmp_orphan_iterations_iteration_id ON TMP_ORPHAN_ITERATIONS(ITERATION_ID);

TRUNCATE TABLE TMP_ORPHAN_ITERATIONS;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-TMP_ORPHAN_ITERATIONS-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 30, '9:c174f36df862133afbbff1d144439583', 'createTable tableName=TMP_ORPHAN_ITERATIONS; createIndex indexName=idx_tmp_orphan_iterations_iteration_id, tableName=TMP_ORPHAN_ITERATIONS; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-TMP_ORPHAN_AUTOMATED_SUITE-table::pckerneis
CREATE TABLE TMP_ORPHAN_AUTOMATED_SUITE (SUITE_ID BIGINT);

CREATE INDEX idx_tmp_orphan_automated_suite_suite_id ON TMP_ORPHAN_AUTOMATED_SUITE(SUITE_ID);

TRUNCATE TABLE TMP_ORPHAN_AUTOMATED_SUITE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-TMP_ORPHAN_AUTOMATED_SUITE-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 31, '9:bcb2ba5415b3ce98c9034995344226a7', 'createTable tableName=TMP_ORPHAN_AUTOMATED_SUITE; createIndex indexName=idx_tmp_orphan_automated_suite_suite_id, tableName=TMP_ORPHAN_AUTOMATED_SUITE; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-remove-orphan-iterations-and-automated-suites::pckerneis
INSERT INTO TMP_ORPHAN_ITERATIONS SELECT DISTINCT a.ITERATION_ID
      FROM ITERATION a LEFT JOIN CAMPAIGN_ITERATION b ON a.ITERATION_ID = b.ITERATION_ID
      WHERE b.ITERATION_ID IS NULL;

INSERT INTO TMP_ORPHAN_AUTOMATED_SUITE SELECT DISTINCT SUITE_ID
      FROM AUTOMATED_SUITE a JOIN TMP_ORPHAN_ITERATIONS b ON a.ITERATION_ID = b.ITERATION_ID;

DELETE FROM ITERATION_TEST_SUITE
      WHERE ITERATION_ID IN (SELECT ITERATION_ID FROM TMP_ORPHAN_ITERATIONS);

DELETE FROM ITEM_TEST_PLAN_LIST
      WHERE ITERATION_ID IN (SELECT ITERATION_ID FROM TMP_ORPHAN_ITERATIONS);

DELETE FROM AUTOMATED_EXECUTION_FAILURE_DETAIL
      WHERE EXECUTION_EXTENDER_ID IN (SELECT DISTINCT EXTENDER_ID
                                      FROM AUTOMATED_EXECUTION_EXTENDER a JOIN TMP_ORPHAN_AUTOMATED_SUITE b ON a.SUITE_ID = b.SUITE_ID);

DELETE FROM FAILURE_DETAIL
      WHERE FAILURE_DETAIL_ID NOT IN (SELECT DISTINCT FAILURE_DETAIL_ID
                                      FROM AUTOMATED_EXECUTION_FAILURE_DETAIL);

DELETE FROM AUTOMATED_EXECUTION_EXTENDER
      WHERE SUITE_ID IN (SELECT SUITE_ID
                         FROM TMP_ORPHAN_AUTOMATED_SUITE);

DELETE FROM AUTOMATED_SUITE_WORKFLOWS
      WHERE SUITE_ID IN (SELECT SUITE_ID
                         FROM TMP_ORPHAN_AUTOMATED_SUITE);

DELETE FROM ITERATION
      WHERE ITERATION_ID IN (SELECT ITERATION_ID
                             FROM TMP_ORPHAN_ITERATIONS);

DROP TABLE IF EXISTS TMP_ORPHAN_ITERATIONS;

DROP TABLE IF EXISTS TMP_ORPHAN_AUTOMATED_SUITE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-remove-orphan-iterations-and-automated-suites', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 32, '9:275fbb14bc855d2051f7038c26819c09', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-fill-tmp_executions_to_delete::pckerneis
INSERT INTO TMP_EXECUTIONS_TO_DELETE SELECT a.EXECUTION_ID
      FROM EXECUTION a
             LEFT JOIN ITEM_TEST_PLAN_EXECUTION b on a.EXECUTION_ID = b.EXECUTION_ID
             LEFT JOIN ITEM_TEST_PLAN_LIST c on b.ITEM_TEST_PLAN_ID = c.ITEM_TEST_PLAN_ID
      WHERE a.TEST_PLAN_ITEM_ID IS NULL
        AND c.ITERATION_ID IS NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-fill-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 33, '9:d50b8daba29d16d54272f14594530712', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-delete-orphan-executions::pckerneis
DELETE FROM AUTOMATED_EXECUTION_FAILURE_DETAIL
      WHERE EXECUTION_EXTENDER_ID IN (SELECT EXTENDER_ID FROM AUTOMATED_EXECUTION_EXTENDER JOIN TMP_EXECUTIONS_TO_DELETE ON MASTER_EXECUTION_ID = EXECUTION_ID);

DELETE FROM AUTOMATED_EXECUTION_EXTENDER
      WHERE MASTER_EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXPLORATORY_EXECUTION_EVENT
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXPLORATORY_EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM KEYWORD_EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM SCRIPTED_EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM SESSION_NOTE
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXECUTION_EXECUTION_STEPS
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXECUTION_STEP z
        USING EXECUTION_STEP a left join EXECUTION_EXECUTION_STEPS b on a.EXECUTION_STEP_ID = b.EXECUTION_STEP_ID
      WHERE b.EXECUTION_STEP_ID IS NULL
        AND a.EXECUTION_STEP_ID = z.EXECUTION_STEP_ID;

DELETE FROM ITEM_TEST_PLAN_EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM CUSTOM_FIELD_VALUE z
        using CUSTOM_FIELD_VALUE a LEFT JOIN EXECUTION b on a.BOUND_ENTITY_ID = b.EXECUTION_ID
      WHERE b.EXECUTION_ID IS NULL AND a.BOUND_ENTITY_TYPE = 'EXECUTION'
        AND a.CFV_ID = z.CFV_ID;

DELETE FROM CUSTOM_FIELD_VALUE z
        using CUSTOM_FIELD_VALUE a LEFT JOIN EXECUTION_STEP b on a.BOUND_ENTITY_ID = b.EXECUTION_STEP_ID
      WHERE b.EXECUTION_STEP_ID IS NULL AND a.BOUND_ENTITY_TYPE = 'EXECUTION_STEP'
        AND a.CFV_ID = z.CFV_ID;

DELETE FROM DENORMALIZED_FIELD_VALUE z
        using DENORMALIZED_FIELD_VALUE a LEFT JOIN EXECUTION b on a.DENORMALIZED_FIELD_HOLDER_ID = b.EXECUTION_ID
      WHERE b.EXECUTION_ID IS NULL AND a.DENORMALIZED_FIELD_HOLDER_TYPE = 'EXECUTION'
        AND a.DFV_ID = z.DFV_ID;

DELETE FROM DENORMALIZED_FIELD_VALUE z
        using DENORMALIZED_FIELD_VALUE a LEFT JOIN EXECUTION_STEP b on a.DENORMALIZED_FIELD_HOLDER_ID = b.EXECUTION_STEP_ID
      WHERE b.EXECUTION_STEP_ID IS NULL AND a.DENORMALIZED_FIELD_HOLDER_TYPE = 'EXECUTION_STEP'
        AND a.DFV_ID = z.DFV_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-delete-orphan-executions', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 34, '9:59b195e283ba1f398feb3ab79bc08194', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-tmp_executions_to_delete::pckerneis
DROP TABLE TMP_EXECUTIONS_TO_DELETE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 35, '9:ebe89a0d616725c274b4099cbe3f4bf4', 'dropTable tableName=TMP_EXECUTIONS_TO_DELETE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-iteration-testplan::pckerneis
ALTER TABLE ITERATION ADD TEST_PLAN_ID BIGINT;

ALTER TABLE ITERATION ADD CONSTRAINT fk_iteration_test_plan FOREIGN KEY (TEST_PLAN_ID) REFERENCES TEST_PLAN (TEST_PLAN_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-iteration-testplan', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 36, '9:cc0756d81bf56192693c7bc1f30a77b2', 'addColumn tableName=ITERATION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-index-on-iteration.test_plan_id::pckerneis
CREATE INDEX idx_iteration_test_plan_id ON ITERATION(TEST_PLAN_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-index-on-iteration.test_plan_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 37, '9:7e02cec576c7ba3e00362f7d4bcdd774', 'createIndex indexName=idx_iteration_test_plan_id, tableName=ITERATION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-test_plan.tmp_iteration_id::pckerneis
ALTER TABLE TEST_PLAN ADD TMP_ITERATION_ID BIGINT;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 38, '9:958c4d63ce8bc5dcb7baed32dfd4e7af', 'addColumn tableName=TEST_PLAN', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-index-for-test_plan.tmp_iteration_id::pckerneis
CREATE INDEX idx_test_plan_tmp_iteration_id ON TEST_PLAN(TMP_ITERATION_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-index-for-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 39, '9:9f102b53a6efdcd41348781d4d7792b8', 'createIndex indexName=idx_test_plan_tmp_iteration_id, tableName=TEST_PLAN', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-iteration-test-plans::pckerneis
INSERT INTO TEST_PLAN (CL_ID, TMP_ITERATION_ID)
      SELECT PROJECT.CL_ID, ITERATION.ITERATION_ID
      FROM ITERATION
        JOIN CAMPAIGN_ITERATION ON ITERATION.ITERATION_ID = CAMPAIGN_ITERATION.ITERATION_ID
        JOIN CAMPAIGN_LIBRARY_NODE ON CAMPAIGN_ITERATION.CAMPAIGN_ID = CAMPAIGN_LIBRARY_NODE.CLN_ID
        JOIN PROJECT ON CAMPAIGN_LIBRARY_NODE.PROJECT_ID = PROJECT.PROJECT_ID
      WHERE TEST_PLAN_ID IS NULL;

UPDATE ITERATION
      SET TEST_PLAN_ID = (
        SELECT TEST_PLAN_ID
        FROM TEST_PLAN
        WHERE TMP_ITERATION_ID = ITERATION.ITERATION_ID
      );

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-iteration-test-plans', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 40, '9:d130fc9a5d9be9ae377e145dfcb1ce6d', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-test_plan.tmp_iteration_id::pckerneis
ALTER TABLE TEST_PLAN DROP COLUMN TMP_ITERATION_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 41, '9:92f14b8bde955b1544accc5892636dd6', 'dropColumn columnName=TMP_ITERATION_ID, tableName=TEST_PLAN', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-non-nullable-constraint-to-iteration-test_plan_id::pckerneis
ALTER TABLE ITERATION ALTER COLUMN  TEST_PLAN_ID SET NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-non-nullable-constraint-to-iteration-test_plan_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 42, '9:7fa828dab7adb3b81f097bb8e7d15514', 'addNotNullConstraint columnName=TEST_PLAN_ID, tableName=ITERATION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-test_plan_item.tmp_itpi_id::pckerneis
ALTER TABLE TEST_PLAN_ITEM ADD TMP_ITPI_ID BIGINT;

ALTER TABLE TEST_PLAN_ITEM ADD CONSTRAINT fk_test_plan_item_iteration_test_plan_item FOREIGN KEY (TMP_ITPI_ID) REFERENCES ITERATION_TEST_PLAN_ITEM (ITEM_TEST_PLAN_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 43, '9:4ad56115e6250cf6282e74c9927a5aa8', 'addColumn tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-index-for-test_plan_item.tmp_itpi_id::pckerneis
CREATE INDEX idx_test_plan_item_tmp_itpi_id ON TEST_PLAN_ITEM(TMP_ITPI_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-index-for-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 44, '9:c89cd93093a6822e4cd4489d807dfe40', 'createIndex indexName=idx_test_plan_item_tmp_itpi_id, tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-iteration-test-plan-item::pckerneis
INSERT INTO TEST_PLAN_ITEM (
          TMP_ITPI_ID,
          TEST_PLAN_ID,
          ITEM_ORDER,
          EXECUTION_STATUS,
          LAST_EXECUTED_BY,
          LAST_EXECUTED_ON,
          TCLN_ID,
          DATASET_ID,
          LABEL,
          ASSIGNEE_ID,
          CREATED_BY,
          CREATED_ON,
          LAST_MODIFIED_BY,
          LAST_MODIFIED_ON
      ) SELECT
          itpi.ITEM_TEST_PLAN_ID,
          i.TEST_PLAN_ID,
          itpl.ITEM_TEST_PLAN_ORDER,
          itpi.EXECUTION_STATUS,
          itpi.LAST_EXECUTED_BY,
          itpi.LAST_EXECUTED_ON,
          itpi.TCLN_ID,
          itpi.DATASET_ID,
          itpi.LABEL,
          itpi.USER_ID,
          itpi.CREATED_BY,
          itpi.CREATED_ON,
          itpi.LAST_MODIFIED_BY,
          itpi.LAST_MODIFIED_ON
        FROM ITERATION_TEST_PLAN_ITEM itpi
        JOIN ITEM_TEST_PLAN_LIST itpl ON itpi.ITEM_TEST_PLAN_ID = itpl.ITEM_TEST_PLAN_ID
        JOIN ITERATION i ON itpl.ITERATION_ID = i.ITERATION_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-iteration-test-plan-item', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 45, '9:235da7541a83c7c816a240256043b5be', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-analyze-tables-for-execution-update::jprioux
ANALYZE TEST_PLAN_ITEM;

ANALYZE EXECUTION;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-analyze-tables-for-execution-update', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 46, '9:55e1b8d786886fccf3347e1a936b1895', 'sql; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-iteration-executions::pckerneis
UPDATE EXECUTION e
      SET
        TEST_PLAN_ITEM_ID = (
          SELECT tpi.TEST_PLAN_ITEM_ID
          FROM TEST_PLAN_ITEM tpi
          JOIN ITEM_TEST_PLAN_EXECUTION itpe ON tpi.TMP_ITPI_ID = itpe.ITEM_TEST_PLAN_ID
          WHERE itpe.EXECUTION_ID = e.EXECUTION_ID
        ),
        EXECUTION_ORDER = (
          SELECT itpe.EXECUTION_ORDER
          FROM TEST_PLAN_ITEM tpi
          JOIN ITEM_TEST_PLAN_EXECUTION itpe ON tpi.TMP_ITPI_ID = itpe.ITEM_TEST_PLAN_ID
          WHERE itpe.EXECUTION_ID = e.EXECUTION_ID
        )
      WHERE e.TEST_PLAN_ITEM_ID IS NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-iteration-executions', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 47, '9:850a27a201bf9d8446e10328124b3320', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-unique-constraint-on-execution_order::pckerneis
ALTER TABLE EXECUTION ADD CONSTRAINT uq_execution_execution_order_test_plan_item_id UNIQUE (EXECUTION_ORDER, TEST_PLAN_ITEM_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-unique-constraint-on-execution_order', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 48, '9:ef983d749257e95a585e42be3230b600', 'addUniqueConstraint constraintName=uq_execution_execution_order_test_plan_item_id, tableName=EXECUTION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-non-nullable-constraint-to-execution-test_plan_item_id-and-execution_order::pckerneis
ALTER TABLE EXECUTION ALTER COLUMN  TEST_PLAN_ITEM_ID SET NOT NULL;

ALTER TABLE EXECUTION ALTER COLUMN  EXECUTION_ORDER SET NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-non-nullable-constraint-to-execution-test_plan_item_id-and-execution_order', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 49, '9:b096107ab1c19dad998a54c4a8faa922', 'addNotNullConstraint columnName=TEST_PLAN_ITEM_ID, tableName=EXECUTION; addNotNullConstraint columnName=EXECUTION_ORDER, tableName=EXECUTION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-test_suite_test_plan_item-fk::pckerneis
ALTER TABLE TEST_SUITE_TEST_PLAN_ITEM DROP CONSTRAINT fk_test_suite_test_plan_item_test_plan_item;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-test_suite_test_plan_item-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 50, '9:90ca8cb64e72a7fd92a178d6cd3e7424', 'dropForeignKeyConstraint baseTableName=TEST_SUITE_TEST_PLAN_ITEM, constraintName=fk_test_suite_test_plan_item_test_plan_item', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-test-suite-data::pckerneis
UPDATE TEST_SUITE_TEST_PLAN_ITEM item
      SET TPI_ID = (
        SELECT tpi.TEST_PLAN_ITEM_ID
        FROM TEST_PLAN_ITEM tpi
        JOIN TEST_SUITE_TEST_PLAN_ITEM tstpi ON tpi.TMP_ITPI_ID = tstpi.TPI_ID
        WHERE tstpi.SUITE_ID = item.SUITE_ID AND tstpi.TEST_PLAN_ORDER = item.TEST_PLAN_ORDER
      );

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-test-suite-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 51, '9:fd99b2a4eb9c7e9fef750fc7f94cc737', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-test-suite-item-fk::pckerneis
ALTER TABLE TEST_SUITE_TEST_PLAN_ITEM ADD CONSTRAINT fk_test_suite_test_plan_item_test_plan_item FOREIGN KEY (TPI_ID) REFERENCES TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-test-suite-item-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 52, '9:08549324b419e68cf670433c42609a79', 'addForeignKeyConstraint baseTableName=TEST_SUITE_TEST_PLAN_ITEM, constraintName=fk_test_suite_test_plan_item_test_plan_item, referencedTableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-rename-failure_detail.item_test_plan_id-and-drop-fk::pckerneis
ALTER TABLE FAILURE_DETAIL DROP CONSTRAINT fk_failure_detail_itpi_id;

ALTER TABLE FAILURE_DETAIL RENAME COLUMN ITEM_TEST_PLAN_ID TO TEST_PLAN_ITEM_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-rename-failure_detail.item_test_plan_id-and-drop-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 53, '9:fec6c79158543e0987b769116d89ffb8', 'dropForeignKeyConstraint baseTableName=FAILURE_DETAIL, constraintName=fk_failure_detail_itpi_id; renameColumn newColumnName=TEST_PLAN_ITEM_ID, oldColumnName=ITEM_TEST_PLAN_ID, tableName=FAILURE_DETAIL', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-failure_detail-data::pckerneis
UPDATE FAILURE_DETAIL fd
      SET TEST_PLAN_ITEM_ID = (
        SELECT tpi.TEST_PLAN_ITEM_ID
        FROM TEST_PLAN_ITEM tpi
        JOIN FAILURE_DETAIL fd2 ON tpi.TMP_ITPI_ID = fd2.TEST_PLAN_ITEM_ID
        WHERE fd2.FAILURE_DETAIL_ID = fd.FAILURE_DETAIL_ID
      );

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-failure_detail-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 54, '9:c36d859a5cb225ab794c39b634d7b500', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-fk-to-failure_detail.test_plan_item_id::pckerneis
ALTER TABLE FAILURE_DETAIL ADD CONSTRAINT fk_failure_detail_test_plan_item FOREIGN KEY (TEST_PLAN_ITEM_ID) REFERENCES TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-fk-to-failure_detail.test_plan_item_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 55, '9:20f178830835abe5f5de2e6c164444a7', 'addForeignKeyConstraint baseTableName=FAILURE_DETAIL, constraintName=fk_failure_detail_test_plan_item, referencedTableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-test_plan_item.overview_id::pckerneis
ALTER TABLE TEST_PLAN_ITEM ADD OVERVIEW_ID BIGINT;

ALTER TABLE TEST_PLAN_ITEM ADD CONSTRAINT fk_test_plan_item_exploratory_session_overview FOREIGN KEY (OVERVIEW_ID) REFERENCES EXPLORATORY_SESSION_OVERVIEW (OVERVIEW_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-test_plan_item.overview_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 56, '9:8f21e6422ab33af99a868b82361b89d2', 'addColumn tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-index-on-test_plan_item.overview_id::pckerneis
CREATE INDEX idx_test_plan_item_overview_id ON TEST_PLAN_ITEM(OVERVIEW_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-index-on-test_plan_item.overview_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 57, '9:5cff545e6fc4b35926debee5e9c0f804', 'createIndex indexName=idx_test_plan_item_overview_id, tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-session-overview-data::pckerneis
UPDATE TEST_PLAN_ITEM
      SET OVERVIEW_ID = coalesce(
        (
          SELECT OVERVIEW_ID
          FROM EXPLORATORY_SESSION_OVERVIEW eso
          WHERE eso.TEST_PLAN_ITEM_ID = TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID
          LIMIT 1
        ),
        (
          SELECT OVERVIEW_ID
          FROM EXPLORATORY_SESSION_OVERVIEW eso
          WHERE eso.ITEM_TEST_PLAN_ID = TEST_PLAN_ITEM.TMP_ITPI_ID
          LIMIT 1
        )
      );

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-session-overview-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 58, '9:c15a726de90d4c4d0013f163068667f0', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-test_plan_item.tmp_itpi_id::pckerneis
ALTER TABLE TEST_PLAN_ITEM DROP CONSTRAINT fk_test_plan_item_iteration_test_plan_item;

ALTER TABLE TEST_PLAN_ITEM DROP COLUMN TMP_ITPI_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 59, '9:4a79a13202717f31c6812b248c33e0f7', 'dropForeignKeyConstraint baseTableName=TEST_PLAN_ITEM, constraintName=fk_test_plan_item_iteration_test_plan_item; dropColumn columnName=TMP_ITPI_ID, tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-exploratory_session_overview-test-plan-columns::pckerneis
ALTER TABLE EXPLORATORY_SESSION_OVERVIEW DROP CONSTRAINT fk_exploratory_session_test_plan_item;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW DROP CONSTRAINT fk_exploratory_session_overview;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW DROP COLUMN ITEM_TEST_PLAN_ID;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW DROP COLUMN TEST_PLAN_ITEM_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-exploratory_session_overview-test-plan-columns', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 60, '9:7ac87751311f473f2d1fc39b50b90cf7', 'dropForeignKeyConstraint baseTableName=EXPLORATORY_SESSION_OVERVIEW, constraintName=fk_exploratory_session_test_plan_item; dropForeignKeyConstraint baseTableName=EXPLORATORY_SESSION_OVERVIEW, constraintName=fk_exploratory_session_overview; dropCol...', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-item_test_plan_execution-table::pckerneis
DROP TABLE ITEM_TEST_PLAN_EXECUTION;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-item_test_plan_execution-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 61, '9:5f0f071058f46a87a2387e30e52acf6c', 'dropTable tableName=ITEM_TEST_PLAN_EXECUTION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-item_test_plan_list-table::pckerneis
DROP TABLE ITEM_TEST_PLAN_LIST;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-item_test_plan_list-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 62, '9:9d00a54dd2b8bc69123bc3c15d25ad43', 'dropTable tableName=ITEM_TEST_PLAN_LIST', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-iteration_test_plan_item-table::pckerneis
DROP TABLE ITERATION_TEST_PLAN_ITEM;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-iteration_test_plan_item-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 63, '9:2d204f5a75e9232c7dd63590a47d25d1', 'dropTable tableName=ITERATION_TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-query_column_prototype-for-item_test_plan_tester::pckerneis
UPDATE QUERY_COLUMN_PROTOTYPE SET ATTRIBUTE_NAME = 'assignee.login' WHERE LABEL = 'ITEM_TEST_PLAN_TESTER';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-query_column_prototype-for-item_test_plan_tester', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 64, '9:a097bef0e3b8d918bbd08387754ad46d', 'update tableName=QUERY_COLUMN_PROTOTYPE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-query_column_prototype-for-iteration_itemcount::pckerneis
UPDATE QUERY_COLUMN_PROTOTYPE SET ATTRIBUTE_NAME = 'count(testPlanItems)' WHERE LABEL = 'ITERATION_ITEMCOUNT';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-query_column_prototype-for-iteration_itemcount', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 65, '9:99160695289a1d8e001ccacda21c7adf', 'update tableName=QUERY_COLUMN_PROTOTYPE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-infrasturucture-admin-group::jprioux
INSERT INTO CORE_GROUP (QUALIFIED_NAME) VALUES ('squashtest.authz.group.tm.InfrastructureAdmin');

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-infrasturucture-admin-group', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 66, '9:03f884f749dcbb530204672ff5e601a1', 'insert tableName=CORE_GROUP', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-infrasturucture-admin-group-authority::jprioux
INSERT INTO CORE_GROUP_AUTHORITY (GROUP_ID, AUTHORITY) VALUES ((select ID from CORE_GROUP where QUALIFIED_NAME = 'squashtest.authz.group.tm.InfrastructureAdmin'), 'ROLE_INFRASTRUCTURE_ADMIN');

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-infrasturucture-admin-group-authority', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 67, '9:ab73a79080ca84c86e2208656039ca84', 'insert tableName=CORE_GROUP_AUTHORITY', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-not-null-constraint-on-automated-suite-workflows-suite-id::jprioux
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS ALTER COLUMN  SUITE_ID SET NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-not-null-constraint-on-automated-suite-workflows-suite-id', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 68, '9:3cbfa0e1614ccc5218665ce59bf11617', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-not-null-constraint-on-automated-execution-extender-suite-id::jprioux
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ALTER COLUMN  SUITE_ID SET NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-not-null-constraint-on-automated-execution-extender-suite-id', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 69, '9:fe3bc7bc3baffa37db48781795d0088c', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-remove-role_ta_api_client-and-role_admin-in-core_party_authority::jprioux
DELETE FROM CORE_PARTY_AUTHORITY WHERE authority in ('ROLE_ADMIN', 'ROLE_TA_API_CLIENT');

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-remove-role_ta_api_client-and-role_admin-in-core_party_authority', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 70, '9:26ef93b7d5db31fe7aac3e7dc0a3013e', 'delete tableName=CORE_PARTY_AUTHORITY', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-increase-requirement-sequence-increment::bmsaddek
ALTER SEQUENCE attachment_list_attachment_list_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_audit_event_event_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_folder_sync_extender_rf_sync_extender_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_library_node_rln_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_sync_extender_req_sync_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_version_coverage_requirement_version_coverage_i_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_version_link_link_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_version_link_type_type_id_seq INCREMENT BY 30;

ALTER SEQUENCE resource_res_id_seq INCREMENT BY 30;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-increase-requirement-sequence-increment', 'bmsaddek', 'tm/tm.changelog-10.0.0.xml', NOW(), 71, '9:2e2db0b903cc5ed383b138b6cd8aa867', 'sql; sql; sql; sql; sql; sql; sql; sql; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-increase-requirement-sequence-cache::bmsaddek
ALTER SEQUENCE attachment_list_attachment_list_id_seq CACHE 20;

ALTER SEQUENCE requirement_audit_event_event_id_seq CACHE 20;

ALTER SEQUENCE requirement_folder_sync_extender_rf_sync_extender_id_seq CACHE 20;

ALTER SEQUENCE requirement_library_node_rln_id_seq CACHE 20;

ALTER SEQUENCE requirement_sync_extender_req_sync_id_seq CACHE 20;

ALTER SEQUENCE requirement_version_coverage_requirement_version_coverage_i_seq CACHE 20;

ALTER SEQUENCE requirement_version_link_link_id_seq CACHE 20;

ALTER SEQUENCE requirement_version_link_type_type_id_seq CACHE 20;

ALTER SEQUENCE resource_res_id_seq CACHE 20;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-increase-requirement-sequence-cache', 'bmsaddek', 'tm/tm.changelog-10.0.0.xml', NOW(), 72, '9:aea805d83cebf87c1561b74eac81e6f1', 'sql; sql; sql; sql; sql; sql; sql; sql; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0::pckerneis
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '10.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 73, '9:170245afb47a5a4680a5515c84ca9a1e', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

