/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter;

import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter.BugzillaFields;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Bug;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaField;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Product;

@Component
public class SquashToBugzillaEntityConverter {
    public Bug convertToBugzillaIssue(AdvancedIssue advancedIssue, Product project) {
        Bug bug = new Bug();
        bug.setProduct(project);
        ArrayList<BugzillaField> customFields = new ArrayList<BugzillaField>();
        for (String key : advancedIssue.getFieldValues().keySet()) {
            FieldValue value = advancedIssue.getFieldValue(key);
            BugzillaFields bugzillaFieldType = BugzillaFields.fromString(key);
            switch (bugzillaFieldType) {
                case COMPONENT: {
                    bug.setComponent(value.getScalar());
                    break;
                }
                case CUSTOM: {
                    customFields.add(this.castAsCustomField(key, value));
                    break;
                }
                case HARDWARE: {
                    bug.setHardware(value.getScalar());
                    break;
                }
                case MILESTONE: {
                    bug.setMilestone(value.getScalar());
                    break;
                }
                case OS: {
                    bug.setOs(value.getScalar());
                    break;
                }
                case PRIORITY: {
                    bug.setPriority(value.getScalar());
                    break;
                }
                case SEVERITY: {
                    bug.setSeverity(value.getScalar());
                    break;
                }
                case SUMMARY: {
                    bug.setSummary(value.getScalar());
                    break;
                }
                case VERSION: {
                    bug.setVersion(value.getScalar());
                    break;
                }
                case DESCRIPTION: {
                    bug.setDescription(value.getScalar());
                    break;
                }
                case ASSIGNEE: {
                    bug.setAssignee(value.getScalar());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("YOU SHOULD NOT BE THERE !!!");
                }
            }
        }
        bug.setCustomFields(customFields);
        return bug;
    }

    private BugzillaField castAsCustomField(String key, FieldValue value) {
        BugzillaField bzField = new BugzillaField();
        bzField.setName(key);
        ArrayList<Object> liste = new ArrayList<Object>();
        if (value.getComposite().length == 0) {
            liste.add(value.getScalar());
        } else {
            FieldValue[] fieldValueArray = value.getComposite();
            int n = fieldValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldValue field = fieldValueArray[n2];
                liste.add(field.getScalar());
                ++n2;
            }
        }
        bzField.setValues(liste);
        return bzField;
    }
}

