/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.SortDefault;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UriComponentsBuilder;
import org.squashtest.tm.plugin.rest.core.web.DisableSort;

public class DefaultSortResolver
extends HateoasSortHandlerMethodArgumentResolver {
    public static final String ID = "id";
    private Sort defaultSort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id"});
    private final ThreadLocal<Boolean> userRequestedSort = new ThreadLocal();
    private final ThreadLocal<Sort> parameterDefaultSort = new ThreadLocal();

    public Sort resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        if (parameter.hasParameterAnnotation(DisableSort.class)) {
            this.userRequestedSort.set(false);
            this.parameterDefaultSort.set(null);
            return Sort.unsorted();
        }
        SortDefault sortDefaultAnnotation = (SortDefault)parameter.getParameterAnnotation(SortDefault.class);
        if (sortDefaultAnnotation != null) {
            this.parameterDefaultSort.set(this.getSortFromAnnotation(sortDefaultAnnotation));
        } else {
            this.parameterDefaultSort.set(this.defaultSort);
        }
        String sortParameter = this.getSortParameter(parameter);
        String[] sortValues = webRequest.getParameterValues(sortParameter);
        boolean explicitSortRequested = sortValues != null && Arrays.stream(sortValues).anyMatch(value -> value != null && !value.isBlank());
        this.userRequestedSort.set(explicitSortRequested);
        Sort sort = super.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (sort.isUnsorted()) {
            return this.parameterDefaultSort.get() != null ? this.parameterDefaultSort.get() : this.defaultSort;
        }
        return sort;
    }

    /*
     * WARNING - void declaration
     */
    public void enhance(UriComponentsBuilder builder, @Nullable MethodParameter parameter, @Nullable Object value) {
        if (!(value instanceof Sort)) {
            super.enhance(builder, parameter, value);
            return;
        }
        Sort sort = (Sort)value;
        Boolean explicitSortRequested = this.userRequestedSort.get();
        if (explicitSortRequested.booleanValue()) {
            void sort2;
            super.enhance(builder, parameter, (Object)sort2);
        } else {
            String sortParameter = this.getSortParameter(parameter);
            MultiValueMap params = builder.build().getQueryParams();
            LinkedMultiValueMap newParams = new LinkedMultiValueMap();
            params.forEach((arg_0, arg_1) -> DefaultSortResolver.lambda$1(sortParameter, (MultiValueMap)newParams, arg_0, arg_1));
            builder.replaceQuery(null);
            newParams.forEach((key, values) -> values.forEach(val -> {
                UriComponentsBuilder uriComponentsBuilder2 = builder.queryParam(key, new Object[]{val});
            }));
        }
    }

    private Sort getSortFromAnnotation(SortDefault annotation) {
        String[] sortValues = annotation.sort();
        Sort.Direction direction = annotation.direction();
        if (sortValues.length == 0) {
            return this.defaultSort;
        }
        if (sortValues.length == 1) {
            return Sort.by((Sort.Direction)direction, (String[])new String[]{sortValues[0]});
        }
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        String[] stringArray = sortValues;
        int n = sortValues.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            orders.add(new Sort.Order(direction, property));
            ++n2;
        }
        return Sort.by(orders);
    }

    public void setDefaultSort(Sort defaultSort) {
        this.defaultSort = defaultSort;
    }

    private static /* synthetic */ void lambda$1(String string, MultiValueMap multiValueMap, String key, List values) {
        if (!key.equals(string)) {
            multiValueMap.put((Object)key, (Object)values);
        }
    }
}

