/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import java.util.Date;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.plugin.rest.jackson.model.SprintDto;
import org.squashtest.tm.plugin.rest.validators.helper.RestNodeValidationHelper;

@Component
public class SprintDtoValidationHelper
extends RestNodeValidationHelper {
    public void checkCreateSprintStatus(Errors errors, SprintDto sprintDto) {
        if (Objects.nonNull(sprintDto.getStatus()) && !SprintStatus.UPCOMING.equals((Object)sprintDto.getStatus())) {
            errors.rejectValue("status", "status value", "Status of a new sprint can only be UPCOMING");
        }
    }

    public void checkPatchSprintStatus(Errors errors, SprintDto sprintDto) {
        SprintStatus status = sprintDto.getStatus();
        if (Objects.isNull(status)) {
            return;
        }
        if (!SprintStatus.getSquashStatuses().contains(status)) {
            errors.rejectValue("status", "invalid type", "Invalid sprint status");
        }
    }

    public void checkSprintDates(Errors errors, SprintDto sprintDto) {
        Date startDate;
        Date endDate = sprintDto.getEndDate();
        if (Objects.nonNull(endDate) && Objects.nonNull(startDate = sprintDto.getStartDate()) && endDate.before(startDate)) {
            errors.rejectValue("endDate", "invalid value", "End date must be after start date");
        }
    }
}

