/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.SprintDto;
import org.squashtest.tm.plugin.rest.validators.helper.SprintDtoValidationHelper;

@Component
public class SprintPatchValidator
implements Validator {
    @Inject
    SprintDtoValidationHelper sprintDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return SprintDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        SprintDto sprintDto = (SprintDto)target;
        this.sprintDtoValidationHelper.checkEntityExist(errors, RestType.SPRINT, sprintDto.getId());
        this.sprintDtoValidationHelper.loadProject(sprintDto);
        this.sprintDtoValidationHelper.checkSprintDates(errors, sprintDto);
        this.sprintDtoValidationHelper.checkPatchSprintStatus(errors, sprintDto);
    }
}

