/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.BindException;
import org.springframework.beans.factory.annotation.Configurable;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.plugin.rest.jackson.deserializer.JsonCrawler;
import org.squashtest.tm.plugin.rest.jackson.model.CalledTestStepDto;

@Configurable
public class CallTestStepDeserializer
extends JsonDeserializer<CalledTestStepDto> {
    @Inject
    private JsonCrawler jsonCrawler;

    public CalledTestStepDto deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode index;
        ObjectCodec codec = p.getCodec();
        JsonNode jsonCallStep = (JsonNode)codec.readTree(p);
        CalledTestStepDto callTestStep = new CalledTestStepDto();
        JsonNode jsonDelegateParameter = jsonCallStep.get("delegate_parameter_values");
        if (jsonDelegateParameter != null) {
            callTestStep.setDelegateParameterValues(jsonDelegateParameter.asBoolean());
        }
        if ((index = jsonCallStep.get("index")) != null) {
            callTestStep.setIndex(index.asInt());
        }
        this.deserializeCalledTestCase(jsonCallStep, callTestStep);
        this.deserializeCalledDataset(jsonCallStep, callTestStep);
        return callTestStep;
    }

    private void deserializeCalledDataset(JsonNode jsonCallStep, CalledTestStepDto callTestStep) throws BindException {
        JsonNode jsonCalledDataset = jsonCallStep.get("called_dataset");
        if (jsonCalledDataset != null) {
            if (callTestStep.isDelegateParameterValues()) {
                throw new BindException("Invalid dataset call. You cannot call a dataset from the called test case if you delegate parameters to the calling test case.");
            }
            Dataset dataset = this.jsonCrawler.findMandatoryEntity(jsonCalledDataset, Dataset.class);
            callTestStep.setCalledDataset(dataset);
        }
    }

    private void deserializeCalledTestCase(JsonNode jsonCallStep, CalledTestStepDto callTestStep) throws BindException {
        JsonNode jsonCalledTestCase = jsonCallStep.get("called_test_case");
        if (jsonCalledTestCase != null) {
            TestCase calledTestCase = this.jsonCrawler.findMandatoryEntity(jsonCalledTestCase, TestCase.class);
            callTestStep.setCalledTestCase(calledTestCase);
        }
    }
}

