/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestPlanItemDto;
import org.squashtest.tm.plugin.rest.service.RestTestPlanItemService;
import org.squashtest.tm.plugin.rest.validators.TestPlanItemValidator;

@RestApiController(value=TestPlanItem.class)
@UseDefaultRestApiConfiguration
public class RestTestPlanItemController
extends BaseRestController {
    public static final String STPI_DYNAMIC_FILTER = "*, referenced_test_case[name, reference], referenced_dataset[name], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by";
    public static final String ITPI_DYNAMIC_FILTER = "*, referenced_test_case[name, reference], referenced_dataset[name], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by, iteration[name,reference]";
    @Inject
    private RestTestPlanItemService service;
    @Inject
    private TestPlanItemValidator testPlanItemValidator;
    @Inject
    private ResourceLinksHelper linksHelper;

    @GetMapping(value={"/test-plan-items/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by, iteration[name,reference]")
    public ResponseEntity<EntityModel<TestPlanItem>> findTestPlanItem(@PathVariable(value="id") long id) {
        TestPlanItem tpi = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)tpi);
        this.linksHelper.addAllLinksForTestPlanItem((EntityModel<TestPlanItem>)res);
        return ResponseEntity.ok((Object)res);
    }

    @Deprecated
    @GetMapping(value={"/iteration-test-plan-items/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by, iteration[name,reference]")
    public ResponseEntity<EntityModel<TestPlanItem>> findTpi(@PathVariable(value="id") long id) {
        return this.findTestPlanItem(id);
    }

    @GetMapping(value={"/test-plan-items/{id}/executions"})
    @ResponseBody
    @DynamicFilterExpression(value="name, execution_order, execution_status, last_executed_by, last_executed_on")
    public ResponseEntity<PagedModel<EntityModel<Execution>>> findTestPlanItemExecutions(@PathVariable(value="id") long tpiId, Pageable pageable) {
        Page<Execution> execs = this.service.findExecutions(tpiId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(execs, "executions");
        return ResponseEntity.ok((Object)res);
    }

    @Deprecated
    @GetMapping(value={"/iteration-test-plan-items/{id}/executions"})
    @ResponseBody
    @DynamicFilterExpression(value="name, execution_order, execution_status, last_executed_by, last_executed_on")
    public ResponseEntity<PagedModel<EntityModel<Execution>>> findTpiExecutions(@PathVariable(value="id") long tpiId, Pageable pageable) {
        return this.findTestPlanItemExecutions(tpiId, pageable);
    }

    @PostMapping(value={"/test-plan-items/{id}/executions"})
    @ResponseBody
    @DynamicFilterExpression(value="*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]-progress_status,-charter,-task_division,-session_notes,-reviewed,-execution_events, -test_plan_item")
    public ResponseEntity<EntityModel<Execution>> createNewExecution(@PathVariable(value="id") long tpiId) {
        Execution exec = this.service.createExecution(tpiId);
        EntityModel res = this.toEntityModel((Identified)exec);
        this.linksHelper.addAllLinksForExecution((EntityModel<Execution>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @Deprecated
    @PostMapping(value={"/iteration-test-plan-items/{id}/executions"})
    @ResponseBody
    @DynamicFilterExpression(value="*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]-progress_status,-charter,-task_division,-session_notes,-reviewed,-execution_events, -test_plan_item")
    public ResponseEntity<EntityModel<Execution>> createNewTpiExecution(@PathVariable(value="id") long tpiId) {
        return this.createNewExecution(tpiId);
    }

    @GetMapping(value={"/iteration-test-plan-items"}, params={"remote_key", "server_name"})
    @ResponseBody
    @DynamicFilterExpression(value="id")
    public ResponseEntity<PagedModel<EntityModel<TestPlanItem>>> findItemsByCoveredRemoteRequirement(@RequestParam(value="remote_key") String remoteKey, @RequestParam(value="server_name") String serverName, Pageable pageable) {
        Page<TestPlanItem> items = this.service.findItemsByCoveredRemoteRequirement(pageable, remoteKey, serverName);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(items, "iteration-test-plan-items");
        return ResponseEntity.ok((Object)res);
    }

    @PatchMapping(value={"/test-plan-items/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by, iteration[name,reference]")
    public ResponseEntity<EntityModel<TestPlanItem>> modifyTestPlanItem(@RequestBody TestPlanItemDto tpiDto, @PathVariable(value="id") long testPlanItemId) throws BindException {
        tpiDto.setId(testPlanItemId);
        this.testPlanItemValidator.validatePatchTestPlanItem(tpiDto, testPlanItemId);
        TestPlanItem tpi = this.service.modifyTestPlanItem(tpiDto, testPlanItemId);
        EntityModel res = this.toEntityModel((Identified)tpi);
        this.linksHelper.addAllLinksForTestPlanItem((EntityModel<TestPlanItem>)res);
        return ResponseEntity.ok((Object)res);
    }

    @Deprecated
    @PatchMapping(value={"/iteration-test-plan-items/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by, iteration[name,reference]")
    public ResponseEntity<EntityModel<TestPlanItem>> modifyTpi(@RequestBody TestPlanItemDto tpiDto, @PathVariable(value="id") long testPlanItemId) throws BindException {
        return this.modifyTestPlanItem(tpiDto, testPlanItemId);
    }

    @ResponseBody
    @DeleteMapping(value={"/test-plan-items/{testPlanItemsIds}"})
    public ResponseEntity<Void> removeTestPlanItemsFromIteration(@PathVariable(value="testPlanItemsIds") List<Long> testPlanItemsIds) {
        this.service.deleteTestPlanItems(testPlanItemsIds);
        return ResponseEntity.noContent().build();
    }

    @Deprecated
    @ResponseBody
    @DeleteMapping(value={"/iteration-test-plan-items/{testPlanItemsIds}"})
    public ResponseEntity<Void> removeTpiFromIteration(@PathVariable(value="testPlanItemsIds") List<Long> testPlanItemsIds) {
        return this.removeTestPlanItemsFromIteration(testPlanItemsIds);
    }

    @PostMapping(value={"/iterations/{iterationId}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case, referenced_dataset ")
    public ResponseEntity<EntityModel<TestPlanItem>> addTestCasesToIteration(@RequestBody TestPlanItemDto testPlanItemDto, @PathVariable(value="iterationId") long iterationId) throws BindException {
        this.testPlanItemValidator.validatePostTestPlanItem(testPlanItemDto, iterationId, RestType.ITERATION);
        TestPlanItem tpi = this.service.addIterationTestPlanItem(testPlanItemDto, iterationId);
        EntityModel res = this.toEntityModel((Identified)tpi);
        this.linksHelper.addAllLinksForTestPlanItem((EntityModel<TestPlanItem>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PostMapping(value={"/sprint-req-versions/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<TestPlanItem>> addTestCasesToSprintReqVersion(@RequestBody TestPlanItemDto testPlanItemDto, @PathVariable(value="id") long sprintReqVersionId) throws BindException {
        this.testPlanItemValidator.validatePostTestPlanItem(testPlanItemDto, sprintReqVersionId, RestType.SPRINT_REQ_VERSION);
        TestPlanItem tpi = this.service.addSprintReqVersionTestPlanItem(testPlanItemDto, sprintReqVersionId);
        EntityModel res = this.toEntityModel((Identified)tpi);
        this.linksHelper.addAllLinksForTestPlanItem((EntityModel<TestPlanItem>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }
}

