/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.DisableSort;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.SprintReqVersionDto;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestSprintReqVersionService;
import org.squashtest.tm.plugin.rest.validators.SprintReqVersionPatchValidator;

@RestApiController(value=SprintReqVersion.class)
public class RestSprintReqVersionController
extends BaseRestController {
    public static final String TEST_PLAN = "test-plan";
    @Inject
    private RestSprintReqVersionService sprintReqVersionService;
    @Inject
    private SprintReqVersionPatchValidator sprintReqVersionPatchValidator;
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/sprint-req-versions/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], requirement_version[name], sprint[name]")
    public ResponseEntity<EntityModel<SprintReqVersion>> findSprintReqVersion(@PathVariable(value="id") long id) {
        SprintReqVersion sprintReqVersion = this.sprintReqVersionService.getOne(id);
        EntityModel entityModel = this.toEntityModel((Identified)sprintReqVersion);
        entityModel.add(this.linkService.createLinkTo((Identified)sprintReqVersion.getSprint()));
        return ResponseEntity.ok((Object)entityModel);
    }

    @DeleteMapping(value={"/sprint-req-versions/{ids}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteSprintReqVersions(@PathVariable(value="ids") List<Long> ids) {
        this.sprintReqVersionService.deleteSprintReqVersionsByIds(ids);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/sprint-req-versions/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<SprintReqVersion>> patchSprintReqVersion(@RequestBody SprintReqVersionDto sprintReqVersionDto, @PathVariable(value="id") long id) throws BindException {
        sprintReqVersionDto.setId(id);
        this.validatePatchSprintReqVersion(sprintReqVersionDto);
        SprintReqVersion sprintReqVersion = this.sprintReqVersionService.patchSprintReqVersion(id, sprintReqVersionDto);
        EntityModel res = this.toEntityModel((Identified)sprintReqVersion);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/sprint-req-versions/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by")
    public ResponseEntity<PagedModel<EntityModel<TestPlanItem>>> findSprintReqVersionTestPlan(@PathVariable(value="id") long sprintReqVersionId, @DisableSort Pageable pageable) {
        Page<TestPlanItem> testPlanItems = this.sprintReqVersionService.findSprintReqVersionTestPlan(sprintReqVersionId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(testPlanItems, TEST_PLAN);
        return ResponseEntity.ok((Object)res);
    }

    private void validatePatchSprintReqVersion(SprintReqVersionDto sprintReqVersionDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)sprintReqVersionDto, "patch-sprint-req-version");
        this.sprintReqVersionPatchValidator.validate(sprintReqVersionDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(sprintReqVersionDto, errors, "patch-sprint-req-version");
    }

    @GetMapping(value={"/sprint-req-versions/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="executions[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findSprintReqVersionIssues(@PathVariable(value="id") long id, Pageable pageable) {
        List<Long> executionIds = this.sprintReqVersionService.getExecutionIdsBySprintReqVersion(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(executionIds, pageable);
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }
}

