/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.AutomatedTestTechnologyDto;
import org.squashtest.tm.plugin.rest.service.RestAutomatedTestTechnologyService;
import org.squashtest.tm.plugin.rest.validators.AutomatedTestTechnologyValidator;

@UseDefaultRestApiConfiguration
@RestApiController(value=AutomatedTestTechnology.class)
public class RestAutomatedTestTechnologyController
extends BaseRestController {
    @Inject
    private RestAutomatedTestTechnologyService restAutomatedTestTechnologyService;
    @Inject
    private AutomatedTestTechnologyValidator automatedTestTechnologyValidator;

    @ResponseBody
    @EntityGetter
    @GetMapping(value={"/automated-test-technologies/{id}"})
    public ResponseEntity<EntityModel<AutomatedTestTechnology>> findAutomatedTestTechnology(@PathVariable(value="id") long technologyId) {
        AutomatedTestTechnology technology = this.restAutomatedTestTechnologyService.getOne(technologyId);
        EntityModel resource = this.toEntityModel((Identified)technology);
        return ResponseEntity.ok((Object)resource);
    }

    @ResponseBody
    @GetMapping(value={"/automated-test-technologies"})
    public ResponseEntity<PagedModel<EntityModel<AutomatedTestTechnology>>> findAllAutomatedTestTechnologies(Pageable pageable) {
        Page<AutomatedTestTechnology> technologies = this.restAutomatedTestTechnologyService.findAll(pageable);
        PagedModel result = this.toPagedModel(technologies);
        return ResponseEntity.ok((Object)result);
    }

    @ResponseBody
    @PostMapping(value={"/automated-test-technologies"})
    public ResponseEntity<EntityModel<AutomatedTestTechnology>> insertAutomatedTestTechnology(@RequestBody AutomatedTestTechnologyDto automatedTestTechnologyDto) throws BindException {
        this.automatedTestTechnologyValidator.validatePostAutomatedTestTechnology(automatedTestTechnologyDto);
        AutomatedTestTechnology newTechnology = this.restAutomatedTestTechnologyService.addAutomatedTestTechnology(automatedTestTechnologyDto);
        EntityModel resource = this.toEntityModel((Identified)newTechnology);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)resource);
    }
}

