/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.domain;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.squashtest.tm.plugin.redminereq.domain.FieldLink;
import org.squashtest.tm.plugin.redminereq.domain.FieldMapping;
import org.squashtest.tm.plugin.redminereq.domain.FilterBinding;

public class Configuration {
    private Boolean allowToDeleteReq = false;
    private Long serverId = 0L;
    private Set<FilterBinding> filterBindings = new HashSet<FilterBinding>();
    private List<FieldMapping> fieldMappings = FieldMapping.getBuiltinMapping();
    private List<FieldLink> fieldLinks = FieldLink.getBuiltinLink();
    private String yamlFieldvalueMapping = "";

    public Configuration() {
    }

    public Configuration(Long serverId, Set<FilterBinding> filterBindings) {
        this.serverId = serverId;
        this.filterBindings = filterBindings;
    }

    public Long getServerId() {
        return this.serverId;
    }

    public void setServerId(Long serverId) {
        this.serverId = serverId;
    }

    public boolean hasServer() {
        return this.serverId != 0L;
    }

    public Collection<FilterBinding> getFilterBindings() {
        return this.filterBindings;
    }

    public void setFilterBindings(Set<FilterBinding> filterBindings) {
        this.filterBindings = filterBindings;
    }

    public void setFilterBindings(Collection<FilterBinding> filterBindings) {
        this.filterBindings = new HashSet<FilterBinding>(filterBindings);
    }

    public void addFilterBinding(FilterBinding binding) {
        this.filterBindings.add(binding);
    }

    public FilterBinding removeFilterBinding(FilterBinding binding) {
        FilterBinding found = this.findFilter(binding);
        if (found != null) {
            this.filterBindings.remove(found);
            return found;
        }
        return null;
    }

    public FilterBinding removeFilterBinding(String id) {
        return this.removeFilterBinding(FilterBinding.byId(id));
    }

    public FilterBinding findFilter(FilterBinding key) {
        for (FilterBinding fb : this.filterBindings) {
            if (!fb.equals(key)) continue;
            return fb;
        }
        return null;
    }

    public FilterBinding findFilterById(String id) {
        return this.findFilter(FilterBinding.byId(id));
    }

    public boolean hasFilterBinding(String id) {
        return this.findFilterById(id) != null;
    }

    public boolean hasFilterBinding(FilterBinding filter) {
        return this.findFilter(filter) != null;
    }

    public List<FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public List<FieldLink> getFieldLinks() {
        return this.fieldLinks;
    }

    public void setFieldMappings(List<FieldMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public void setFieldLinks(List<FieldLink> fieldLinks) {
        this.fieldLinks = fieldLinks;
    }

    public void addFieldMapping(FieldMapping mapping) {
        this.fieldMappings.add(mapping);
    }

    public void removeFieldMapping(FieldMapping mapping) {
        this.fieldMappings.remove((Object)mapping);
    }

    public void resetFieldLink(FieldLink link) {
        for (FieldLink key : this.fieldLinks) {
            if (!key.getId().equals(link.getId())) continue;
            key.setSquashField(null);
        }
    }

    public void removeFieldMapping(String mappingId) {
        FieldMapping key = FieldMapping.byId(mappingId);
        this.fieldMappings.remove((Object)key);
    }

    public FieldMapping getFieldMapping(String id) {
        for (FieldMapping m : this.fieldMappings) {
            if (!m.getId().equals(id)) continue;
            return m;
        }
        return null;
    }

    public FieldLink getFieldLink(String id) {
        for (FieldLink l : this.fieldLinks) {
            if (!l.getId().equals(id)) continue;
            return l;
        }
        return null;
    }

    public FieldMapping getFieldMapping(FieldMapping key) {
        return this.getFieldMapping(key.getId());
    }

    public boolean hasFieldMapping(String id) {
        FieldMapping key = FieldMapping.byId(id);
        return this.fieldMappings.contains((Object)key);
    }

    public boolean hasFieldMapping(FieldMapping mapping) {
        return this.fieldMappings.contains((Object)mapping);
    }

    public Set<String> getMappedRedmineFields() {
        HashSet<String> fields = new HashSet<String>(this.fieldMappings.size());
        for (FieldMapping mapping : this.fieldMappings) {
            fields.add(mapping.getRedmineField());
        }
        return fields;
    }

    public Set<String> getLinkedRedmineFields() {
        HashSet<String> fields = new HashSet<String>(this.fieldLinks.size());
        for (FieldLink link : this.fieldLinks) {
            fields.add(link.getSquashField());
        }
        return fields;
    }

    public String getYamlFieldvalueMapping() {
        return this.yamlFieldvalueMapping != null ? this.yamlFieldvalueMapping : "";
    }

    public void setYamlFieldvalueMapping(String yamlFieldvalueMapping) {
        this.yamlFieldvalueMapping = yamlFieldvalueMapping;
    }

    public Boolean getAllowToDeleteReq() {
        return this.allowToDeleteReq;
    }

    public void setAllowToDeleteReq(Boolean allowToDeleteReq) {
        this.allowToDeleteReq = allowToDeleteReq;
    }
}

