/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.event.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import jirarest.com.atlassian.event.api.EventPublisher;
import jirarest.com.atlassian.event.config.ListenerHandlersConfiguration;
import jirarest.com.atlassian.event.internal.ClassUtils;
import jirarest.com.atlassian.event.internal.InvokerTransformer;
import jirarest.com.atlassian.event.spi.EventDispatcher;
import jirarest.com.atlassian.event.spi.ListenerHandler;
import jirarest.com.atlassian.event.spi.ListenerInvoker;
import jirarest.javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LockFreeEventPublisher
implements EventPublisher {
    private final InvokerBuilder invokerBuilder;
    private final Publisher publisher;
    private final Listeners listeners = new Listeners();

    public LockFreeEventPublisher(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this(eventDispatcher, listenerHandlersConfiguration, new InvokerTransformer(){

            @Override
            @Nonnull
            public Iterable<ListenerInvoker> transformAll(@Nonnull Iterable<ListenerInvoker> invokers, @Nonnull Object event) {
                return invokers;
            }
        });
    }

    public LockFreeEventPublisher(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration, InvokerTransformer transformer) {
        this.invokerBuilder = new InvokerBuilder(((ListenerHandlersConfiguration)Preconditions.checkNotNull((Object)listenerHandlersConfiguration)).getListenerHandlers());
        this.publisher = new Publisher(eventDispatcher, this.listeners, transformer);
    }

    @Override
    public void publish(@Nonnull Object event) {
        Preconditions.checkNotNull((Object)event);
        this.publisher.dispatch(event);
    }

    @Override
    public void register(@Nonnull Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.register(listener, this.invokerBuilder.build(listener));
    }

    @Override
    public void unregister(@Nonnull Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.remove(listener);
    }

    @Override
    public void unregisterAll() {
        this.listeners.clear();
    }

    static final class InvokerBuilder {
        private final Iterable<ListenerHandler> listenerHandlers;

        InvokerBuilder(@Nonnull Iterable<ListenerHandler> listenerHandlers) {
            this.listenerHandlers = (Iterable)Preconditions.checkNotNull(listenerHandlers);
        }

        Iterable<ListenerInvoker> build(Object listener) throws IllegalArgumentException {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenerHandler listenerHandler : this.listenerHandlers) {
                builder.addAll(listenerHandler.getInvokers(listener));
            }
            ImmutableList invokers = builder.build();
            if (invokers.isEmpty()) {
                throw new IllegalArgumentException("No listener invokers were found for listener <" + listener + ">");
            }
            return invokers;
        }
    }

    static final class Publisher {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final Listeners listeners;
        private final EventDispatcher dispatcher;
        private final InvokerTransformer transformer;
        private final Function<Class, Iterable<ListenerInvoker>> eventClassToInvokersTransformer = new Function<Class, Iterable<ListenerInvoker>>(){

            public Iterable<ListenerInvoker> apply(Class eventClass) {
                return Publisher.this.listeners.get(eventClass);
            }
        };

        Publisher(EventDispatcher dispatcher, Listeners listeners, InvokerTransformer transformer) {
            this.dispatcher = (EventDispatcher)Preconditions.checkNotNull((Object)dispatcher);
            this.listeners = (Listeners)Preconditions.checkNotNull((Object)listeners);
            this.transformer = (InvokerTransformer)Preconditions.checkNotNull((Object)transformer);
        }

        public void dispatch(Object event) {
            Iterable<ListenerInvoker> invokers = this.getInvokers(event);
            try {
                invokers = this.transformer.transformAll(invokers, event);
            }
            catch (Exception e) {
                this.log.error("Exception while transforming invokers. Dispatching original invokers instead.", (Throwable)e);
            }
            for (ListenerInvoker invoker : invokers) {
                try {
                    this.dispatcher.dispatch(invoker, event);
                }
                catch (Exception e) {
                    this.log.error("There was an exception thrown trying to dispatch event '" + event + "' from the invoker '" + invoker + "'.", (Throwable)e);
                }
            }
        }

        Iterable<ListenerInvoker> getInvokers(Object event) {
            Set<Class<?>> allEventTypes = ClassUtils.findAllTypes(event.getClass());
            return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(allEventTypes, this.eventClassToInvokersTransformer)));
        }
    }

    static final class Invokers {
        private final ConcurrentMap<Object, ListenerInvoker> listeners = new MapMaker().weakKeys().makeMap();

        Invokers() {
        }

        Iterable<ListenerInvoker> all() {
            return this.listeners.values();
        }

        public void remove(Object key) {
            this.listeners.remove(key);
        }

        public void add(Object key, ListenerInvoker invoker) {
            this.listeners.put(key, invoker);
        }
    }

    static final class Listeners {
        private final LoadingCache<Class<?>, Invokers> invokers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Invokers>(){

            public Invokers load(Class<?> key) throws Exception {
                return new Invokers();
            }
        });

        Listeners() {
        }

        void register(Object listener, Iterable<ListenerInvoker> invokers) {
            for (ListenerInvoker invoker : invokers) {
                this.register(listener, invoker);
            }
        }

        private void register(Object listener, ListenerInvoker invoker) {
            if (invoker.getSupportedEventTypes().isEmpty()) {
                ((Invokers)this.invokers.getUnchecked(Object.class)).add(listener, invoker);
            } else {
                for (Class<?> eventClass : invoker.getSupportedEventTypes()) {
                    ((Invokers)this.invokers.getUnchecked(eventClass)).add(listener, invoker);
                }
            }
        }

        void remove(Object listener) {
            for (Invokers entry : ImmutableList.copyOf(this.invokers.asMap().values())) {
                entry.remove(listener);
            }
        }

        void clear() {
            this.invokers.invalidateAll();
        }

        public Iterable<ListenerInvoker> get(Class<?> eventClass) {
            return ((Invokers)this.invokers.getUnchecked(eventClass)).all();
        }
    }
}

