/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.async;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jiracloud.com.atlassian.httpclient.apache.httpcomponents.MultiPartEntityBuilder;
import jiracloud.com.atlassian.httpclient.api.HttpClient;
import jiracloud.com.atlassian.httpclient.api.Message;
import jiracloud.com.atlassian.httpclient.api.Response;
import jiracloud.com.atlassian.httpclient.api.ResponsePromise;
import jiracloud.com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptions;
import jiracloud.com.atlassian.jira.rest.client.api.IssueRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.MetadataRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.RestClientException;
import jiracloud.com.atlassian.jira.rest.client.api.SessionRestClient;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BulkOperationResult;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CimProject;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Comment;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Issue;
import jiracloud.com.atlassian.jira.rest.client.api.domain.IssueType;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Page;
import jiracloud.com.atlassian.jira.rest.client.api.domain.ServerInfo;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Transition;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Votes;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Watchers;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.AttachmentInput;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.WorklogInput;
import jiracloud.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jiracloud.com.atlassian.jira.rest.client.internal.json.BasicIssueJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.BasicIssuesJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.CreateIssueMetaFieldsParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.CreateIssueMetaProjectIssueTypesParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.CreateIssueMetadataJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jiracloud.com.atlassian.jira.rest.client.internal.json.TransitionJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.TransitionJsonParserV5;
import jiracloud.com.atlassian.jira.rest.client.internal.json.VotesJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.CommentJsonGenerator;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.IssueInputJsonGenerator;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.IssueUpdateJsonGenerator;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.IssuesInputJsonGenerator;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.LinkIssuesInputGenerator;
import jiracloud.com.atlassian.jira.rest.client.internal.json.gen.WorklogInputJsonGenerator;
import jiracloud.com.sun.ws.rs.core.UriBuilder;
import jiracloud.io.atlassian.util.concurrent.Promise;
import jiracloud.javax.annotation.Nonnull;
import jiracloud.javax.annotation.Nullable;
import jiracloud.org.apache.http.entity.ContentType;
import jiracloud.org.apache.http.entity.mime.MultipartEntityBuilder;
import jiracloud.org.codehaus.jettison.json.JSONArray;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;

public class AsynchronousIssueRestClient
extends AbstractAsynchronousRestClient
implements IssueRestClient {
    private static final EnumSet<IssueRestClient.Expandos> DEFAULT_EXPANDS = EnumSet.of(IssueRestClient.Expandos.NAMES, IssueRestClient.Expandos.SCHEMA, IssueRestClient.Expandos.TRANSITIONS);
    private static final Function<IssueRestClient.Expandos, String> EXPANDO_TO_PARAM = from -> from.name().toLowerCase();
    private final SessionRestClient sessionRestClient;
    private final MetadataRestClient metadataRestClient;
    private final IssueJsonParser issueParser = new IssueJsonParser();
    private final BasicIssueJsonParser basicIssueParser = new BasicIssueJsonParser();
    private final JsonObjectParser<Watchers> watchersParser = WatchersJsonParserBuilder.createWatchersParser();
    private final TransitionJsonParser transitionJsonParser = new TransitionJsonParser();
    private final JsonObjectParser<Transition> transitionJsonParserV5 = new TransitionJsonParserV5();
    private final VotesJsonParser votesJsonParser = new VotesJsonParser();
    private final CreateIssueMetadataJsonParser createIssueMetadataJsonParser = new CreateIssueMetadataJsonParser();
    private static final String FILE_BODY_TYPE = "file";
    private final URI baseUri;
    private ServerInfo serverInfo;

    public AsynchronousIssueRestClient(URI baseUri, HttpClient client, SessionRestClient sessionRestClient, MetadataRestClient metadataRestClient) {
        super(client);
        this.baseUri = baseUri;
        this.sessionRestClient = sessionRestClient;
        this.metadataRestClient = metadataRestClient;
    }

    private synchronized ServerInfo getVersionInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = this.metadataRestClient.getServerInfo().claim();
        }
        return this.serverInfo;
    }

    @Override
    public Promise<BasicIssue> createIssue(IssueInput issue) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path("issue");
        return this.postAndParse(uriBuilder.build(new Object[0]), issue, new IssueInputJsonGenerator(), this.basicIssueParser);
    }

    @Override
    public Promise<Void> updateIssue(String issueKey, IssueInput issue) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path("issue").path(issueKey);
        return this.put(uriBuilder.build(new Object[0]), issue, new IssueInputJsonGenerator());
    }

    @Override
    public Promise<BulkOperationResult<BasicIssue>> createIssues(Collection<IssueInput> issues) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path("issue/bulk");
        return this.postAndParse(uriBuilder.build(new Object[0]), issues, new IssuesInputJsonGenerator(), new BasicIssuesJsonParser());
    }

    @Override
    public Promise<Iterable<CimProject>> getCreateIssueMetadata(@Nullable GetCreateIssueMetadataOptions options) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path("issue/createmeta");
        if (options != null) {
            Iterable<String> expandos;
            Iterable<String> issueTypeNames;
            if (options.projectIds != null) {
                uriBuilder.queryParam("projectIds", Joiner.on((String)",").join(options.projectIds));
            }
            if (options.projectKeys != null) {
                uriBuilder.queryParam("projectKeys", Joiner.on((String)",").join(options.projectKeys));
            }
            if (options.issueTypeIds != null) {
                uriBuilder.queryParam("issuetypeIds", Joiner.on((String)",").join(options.issueTypeIds));
            }
            if ((issueTypeNames = options.issueTypeNames) != null) {
                for (String name : issueTypeNames) {
                    uriBuilder.queryParam("issuetypeNames", name);
                }
            }
            if ((expandos = options.expandos) != null && expandos.iterator().hasNext()) {
                uriBuilder.queryParam("expand", Joiner.on((String)",").join(expandos));
            }
        }
        return this.getAndParse(uriBuilder.build(new Object[0]), this.createIssueMetadataJsonParser);
    }

    @Override
    public Promise<Page<IssueType>> getCreateIssueMetaProjectIssueTypes(@Nonnull String projectIdOrKey, @Nullable Long startAt, @Nullable Integer maxResults) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path("issue/createmeta/" + projectIdOrKey + "/issuetypes");
        this.addPagingParameters(uriBuilder, startAt, maxResults);
        return this.getAndParse(uriBuilder.build(new Object[0]), new CreateIssueMetaProjectIssueTypesParser());
    }

    @Override
    public Promise<Page<CimFieldInfo>> getCreateIssueMetaFields(@Nonnull String projectIdOrKey, @Nonnull String issueTypeId, @Nullable Long startAt, @Nullable Integer maxResults) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path("issue/createmeta/" + projectIdOrKey + "/issuetypes/" + issueTypeId);
        this.addPagingParameters(uriBuilder, startAt, maxResults);
        return this.getAndParse(uriBuilder.build(new Object[0]), new CreateIssueMetaFieldsParser());
    }

    @Override
    public Promise<Issue> getIssue(String issueKey) {
        return this.getIssue(issueKey, Collections.emptyList());
    }

    @Override
    public Promise<Issue> getIssue(String issueKey, Iterable<IssueRestClient.Expandos> expand) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri);
        Iterable expands = Iterables.concat(DEFAULT_EXPANDS, expand);
        uriBuilder.path("issue").path(issueKey).queryParam("expand", StreamSupport.stream(expands.spliterator(), false).map(EXPANDO_TO_PARAM).collect(Collectors.joining(",")));
        return this.getAndParse(uriBuilder.build(new Object[0]), this.issueParser);
    }

    @Override
    public Promise<Void> deleteIssue(String issueKey, boolean deleteSubtasks) {
        return this.delete(UriBuilder.fromUri(this.baseUri).path("issue").path(issueKey).queryParam("deleteSubtasks", deleteSubtasks).build(new Object[0]));
    }

    @Override
    public Promise<Watchers> getWatchers(URI watchersUri) {
        return this.getAndParse(watchersUri, this.watchersParser);
    }

    @Override
    public Promise<Votes> getVotes(URI votesUri) {
        return this.getAndParse(votesUri, this.votesJsonParser);
    }

    @Override
    public Promise<Iterable<Transition>> getTransitions(URI transitionsUri) {
        return this.callAndParse(this.client().newRequest(transitionsUri).get(), (Response response) -> {
            JSONObject jsonObject = new JSONObject(response.getEntity());
            if (jsonObject.has("transitions")) {
                return JsonParseUtil.parseJsonArray(jsonObject.getJSONArray("transitions"), this.transitionJsonParserV5);
            }
            ArrayList<Transition> transitions = new ArrayList<Transition>(jsonObject.length());
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                try {
                    int id = Integer.parseInt(key);
                    Transition transition = this.transitionJsonParser.parse(jsonObject.getJSONObject(key), id);
                    transitions.add(transition);
                }
                catch (JSONException e) {
                    throw new RestClientException(e);
                }
                catch (NumberFormatException e) {
                    throw new RestClientException("Transition id should be an integer, but found [" + key + "]", e);
                }
            }
            return transitions;
        });
    }

    @Override
    public Promise<Iterable<Transition>> getTransitions(Issue issue) {
        if (issue.getTransitionsUri() != null) {
            return this.getTransitions(issue.getTransitionsUri());
        }
        UriBuilder transitionsUri = UriBuilder.fromUri(issue.getSelf());
        return this.getTransitions(transitionsUri.path("transitions").queryParam("expand", "transitions.fields").build(new Object[0]));
    }

    @Override
    public Promise<Void> transition(URI transitionsUri, TransitionInput transitionInput) {
        int buildNumber = this.getVersionInfo().getBuildNumber();
        try {
            Iterable<FieldInput> fields;
            JSONObject fieldsJs;
            JSONObject jsonObject = new JSONObject();
            if (buildNumber >= 700) {
                jsonObject.put("transition", new JSONObject().put("id", transitionInput.getId()));
            } else {
                jsonObject.put("transition", transitionInput.getId());
            }
            if (transitionInput.getComment() != null) {
                if (buildNumber >= 700) {
                    jsonObject.put("update", new JSONObject().put("comment", new JSONArray().put(new JSONObject().put("add", new CommentJsonGenerator(this.getVersionInfo()).generate(transitionInput.getComment())))));
                } else {
                    jsonObject.put("comment", new CommentJsonGenerator(this.getVersionInfo()).generate(transitionInput.getComment()));
                }
            }
            if ((fieldsJs = new IssueUpdateJsonGenerator().generate(fields = transitionInput.getFields())).keys().hasNext()) {
                jsonObject.put("fields", fieldsJs);
            }
            if (fieldsJs.keys().hasNext()) {
                jsonObject.put("fields", fieldsJs);
            }
            return this.post(transitionsUri, jsonObject);
        }
        catch (JSONException ex) {
            throw new RestClientException(ex);
        }
    }

    @Override
    public Promise<Void> transition(Issue issue, TransitionInput transitionInput) {
        if (issue.getTransitionsUri() != null) {
            return this.transition(issue.getTransitionsUri(), transitionInput);
        }
        UriBuilder uriBuilder = UriBuilder.fromUri(issue.getSelf());
        uriBuilder.path("transitions");
        return this.transition(uriBuilder.build(new Object[0]), transitionInput);
    }

    @Override
    public Promise<Void> vote(URI votesUri) {
        return this.post(votesUri);
    }

    @Override
    public Promise<Void> unvote(URI votesUri) {
        return this.delete(votesUri);
    }

    @Override
    public Promise<Void> watch(URI watchersUri) {
        return this.post(watchersUri);
    }

    @Override
    public Promise<Void> unwatch(URI watchersUri) {
        return this.removeWatcher(watchersUri, this.getLoggedUsername());
    }

    @Override
    public Promise<Void> addWatcher(URI watchersUri, String username) {
        return this.post(watchersUri, JSONObject.quote(username));
    }

    @Override
    public Promise<Void> removeWatcher(URI watchersUri, String username) {
        UriBuilder uriBuilder = UriBuilder.fromUri(watchersUri);
        if (this.getVersionInfo().getBuildNumber() >= 640) {
            uriBuilder.queryParam("username", username);
        } else {
            uriBuilder.path(username).build(new Object[0]);
        }
        return this.delete(uriBuilder.build(new Object[0]));
    }

    @Override
    public Promise<Void> linkIssue(LinkIssuesInput linkIssuesInput) {
        URI uri = UriBuilder.fromUri(this.baseUri).path("issueLink").build(new Object[0]);
        return this.post(uri, linkIssuesInput, new LinkIssuesInputGenerator(this.getVersionInfo()));
    }

    @Override
    public Promise<Void> addAttachment(URI attachmentsUri, InputStream inputStream, String filename) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setLaxMode().setCharset(StandardCharsets.UTF_8).addBinaryBody(FILE_BODY_TYPE, inputStream, ContentType.DEFAULT_BINARY, filename);
        return this.postAttachments(attachmentsUri, entityBuilder);
    }

    @Override
    public Promise<Void> addAttachments(URI attachmentsUri, AttachmentInput ... attachments) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setLaxMode().setCharset(StandardCharsets.UTF_8);
        for (AttachmentInput attachmentInput : attachments) {
            entityBuilder.addBinaryBody(FILE_BODY_TYPE, attachmentInput.getInputStream(), ContentType.DEFAULT_BINARY, attachmentInput.getFilename());
        }
        return this.postAttachments(attachmentsUri, entityBuilder);
    }

    @Override
    public Promise<Void> addAttachments(URI attachmentsUri, File ... files) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setLaxMode().setCharset(StandardCharsets.UTF_8);
        for (File file : files) {
            entityBuilder.addBinaryBody(FILE_BODY_TYPE, file);
        }
        return this.postAttachments(attachmentsUri, entityBuilder);
    }

    @Override
    public Promise<Void> addComment(URI commentsUri, Comment comment) {
        return this.post(commentsUri, comment, new CommentJsonGenerator(this.getVersionInfo()));
    }

    @Override
    public Promise<InputStream> getAttachment(URI attachmentUri) {
        return this.callAndParse(this.client().newRequest(attachmentUri).get(), Message::getEntityStream);
    }

    @Override
    public Promise<Void> addWorklog(URI worklogUri, WorklogInput worklogInput) {
        UriBuilder uriBuilder = UriBuilder.fromUri(worklogUri).queryParam("adjustEstimate", worklogInput.getAdjustEstimate().restValue);
        switch (worklogInput.getAdjustEstimate()) {
            case NEW: {
                uriBuilder.queryParam("newEstimate", Strings.nullToEmpty((String)worklogInput.getAdjustEstimateValue()));
                break;
            }
            case MANUAL: {
                uriBuilder.queryParam("reduceBy", Strings.nullToEmpty((String)worklogInput.getAdjustEstimateValue()));
            }
        }
        return this.post(uriBuilder.build(new Object[0]), worklogInput, new WorklogInputJsonGenerator());
    }

    private void addPagingParameters(UriBuilder uriBuilder, @Nullable Long startAt, @Nullable Integer maxResults) {
        if (startAt != null) {
            uriBuilder.queryParam("startAt", startAt);
        }
        if (maxResults != null) {
            uriBuilder.queryParam("maxResults", maxResults);
        }
    }

    private Promise<Void> postAttachments(URI attachmentsUri, MultipartEntityBuilder multipartEntityBuilder) {
        ResponsePromise responsePromise = this.client().newRequest(attachmentsUri).setEntity(new MultiPartEntityBuilder(multipartEntityBuilder.build())).setHeader("X-Atlassian-Token", "nocheck").post();
        return this.call(responsePromise);
    }

    private String getLoggedUsername() {
        return this.sessionRestClient.getCurrentSession().claim().getUsername();
    }
}

