/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.domain;

import java.util.Date;
import java.util.List;

public final class GitLabIssueCreationParameters {
    public final String projectPath;
    public final String title;
    public final String description;
    public final Boolean confidential;
    public final List<Integer> assigneeIds;
    public final Integer milestoneId;
    public final String labels;
    public final Date createdAt;
    public final Date dueDate;
    public final Integer mergeRequestToResolveId;
    public final Integer discussionToResolveId;
    public final List<LinkedIssue> linkedIssues;
    public final Integer epicId;

    public GitLabIssueCreationParameters(String projectPath, String title, String description, Boolean confidential, List<Integer> assigneeIds, Integer milestoneId, String labels, Date createdAt, Date dueDate, Integer mergeRequestToResolveId, Integer discussionToResolveId, List<LinkedIssue> linkedIssues, Integer epicId) {
        this.projectPath = projectPath;
        this.title = title;
        this.description = description;
        this.confidential = confidential;
        this.assigneeIds = assigneeIds;
        this.milestoneId = milestoneId;
        this.labels = labels;
        this.createdAt = createdAt;
        this.dueDate = dueDate;
        this.mergeRequestToResolveId = mergeRequestToResolveId;
        this.discussionToResolveId = discussionToResolveId;
        this.linkedIssues = linkedIssues;
        this.epicId = epicId;
    }

    public static class LinkedIssue {
        public final LinkedIssueType linkType;
        public final String issueIidOrUrl;

        public LinkedIssue(LinkedIssueType type, String issueIidOrUrl) {
            this.linkType = type;
            this.issueIidOrUrl = issueIidOrUrl;
        }
    }

    public static enum LinkedIssueType {
        RELATES("relates_to", "relates"),
        BLOCKS("blocks", "blocks"),
        IS_BLOCKED_BY("is_blocked_by", "blocked-by");

        public final String value;
        public final String i18nKey;

        private LinkedIssueType(String value, String localeKeyPart) {
            this.value = value;
            this.i18nKey = String.format("interface.report.issue-link-type.%s.label", localeKeyPart);
        }
    }
}

