/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.message.internal;

import gitlabbt.org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import gitlabbt.org.glassfish.jersey.message.internal.Utils;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

@Produces(value={"application/octet-stream", "*/*"})
@Consumes(value={"application/octet-stream", "*/*"})
@Singleton
public final class PathProvider
extends AbstractMessageReaderWriterProvider<Path> {
    @Override
    public final boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Path.class == type;
    }

    @Override
    public final Path readFrom(Class<Path> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        Path path = Utils.createTempFile().toPath();
        Files.copy(entityStream, path, StandardCopyOption.REPLACE_EXISTING);
        return path;
    }

    @Override
    public final boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Path.class.isAssignableFrom(type);
    }

    @Override
    public final void writeTo(Path t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Files.copy(t, entityStream);
    }
}

