/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.promptset.PromptSet;
import org.squashtest.tm.plugin.rest.admin.jackson.model.PromptSetDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.repository.PromptSetDao;

@Component
public class PromptSetValidator
implements Validator {
    private static final String PATCH_PROMPT_SET = "patch-prompt-set";
    private static final String POST_PROMPT_SET = "post-prompt-set";
    private static final String AI_USAGE = "aiUsage";
    private final PromptSetDao promptSetDao;
    private final HelpValidator helpValidator;

    public PromptSetValidator(PromptSetDao promptSetDao, HelpValidator helpValidator) {
        this.promptSetDao = promptSetDao;
        this.helpValidator = helpValidator;
    }

    public boolean supports(Class<?> aClass) {
        return PromptSetDto.class.equals(aClass);
    }

    public void validate(Object target, Errors errors) {
    }

    public void promptSetPostValidator(PromptSetDto promptSetDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)promptSetDto, POST_PROMPT_SET);
        if (promptSetDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
        this.validateName((Errors)validation, promptSetDto);
        this.helpValidator.validateAiUsage((BindingResult)validation, promptSetDto.getAiUsage());
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)promptSetDto, errors, (String)POST_PROMPT_SET);
    }

    public void promptSetPatchValidator(Long promptSetId, PromptSetDto promptSetDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)promptSetDto, PATCH_PROMPT_SET);
        this.validatePromptSetExists(promptSetId, (BindingResult)validation);
        if (promptSetDto.getName() != null) {
            this.validateName((Errors)validation, promptSetDto);
        }
        if (promptSetDto.getAiUsage() != null) {
            validation.rejectValue(AI_USAGE, "unpatchable attribute", "This attribute can not be patched.");
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)promptSetDto, errors, (String)PATCH_PROMPT_SET);
    }

    private void validatePromptSetExists(Long promptSetId, BindingResult validation) {
        if (this.promptSetDao.findById((Object)promptSetId).isEmpty()) {
            String message = String.format("No entity known for type PromptSet and id %d", promptSetId);
            validation.rejectValue("id", "invalid id", message);
        }
    }

    private void validateName(Errors errors, PromptSetDto promptSetDto) {
        if (StringUtils.isBlank((CharSequence)promptSetDto.getName())) {
            this.helpValidator.validateAttributes("name", errors);
        } else {
            PromptSet existingPromptSet = this.promptSetDao.findByName(promptSetDto.getName());
            if (Objects.nonNull(existingPromptSet)) {
                errors.rejectValue("name", "invalid value", "The name is already used by another prompt set. ");
            }
        }
    }
}

