/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.bdd.BddScriptLanguage;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ProjectAutomationConfigurationDto;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;

@Component
public class ProjectAutomationConfigurationValidator
implements Validator {
    private static final String PATCH_AUTOM_CONFIGURATION_VALIDATION = "patch-autom-configuration-validation";
    private static final String NO_LANGUAGE_OTHER_THAN_ENGLISH_FOR_ROBOT_PROJECT = "No language other than English can be set for a Robot project.";
    private static final String UNSUPPORTED_WORKFLOW_TYPE = "The REST API only supports 'NONE', 'NATIVE' and 'NATIVE_SIMPLIFIED' workflow types.";
    private static final String PROP_BDD_SCRIPT_LANGUAGE = "bddScriptLanguage";
    private static final String PROP_AUTOMATION_WORKFLOW_TYPE = "automationWorkflowType";
    private static final String ERROR_INVALID_ATTRIBUTE = "invalid attribute";

    public boolean supports(Class<?> clazz) {
        return ProjectAutomationConfigurationDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        throw new UnsupportedOperationException();
    }

    public void validatePatchAutomationConfiguration(ProjectAutomationConfigurationDto automationConfigurationDto, GenericProject project) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)automationConfigurationDto, PATCH_AUTOM_CONFIGURATION_VALIDATION);
        this.validateBddScriptLanguage(automationConfigurationDto, project, (BindingResult)validationBean);
        this.validateAutomatedWorkflowType(automationConfigurationDto, (BindingResult)validationBean);
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)automationConfigurationDto, errors, (String)PATCH_AUTOM_CONFIGURATION_VALIDATION);
    }

    private void validateBddScriptLanguage(ProjectAutomationConfigurationDto automationConfigurationDto, GenericProject project, BindingResult validationBean) {
        BddImplementationTechnology patchTechnology = automationConfigurationDto.getBddImplementationTechnology();
        BddImplementationTechnology currentTechnology = project.getBddImplementationTechnology();
        BddScriptLanguage patchLanguage = automationConfigurationDto.getBddScriptLanguage();
        if (BddImplementationTechnology.ROBOT.equals((Object)patchTechnology) && Objects.nonNull(patchLanguage) && !BddScriptLanguage.ENGLISH.equals((Object)patchLanguage)) {
            validationBean.rejectValue(PROP_BDD_SCRIPT_LANGUAGE, ERROR_INVALID_ATTRIBUTE, NO_LANGUAGE_OTHER_THAN_ENGLISH_FOR_ROBOT_PROJECT);
        } else if (Objects.isNull(patchTechnology) && BddImplementationTechnology.ROBOT.equals((Object)currentTechnology) && Objects.nonNull(patchLanguage) && !BddScriptLanguage.ENGLISH.equals((Object)patchLanguage)) {
            validationBean.rejectValue(PROP_BDD_SCRIPT_LANGUAGE, ERROR_INVALID_ATTRIBUTE, NO_LANGUAGE_OTHER_THAN_ENGLISH_FOR_ROBOT_PROJECT);
        } else if (BddImplementationTechnology.ROBOT.equals((Object)patchTechnology) && Objects.isNull(patchLanguage)) {
            automationConfigurationDto.setBddScriptLanguage(BddScriptLanguage.ENGLISH);
        }
    }

    void validateAutomatedWorkflowType(ProjectAutomationConfigurationDto automationConfigurationDto, BindingResult validationBean) {
        if (AutomationWorkflowType.REMOTE_WORKFLOW.equals((Object)automationConfigurationDto.getAutomationWorkflowType())) {
            validationBean.rejectValue(PROP_AUTOMATION_WORKFLOW_TYPE, ERROR_INVALID_ATTRIBUTE, UNSUPPORTED_WORKFLOW_TYPE);
        }
    }
}

