/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.promptset.PromptSet;
import org.squashtest.tm.plugin.rest.admin.jackson.model.PromptSetDto;
import org.squashtest.tm.plugin.rest.admin.service.RestPromptSetService;
import org.squashtest.tm.plugin.rest.admin.validators.PromptSetValidator;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController(value=PromptSet.class)
@UseDefaultRestApiConfiguration
public class RestPromptSetController
extends BaseRestController {
    private final RestPromptSetService restPromptSetService;
    private final PromptSetValidator promptSetValidator;

    public RestPromptSetController(RestPromptSetService restPromptSetService, PromptSetValidator promptSetValidator) {
        this.restPromptSetService = restPromptSetService;
        this.promptSetValidator = promptSetValidator;
    }

    @GetMapping(value={"/prompt-sets"})
    @ResponseBody
    @DynamicFilterExpression(value="*,-prompts")
    public ResponseEntity<PagedModel<EntityModel<PromptSet>>> findAllPromptSets(Pageable pageable) {
        Page<PromptSet> page = this.restPromptSetService.getAllPromptSets(pageable);
        PagedModel res = this.toPagedModel(page);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/prompt-sets/{id}"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression(value="*,prompts[*,-prompt_set]")
    public ResponseEntity<EntityModel<PromptSet>> findPromptSetById(@PathVariable(value="id") Long promptSetId) {
        PromptSet promptSet = this.restPromptSetService.findPromptSetById(promptSetId);
        EntityModel res = this.toEntityModel((Identified)promptSet);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/prompt-sets"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @DynamicFilterExpression(value="*,-prompts")
    public ResponseEntity<EntityModel<PromptSet>> addPromptSet(@RequestBody PromptSetDto promptSetDto) throws BindException {
        this.promptSetValidator.promptSetPostValidator(promptSetDto);
        PromptSet promptSet = this.restPromptSetService.addPromptSet(promptSetDto);
        EntityModel res = this.toEntityModel((Identified)promptSet);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/prompt-sets/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*,prompts[*,-prompt_set]")
    public ResponseEntity<EntityModel<PromptSet>> patchPromptSet(@PathVariable(value="id") Long promptSetId, @RequestBody PromptSetDto promptSetDto) throws BindException {
        this.promptSetValidator.promptSetPatchValidator(promptSetId, promptSetDto);
        PromptSet promptSet = this.restPromptSetService.updatePromptSet(promptSetId, promptSetDto);
        EntityModel res = this.toEntityModel((Identified)promptSet);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @DeleteMapping(value={"/prompt-sets/{ids}"})
    public ResponseEntity<Void> deletePromptSets(@PathVariable(value="ids") List<Long> promptSetIds) {
        this.restPromptSetService.deletePromptSets(promptSetIds);
        return ResponseEntity.noContent().build();
    }
}

