/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.client;

import java.util.Arrays;

public class PathBuilder {
    private final String uri;
    public static final String ROOT_API = "/api/rest";
    public static final String DELIMITER = "/";
    public static final String ISSUES = "issues";
    public static final String CONFIG_OPTION = "config?option=";

    private PathBuilder(String uri) {
        this.uri = uri;
    }

    public static PathBuilder buildCurrentUserPath() {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, "users/me")));
    }

    public static PathBuilder buildIssuePath(String issueId) {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, ISSUES, issueId)));
    }

    public static PathBuilder buildAllProjectsPath() {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, "projects")));
    }

    public static PathBuilder buildProjectPath(String projectId) {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, "projects", projectId)));
    }

    public static PathBuilder buildSeveritiesPath() {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, "config?option=severity_enum_string")));
    }

    public static PathBuilder buildPrioritiesPath() {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, "config?option=priority_enum_string")));
    }

    public static PathBuilder buildReproducibilityPath() {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, "config?option=reproducibility_enum_string")));
    }

    public static PathBuilder buildAddIssuePath() {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, ISSUES)));
    }

    public static PathBuilder buildAttachmentsPath(String issueId) {
        return new PathBuilder(String.join((CharSequence)DELIMITER, Arrays.asList(ROOT_API, ISSUES, issueId, "files")));
    }

    public String build() {
        return this.uri;
    }
}

