/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.MilestoneDto;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.PerimeterType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SprintToCreate;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SyncedRequirementHierarchy;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientProvider;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.IterationState;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.MilestoneStateEnum;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabPerimeterService;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CustomSprintModificationService;

@Service(value="squash.tm.plugin.xsquash4gitlab.SynchronizedSprintService")
@Transactional
public class SynchronizedSprintService {
    private final GitLabClientProvider gitLabClientProvider;
    private final GitLabPerimeterService gitLabPerimeterService;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final CustomSprintModificationService customSprintModificationService;

    public SynchronizedSprintService(GitLabClientProvider gitLabClientProvider, GitLabPerimeterService gitLabPerimeterService, CampaignLibraryNavigationService campaignLibraryNavigationService, CustomSprintModificationService customSprintModificationService) {
        this.gitLabClientProvider = gitLabClientProvider;
        this.gitLabPerimeterService = gitLabPerimeterService;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.customSprintModificationService = customSprintModificationService;
    }

    public List<SprintToCreate> getSprintsToCreate(GitLabRemoteSynchronisation synchronisation) {
        GitLabClient client = this.gitLabClientProvider.getGitLabClient(synchronisation.getRemoteSynchronisation().getServer().getId());
        PerimeterType perimeterType = this.gitLabPerimeterService.getPerimeterType(client, synchronisation.getPerimeter());
        return switch (synchronisation.getSyncedRequirementHierarchy()) {
            case SyncedRequirementHierarchy.ITERATION -> this.sprintsToCreateByIteration(client, synchronisation.getPerimeter(), perimeterType);
            case SyncedRequirementHierarchy.MILESTONE -> this.sprintsToCreateByMilestone(client, synchronisation.getPerimeter(), perimeterType);
            default -> new ArrayList<SprintToCreate>();
        };
    }

    private List<SprintToCreate> sprintsToCreateByIteration(GitLabClient client, String perimeter, PerimeterType perimeterType) {
        List<IterationDto> iterationDto = this.gitLabPerimeterService.getIterationDtos(client, perimeter, perimeterType);
        List<SprintToCreate> sprintsToCreate = iterationDto.stream().filter(Objects::nonNull).map(SprintToCreate::new).collect(Collectors.toList());
        SynchronizedSprintService.removeDuplicatesForIterations(sprintsToCreate);
        return sprintsToCreate;
    }

    private List<SprintToCreate> sprintsToCreateByMilestone(GitLabClient client, String perimeter, PerimeterType perimeterType) {
        List<MilestoneDto> milestoneDtos = this.gitLabPerimeterService.getMilestoneDtos(client, perimeter, perimeterType);
        List<SprintToCreate> sprintsToCreate = milestoneDtos.stream().filter(Objects::nonNull).map(SprintToCreate::new).collect(Collectors.toList());
        SynchronizedSprintService.removeDuplicatesForMilestones(sprintsToCreate);
        return sprintsToCreate;
    }

    public static Long extractIdFromGitLabId(String gitLabId) {
        String[] parts = gitLabId.split("/");
        String extractedId = parts[parts.length - 1];
        return Long.parseLong(extractedId);
    }

    private static void removeDuplicatesForMilestones(List<SprintToCreate> sprints) {
        HashSet uniqueNames = new HashSet();
        sprints.removeIf(sprint -> !uniqueNames.add(sprint.getName()));
    }

    private static void removeDuplicatesForIterations(List<SprintToCreate> sprints) {
        HashSet uniqueSprint = new HashSet();
        sprints.removeIf(sprint -> !uniqueSprint.add(Arrays.asList(sprint.getName(), sprint.getIterationGroup())));
    }

    public Sprint createOrUpdateSquashSprint(SprintToCreate sprint, Sprint squashSprint, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, Long targetSprintGroupId) {
        if (squashSprint == null) {
            squashSprint = this.createSprintInTargetSprintGroup(sprint, gitLabRemoteSynchronisation, targetSprintGroupId);
        } else {
            this.updateSprintInCampaignWorkspace(sprint, squashSprint);
        }
        return squashSprint;
    }

    private Sprint createSprintInTargetSprintGroup(SprintToCreate sprintToCreate, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, Long targetSprintGroupId) {
        RemoteSynchronisation remoteSync = gitLabRemoteSynchronisation.getRemoteSynchronisation();
        Sprint sprint = new Sprint();
        sprint.setName(sprintToCreate.getName());
        sprint.setRemoteSynchronisation(remoteSync);
        sprint.setRemoteName(sprintToCreate.getName());
        sprint.setRemoteState(sprintToCreate.getStatus());
        sprint.setStatus(SprintStatus.valueOf((String)sprintToCreate.getStatus()));
        sprint.setStartDate(sprintToCreate.getStartDate());
        sprint.setEndDate(sprintToCreate.getEndDate());
        sprint.setRemoteSprintId(Long.valueOf(sprintToCreate.getId()));
        this.campaignLibraryNavigationService.addSprintToSprintGroup(targetSprintGroupId.longValue(), sprint);
        return sprint;
    }

    private void updateSprintInCampaignWorkspace(SprintToCreate sprint, Sprint squashSprint) {
        String sprintName = sprint.getName();
        if (!squashSprint.getRemoteName().equals(sprintName)) {
            this.customSprintModificationService.rename(squashSprint.getId().longValue(), sprintName);
            squashSprint.setRemoteName(sprintName);
        }
        squashSprint.setRemoteState(sprint.getStatus());
        if (sprint.getStartDate() != null && !sprint.getStartDate().equals(squashSprint.getStartDate())) {
            squashSprint.setStartDate(sprint.getStartDate());
        }
        if (sprint.getEndDate() != null && !sprint.getEndDate().equals(squashSprint.getEndDate())) {
            squashSprint.setEndDate(sprint.getEndDate());
        }
    }

    public SprintStatus getSquashSprintStatusFromGitLabState(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, SprintToCreate sprint) {
        if (gitLabRemoteSynchronisation.getSyncedRequirementHierarchy().equals((Object)SyncedRequirementHierarchy.ITERATION)) {
            return this.getSprintStatusByIterationReqHierarchy(sprint.getStatus());
        }
        return this.getSprintStatusByMilestoneReqHierarchy(sprint);
    }

    private SprintStatus getSprintStatusByIterationReqHierarchy(String gitlabRemoteState) {
        IterationState gitlabIterationState = IterationState.valueOf(gitlabRemoteState);
        return switch (gitlabIterationState) {
            case IterationState.CLOSED -> SprintStatus.CLOSED;
            case IterationState.CURRENT, IterationState.OPENED -> SprintStatus.OPEN;
            case IterationState.UPCOMING -> SprintStatus.UPCOMING;
            default -> throw new IllegalStateException("Unexpected value: " + gitlabRemoteState);
        };
    }

    private SprintStatus getSprintStatusByMilestoneReqHierarchy(SprintToCreate sprint) {
        MilestoneStateEnum gitlabMilestoneState = MilestoneStateEnum.valueOf(sprint.getStatus());
        if (gitlabMilestoneState == MilestoneStateEnum.CLOSED) {
            return SprintStatus.CLOSED;
        }
        if (sprint.isUpcoming()) {
            return SprintStatus.UPCOMING;
        }
        if (gitlabMilestoneState == MilestoneStateEnum.ACTIVE) {
            return SprintStatus.OPEN;
        }
        throw new IllegalStateException("Unexpected value: " + sprint.getStatus());
    }
}

