--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-oodrqmrh (100.64.7.242)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-7.1.0.xml
--  Ran at: 16/02/2026 15:06
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.31.1
--  *********************************************************************

--  Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0::mbrugniere
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '7.1.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0', 'mbrugniere', '../tm/tm.changelog-7.1.0.xml', NOW(), 1, '9:9d10a2bc2b201964c73a7e7032b900dc', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

--  Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0-create-api-token-table::mbrugniere
--  Create table API_TOKEN
CREATE TABLE API_TOKEN (TOKEN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key for API_TOKEN', USER_ID BIGINT NOT NULL COMMENT 'foreign key to CORE_USER.PARTY_ID', UUID VARCHAR(36) NOT NULL COMMENT 'Unique UUID to identify a token in database', NAME VARCHAR(255) NOT NULL, PERMISSIONS VARCHAR(50) NOT NULL COMMENT 'READ for GET and READ_WRITE for all methods', CREATED_ON datetime NOT NULL, EXPIRY_DATE VARCHAR(10) NOT NULL, LAST_USAGE datetime NULL, CONSTRAINT pk_api_token PRIMARY KEY (TOKEN_ID), UNIQUE (UUID));

CREATE INDEX idx_fk_api_token_user_id ON API_TOKEN(USER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0-create-api-token-table', 'mbrugniere', '../tm/tm.changelog-7.1.0.xml', NOW(), 2, '9:c4cab334b1277b733508ddbf4c4cad22', 'createTable tableName=API_TOKEN; createIndex indexName=idx_fk_api_token_user_id, tableName=API_TOKEN', 'Create table API_TOKEN', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

--  Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0-fix-description-type-in-third-party-server::jprioux
ALTER TABLE THIRD_PARTY_SERVER MODIFY `DESCRIPTION` LONGTEXT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0-fix-description-type-in-third-party-server', 'jprioux', '../tm/tm.changelog-7.1.0.xml', NOW(), 3, '9:c591f457fe1ab4d3dc2c919ba1a47458', 'modifyDataType columnName=DESCRIPTION, tableName=THIRD_PARTY_SERVER', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

--  Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0-fix-description-default-value-in-third-party-server::jprioux
ALTER TABLE THIRD_PARTY_SERVER ALTER `DESCRIPTION` SET DEFAULT '';

UPDATE THIRD_PARTY_SERVER SET `DESCRIPTION` = '' WHERE DESCRIPTION IS NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0-fix-description-default-value-in-third-party-server', 'jprioux', '../tm/tm.changelog-7.1.0.xml', NOW(), 4, '9:d0526bba58ae7a065e3b71c8990eb3b3', 'addDefaultValue columnName=DESCRIPTION, tableName=THIRD_PARTY_SERVER; update tableName=THIRD_PARTY_SERVER', '', 'EXECUTED', NULL, NULL, '4.31.1', '1250788789');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

