/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestSuiteDto;
import org.squashtest.tm.plugin.rest.validators.helper.TestSuiteValidationHelper;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;

@Component
public class TestSuiteValidator
implements Validator {
    private static final String POST_TEST_SUITE = "post-testSuite";
    private static final String PATCH_TEST_SUITE = "patch-testSuite";
    @Inject
    private TestSuiteValidationHelper testSuiteValidationHelper;
    @Inject
    private TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;

    public boolean supports(Class<?> clazz) {
        return TestSuiteDto.class.equals(clazz);
    }

    public void validatePostTestSuite(TestSuiteDto testSuiteDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testSuiteDto, POST_TEST_SUITE);
        this.validate(testSuiteDto, (Errors)validation);
        this.testSuiteValidationHelper.validateIterationAndItem(testSuiteDto, (Errors)validation);
        if (!validation.hasErrors() && testSuiteDto.isHasCufs()) {
            this.testSuiteValidationHelper.checkCufs((Errors)validation, testSuiteDto);
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(testSuiteDto, errors, POST_TEST_SUITE);
    }

    public void validatePatchTestSuite(TestSuiteDto testSuiteDto, Long testSuiteId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testSuiteDto, PATCH_TEST_SUITE);
        this.testSuiteValidationHelper.checkEntityExist((Errors)validation, RestType.TEST_SUITE, testSuiteId);
        TestSuite testSuite = this.testSuiteTestPlanManagerService.findTestSuite(testSuiteId.longValue());
        testSuiteDto.setProject(testSuite.getProject());
        testSuiteDto.setId(testSuite.getId());
        if (testSuiteDto.isHasCufs()) {
            this.testSuiteValidationHelper.checkCufs((Errors)validation, testSuiteDto);
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(testSuiteDto, errors, PATCH_TEST_SUITE);
    }

    public void validate(Object target, Errors errors) {
        TestSuiteDto testSuiteDto = (TestSuiteDto)target;
        if (testSuiteDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing test suite, please do a patch request to the test suite id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        if (testSuiteDto.getParent().get_type().equals((Object)RestType.ITERATION)) {
            errors.rejectValue("_type", "invalid type", "Type iteration expected");
        } else if (testSuiteDto.getParent().getId() == null) {
            errors.rejectValue("id", "generated value", "The iteration id must not be null ");
        }
    }
}

