/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementDto;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.validators.helper.RequirementDtoValidationHelper;

@Component
public class RequirementValidator
implements Validator {
    private static final String POST_REQUIREMENT = "post-requirement";
    private static final String PATCH_REQUIREMENT = "patch-requirement";
    public static final String ASSOCIATE_TEST_CASES = "associate-test-cases";
    public static final String DISASSOCIATE_TEST_CASES = "disassociate-test-cases";
    @Inject
    private RequirementDtoValidationHelper requirementDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return RequirementDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        RequirementDto requirementDto = (RequirementDto)target;
        if (requirementDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing requirement, please do a patch request to the requirement id. ");
        }
        this.requirementDtoValidationHelper.checkParent(errors, requirementDto, RestType.REQUIREMENT);
        if (errors.hasErrors()) {
            return;
        }
        this.requirementDtoValidationHelper.assignProject(requirementDto);
        this.requirementDtoValidationHelper.checkCurrentVersion(errors, requirementDto);
        this.requirementDtoValidationHelper.checkCufs(errors, requirementDto, BindableEntity.REQUIREMENT_VERSION);
    }

    public void validatePostRequirement(RequirementDto requirementDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementDto, POST_REQUIREMENT);
        this.validate(requirementDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(requirementDto, errors, POST_REQUIREMENT);
    }

    public void validatePatchRequirement(RequirementDto requirementDto, Long requirementId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)requirementDto, PATCH_REQUIREMENT);
        requirementDto.setId(requirementId);
        this.requirementDtoValidationHelper.checkEntityExist((Errors)validation, RestType.REQUIREMENT, requirementId);
        if (validation.hasErrors()) {
            return;
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(requirementDto, errors, PATCH_REQUIREMENT);
    }

    public void validateAssociateTestCases(long requirementId, List<Long> testCaseIds) throws BindException {
        this.doValidateVerifyingTestCasesToRequirement(requirementId, testCaseIds, ASSOCIATE_TEST_CASES);
    }

    public void validateDisassociateTestCases(long requirementId, List<Long> testCaseIds) throws BindException {
        this.doValidateVerifyingTestCasesToRequirement(requirementId, testCaseIds, DISASSOCIATE_TEST_CASES);
    }

    private void doValidateVerifyingTestCasesToRequirement(long requirementId, List<Long> testCaseIds, String errorMessage) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        RequirementVersionDto dummyRequirementVersionDto = new RequirementVersionDto();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)dummyRequirementVersionDto, errorMessage);
        this.requirementDtoValidationHelper.checkEntityExist((Errors)validationBean, RestType.REQUIREMENT, requirementId);
        for (Long id : testCaseIds) {
            this.requirementDtoValidationHelper.checkEntityExist((Errors)validationBean, RestType.TEST_CASE, id);
        }
        if (validationBean.hasErrors()) {
            errors.add((Errors)validationBean);
        }
        ErrorHandlerHelper.throwIfError(dummyRequirementVersionDto, errors, errorMessage);
    }
}

