/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.SprintDto;
import org.squashtest.tm.plugin.rest.repository.RestSprintRepository;
import org.squashtest.tm.plugin.rest.repository.RestTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.service.RestSprintService;
import org.squashtest.tm.plugin.rest.service.impl.SprintPatcher;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CustomSprintModificationService;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.internal.dto.SprintReqVersionsBindingExceptionSummary;
import org.squashtest.tm.service.project.ProjectFinder;

@Service
@Transactional
public class RestSprintServiceImpl
implements RestSprintService {
    @Inject
    private RestSprintRepository sprintRepository;
    @Inject
    private SprintManagerService sprintManagerService;
    @Inject
    private CustomSprintModificationService customSprintModificationService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private SprintPatcher sprintPatcher;
    @Inject
    private RestTestPlanItemRepository restTestPlanItemRepository;
    @Inject
    private DSLContext dslContext;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'READ')")
    public Sprint getOne(Long sprintId) {
        return (Sprint)this.sprintRepository.getReferenceById(sprintId);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Sprint> findAllReadable(Pageable pageable) {
        List projectIds = this.projectFinder.findReadableProjectIdsOnCampaignLibrary();
        return projectIds.isEmpty() ? PaginationUtils.emptyPage(pageable) : this.sprintRepository.findAllInProjects(projectIds, pageable);
    }

    @Override
    public void deleteSprintsByIds(List<Long> sprintIds) {
        this.campaignLibraryNavigationService.deleteNodes(sprintIds);
    }

    @Override
    public Sprint createSprint(SprintDto sprintDto) {
        Sprint sprint = new Sprint();
        sprint.setName(sprintDto.getName());
        String reference = sprintDto.getReference();
        if (Objects.nonNull(reference)) {
            sprint.setReference(reference);
        }
        sprint.setStatus(SprintStatus.UPCOMING);
        this.sprintPatcher.patch(sprint, sprintDto);
        ParentEntity parent = sprintDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                this.campaignLibraryNavigationService.addSprintToCampaignLibrary(parent.getId().longValue(), sprint);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addSprintToCampaignFolder(parent.getId().longValue(), sprint);
                break;
            }
            case SPRINT_GROUP: {
                this.campaignLibraryNavigationService.addSprintToSprintGroup(parent.getId().longValue(), sprint);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + String.valueOf((Object)parent.getRestType()) + " is not a valid parent. You should validate this before.");
            }
        }
        return sprint;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'WRITE')")
    public Sprint patchSprint(SprintDto sprintDto, long sprintId) {
        String reference;
        Sprint sprint = this.getOne(sprintId);
        String name = sprintDto.getName();
        if (Objects.nonNull(name)) {
            sprint.setName(name);
        }
        if (Objects.nonNull(reference = sprintDto.getReference())) {
            sprint.setReference(reference);
        }
        boolean isSprintPatchable = this.checkIfSprintIsPatchable(sprintDto, sprint);
        this.validateStatus(sprintDto, sprint);
        if (isSprintPatchable) {
            this.validateDates(sprintDto, sprint);
            this.updateStatus(sprintDto, sprint);
            this.sprintPatcher.patch(sprint, sprintDto);
        }
        return sprint;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'READ')")
    public Page<TestPlanItem> findSprintTestPlan(long sprintId, Pageable pageable) {
        return this.restTestPlanItemRepository.findAllBySprintId(sprintId, pageable);
    }

    @Override
    public boolean linkRequirementsToSprint(long sprintId, List<Long> requirementIds) {
        SprintReqVersionsBindingExceptionSummary summary = new SprintReqVersionsBindingExceptionSummary();
        this.sprintManagerService.bindRequirementsByRlnIds(Long.valueOf(sprintId), requirementIds, summary);
        int summaryCount = summary.getReqVersionsAlreadyLinkedToSprint().size() + summary.getObsoleteReqVersionsInSelection().size() + summary.getHighLevelReqVersionsInSelection().size();
        return summaryCount != requirementIds.size();
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id, 'org.squashtest.tm.domain.campaign.Sprint', 'READ')")
    public List<Long> getExecutionIdsBySprint(long id) {
        return this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).join((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).where(Tables.SPRINT.CLN_ID.eq((Object)id)).fetchInto(Long.class);
    }

    private void validateStatus(SprintDto sprintDto, Sprint sprint) {
        if (SprintStatus.UPCOMING.equals((Object)sprintDto.getStatus()) && !SprintStatus.UPCOMING.equals((Object)sprint.getStatus())) {
            throw new IllegalArgumentException("An OPEN or CLOSED sprint cannot go back to UPCOMING status");
        }
    }

    private void validateDates(SprintDto sprintDto, Sprint sprint) {
        Date oldStartDate;
        Date oldEndDate;
        Date newStartDate = sprintDto.getStartDate();
        Date newEndDate = sprintDto.getEndDate();
        if (Objects.nonNull(newStartDate) && Objects.isNull(newEndDate) && Objects.nonNull(oldEndDate = sprint.getEndDate()) && newStartDate.after(oldEndDate)) {
            throw new IllegalArgumentException("New start date must be before current end date");
        }
        if (Objects.nonNull(newEndDate) && Objects.isNull(newStartDate) && Objects.nonNull(oldStartDate = sprint.getStartDate()) && newEndDate.before(oldStartDate)) {
            throw new IllegalArgumentException("New end date must be before current start date");
        }
    }

    private void updateStatus(SprintDto sprintDto, Sprint sprint) {
        SprintStatus newStatus = sprintDto.getStatus();
        if (Objects.nonNull(newStatus)) {
            this.customSprintModificationService.updateStatusBySprintId(sprint.getId(), newStatus);
        }
    }

    private boolean checkIfSprintIsPatchable(SprintDto sprintDto, Sprint sprint) {
        if (sprint.getStatus().equals((Object)SprintStatus.CLOSED)) {
            return SprintStatus.OPEN.equals((Object)sprintDto.getStatus());
        }
        return true;
    }
}

