/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import org.springframework.stereotype.Service;
import org.squashtest.tm.plugin.rest.core.exception.FeatureDisabledException;
import org.squashtest.tm.plugin.rest.service.RestOrchestratorFeaturesAvailabilityService;
import org.squashtest.tm.plugin.rest.service.impl.RestFeatureAvailabilityServiceImpl;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;

@Service(value="restOrchestratorFeaturesAvailabilityService")
public class RestOrchestratorFeaturesAvailabilityServiceImpl
extends RestFeatureAvailabilityServiceImpl
implements RestOrchestratorFeaturesAvailabilityService {
    @Inject
    public RestOrchestratorFeaturesAvailabilityServiceImpl(UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService, TestAutomationServerDao testAutomationServerDao) {
        super(ultimateLicenseAvailabilityService, testAutomationServerDao);
    }

    @Override
    public void denyOrchestratorFeaturesForCloudPremiumOrWithoutDefinedTestAutomationServer() {
        if (this.shouldDenyOrchestratorFeatures()) {
            throw new FeatureDisabledException("Orchestrator features are not available on SquashTM Cloud instances.");
        }
    }

    private boolean shouldDenyOrchestratorFeatures() {
        return this.isCloudModeEnabled && (!this.ultimateLicenseAvailabilityService.isAvailable() || this.testAutomationServerDao.count() == 0L);
    }
}

