/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.plugin.rest.repository.RestCampaignRepository;
import org.squashtest.tm.plugin.rest.repository.RestRequirementVersionRepository;
import org.squashtest.tm.plugin.rest.service.RestMilestoneService;
import org.squashtest.tm.plugin.rest.service.TestCaseLibraryFinderService;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.service.project.ProjectFinder;

@Service
@Transactional
public class RestMilestoneServiceImpl
implements RestMilestoneService {
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private RestCampaignRepository campaignRepository;
    @Inject
    private TestCaseLibraryFinderService testCaseLibraryFinderService;
    @Inject
    private RestRequirementVersionRepository reqVerRepository;

    @Override
    public Page<TestCase> findTestCasesByProjectIdAndMilestoneId(long projectId, Long milestoneId, List<String> fields, Pageable paging) {
        if (this.projectFinder.findReadableProjectIdsOnTestCaseLibrary().contains(projectId)) {
            return this.testCaseLibraryFinderService.findAllTestCaseByProjectIdAndMilestoneId(projectId, milestoneId, fields, paging);
        }
        return PaginationUtils.emptyPage(paging);
    }

    @Override
    public Page<TestCase> findTestCasesByProjectIdAndMilestoneLabel(long projectId, String milestoneLabel, List<String> fields, Pageable paging) {
        if (this.projectFinder.findReadableProjectIdsOnTestCaseLibrary().contains(projectId)) {
            return this.testCaseLibraryFinderService.findAllTestCaseByProjectIdAndMilestoneLabel(projectId, milestoneLabel, fields, paging);
        }
        return PaginationUtils.emptyPage(paging);
    }

    @Override
    public Page<Campaign> findCampaignsByProjectIdAndMilestone(long projectId, Long milestoneId, String milestoneLabel, Pageable paging) {
        if (this.projectFinder.findReadableProjectIdsOnCampaignLibrary().contains(projectId)) {
            return this.campaignRepository.findAllWithParameters(null, milestoneId, milestoneLabel, Collections.singleton(projectId), paging);
        }
        return PaginationUtils.emptyPage(paging);
    }

    @Override
    public Page<RequirementVersion> findRequirementVersionByProjectIdAndMilestone(long projectId, Long milestoneId, String milestoneLabel, Pageable paging) {
        if (this.projectFinder.findReadableProjectIdsOnRequirementLibrary().contains(projectId)) {
            return this.reqVerRepository.findAllRequirementVersionsByMilestoneAndProjectIds(milestoneId, milestoneLabel, Collections.singleton(projectId), paging);
        }
        return PaginationUtils.emptyPage(paging);
    }
}

