/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.plugin.rest.jackson.model.AutomatedTestTechnologyDto;
import org.squashtest.tm.plugin.rest.repository.RestAutomatedTestTechnologyRepository;
import org.squashtest.tm.plugin.rest.service.RestAutomatedTestTechnologyService;

@Service
@Transactional
public class RestAutomatedTestTechnologyServiceImpl
implements RestAutomatedTestTechnologyService {
    @Inject
    private RestAutomatedTestTechnologyRepository restAutomatedTestTechnologyRepository;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public AutomatedTestTechnology getOne(long id) {
        return (AutomatedTestTechnology)this.restAutomatedTestTechnologyRepository.getReferenceById(id);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<AutomatedTestTechnology> findAll(Pageable pageable) {
        return this.restAutomatedTestTechnologyRepository.findAll(pageable);
    }

    @Override
    public AutomatedTestTechnology addAutomatedTestTechnology(AutomatedTestTechnologyDto automatedTestTechnologyDto) {
        AutomatedTestTechnology newTechnology = automatedTestTechnologyDto.convert();
        return (AutomatedTestTechnology)this.restAutomatedTestTechnologyRepository.save(newTechnology);
    }
}

