/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.BasicEntity;

public class JR7EpicLinkPickerList {
    private List<EpicList> epicLists;
    private int total = 0;

    public JR7EpicLinkPickerList() {
    }

    public JR7EpicLinkPickerList(List<EpicList> epicLists, int total) {
        this.epicLists = epicLists;
        this.total = total;
    }

    public List<EpicList> getEpicLists() {
        return this.epicLists;
    }

    public void setEpicLists(List<EpicList> epicLists) {
        this.epicLists = epicLists;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public List<BasicEntity> tallyEpics() {
        HashSet<BasicEntity> epics = new HashSet<BasicEntity>();
        for (EpicList elist : this.epicLists) {
            epics.addAll(elist.getEpicNames());
        }
        ArrayList<BasicEntity> finalList = new ArrayList<BasicEntity>(epics);
        Collections.sort(finalList, new Comparator<BasicEntity>(){

            @Override
            public int compare(BasicEntity o1, BasicEntity o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return finalList;
    }

    public static final class EpicList {
        private String listDescriptor;
        private List<BasicEntity> epicNames;

        public EpicList() {
        }

        public EpicList(String listDescriptor, List<BasicEntity> epicNames) {
            this.listDescriptor = listDescriptor;
            this.epicNames = epicNames;
        }

        public String getListDescriptor() {
            return this.listDescriptor;
        }

        public void setListDescriptor(String listDescriptor) {
            this.listDescriptor = listDescriptor;
        }

        public List<BasicEntity> getEpicNames() {
            return this.epicNames;
        }

        public void setEpicNames(List<BasicEntity> epicNames) {
            this.epicNames = epicNames;
        }
    }
}

