/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.premium.actionword.service;

import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.premium.actionword.dao.ActionWordWorkspaceDao;
import org.squashtest.tm.plugin.premium.service.UltimateLicenseChecker;
import org.squashtest.tm.service.actionword.ActionWordWorkspaceService;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;

@Service
@Transactional(readOnly=true)
public class ActionWordWorkspaceServiceImpl
implements ActionWordWorkspaceService {
    private final ActionWordWorkspaceDao actionWordWorkspaceDao;
    private final UltimateLicenseChecker ultimateLicenseChecker;

    public ActionWordWorkspaceServiceImpl(ActionWordWorkspaceDao actionWordWorkspaceDao, UltimateLicenseChecker ultimateLicenseChecker) {
        this.actionWordWorkspaceDao = actionWordWorkspaceDao;
        this.ultimateLicenseChecker = ultimateLicenseChecker;
    }

    @IsUltimateLicenseAvailable
    public boolean areAllAssociatedToKeywordTestSteps(Set<Long> nodeIds) {
        this.ultimateLicenseChecker.checkIfAvailable();
        return this.actionWordWorkspaceDao.areAllAssociatedToKeywordTestSteps(nodeIds);
    }
}

