/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api.utils;

import gitlabbt.com.fasterxml.jackson.annotation.JsonInclude;
import gitlabbt.com.fasterxml.jackson.core.JsonGenerationException;
import gitlabbt.com.fasterxml.jackson.core.JsonGenerator;
import gitlabbt.com.fasterxml.jackson.core.JsonParseException;
import gitlabbt.com.fasterxml.jackson.core.JsonParser;
import gitlabbt.com.fasterxml.jackson.core.JsonProcessingException;
import gitlabbt.com.fasterxml.jackson.core.TreeNode;
import gitlabbt.com.fasterxml.jackson.core.type.TypeReference;
import gitlabbt.com.fasterxml.jackson.databind.DeserializationContext;
import gitlabbt.com.fasterxml.jackson.databind.DeserializationFeature;
import gitlabbt.com.fasterxml.jackson.databind.JavaType;
import gitlabbt.com.fasterxml.jackson.databind.JsonDeserializer;
import gitlabbt.com.fasterxml.jackson.databind.JsonMappingException;
import gitlabbt.com.fasterxml.jackson.databind.JsonNode;
import gitlabbt.com.fasterxml.jackson.databind.JsonSerializer;
import gitlabbt.com.fasterxml.jackson.databind.ObjectMapper;
import gitlabbt.com.fasterxml.jackson.databind.ObjectWriter;
import gitlabbt.com.fasterxml.jackson.databind.PropertyNamingStrategies;
import gitlabbt.com.fasterxml.jackson.databind.SerializationFeature;
import gitlabbt.com.fasterxml.jackson.databind.SerializerProvider;
import gitlabbt.com.fasterxml.jackson.databind.module.SimpleModule;
import gitlabbt.com.fasterxml.jackson.databind.type.CollectionType;
import gitlabbt.org.gitlab4j.api.models.User;
import gitlabbt.org.gitlab4j.models.utils.ISO8601;
import gitlabbt.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.ContextResolver;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@Produces(value={"application/json"})
public class JacksonJson
extends JacksonJaxbJsonProvider
implements ContextResolver<ObjectMapper> {
    private static final SimpleDateFormat iso8601UtcFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss 'UTC'");
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JacksonJson() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
        SimpleModule module = new SimpleModule("GitLabApiJsonModule");
        module.addSerializer(Date.class, new JsonDateSerializer());
        module.addDeserializer(Date.class, new JsonDateDeserializer());
        this.objectMapper.registerModule(module);
        this.setMapper(this.objectMapper);
    }

    @Override
    public ObjectMapper getContext(Class<?> objectType) {
        return this.objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JsonNode readTree(String postData) throws JsonParseException, JsonMappingException, IOException {
        return this.objectMapper.readTree(postData);
    }

    public JsonNode readTree(Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return this.objectMapper.readTree(reader);
    }

    public <T> T unmarshal(Class<T> returnType, JsonNode tree) throws JsonParseException, JsonMappingException, IOException {
        Object objectMapper = this.getContext((Class)returnType);
        return ((ObjectMapper)objectMapper).treeToValue((TreeNode)tree, returnType);
    }

    public <T> T unmarshal(Class<T> returnType, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        Object objectMapper = this.getContext((Class)returnType);
        return ((ObjectMapper)objectMapper).readValue(reader, returnType);
    }

    public <T> T unmarshal(Class<T> returnType, String postData) throws JsonParseException, JsonMappingException, IOException {
        Object objectMapper = this.getContext((Class)returnType);
        return ((ObjectMapper)objectMapper).readValue(postData, returnType);
    }

    public <T> List<T> unmarshalList(Class<T> returnType, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        Object objectMapper = this.getContext((Class)null);
        CollectionType javaType = ((ObjectMapper)objectMapper).getTypeFactory().constructCollectionType(List.class, returnType);
        return (List)((ObjectMapper)objectMapper).readValue(reader, (JavaType)javaType);
    }

    public <T> List<T> unmarshalList(Class<T> returnType, String postData) throws JsonParseException, JsonMappingException, IOException {
        Object objectMapper = this.getContext((Class)null);
        CollectionType javaType = ((ObjectMapper)objectMapper).getTypeFactory().constructCollectionType(List.class, returnType);
        return (List)((ObjectMapper)objectMapper).readValue(postData, (JavaType)javaType);
    }

    public <T> Map<String, T> unmarshalMap(Class<T> returnType, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        Object objectMapper = this.getContext((Class)null);
        return ((ObjectMapper)objectMapper).readValue(reader, new TypeReference<Map<String, T>>(){});
    }

    public <T> Map<String, T> unmarshalMap(Class<T> returnType, String jsonData) throws JsonParseException, JsonMappingException, IOException {
        Object objectMapper = this.getContext((Class)null);
        return ((ObjectMapper)objectMapper).readValue(jsonData, new TypeReference<Map<String, T>>(){});
    }

    public <T> String marshal(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object parameter is null");
        }
        ObjectWriter writer = this.objectMapper.writer().withDefaultPrettyPrinter();
        String results = null;
        try {
            results = writer.writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            System.err.println("JsonGenerationException, message=" + e.getMessage());
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
            System.err.println("JsonMappingException, message=" + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("IOException, message=" + e.getMessage());
        }
        return results;
    }

    public static <T> String toJsonString(T object) {
        return JacksonJsonSingletonHelper.JACKSON_JSON.marshal(object);
    }

    public static JsonNode toJsonNode(String jsonString) throws IOException {
        return JacksonJsonSingletonHelper.JACKSON_JSON.objectMapper.readTree(jsonString);
    }

    static {
        iso8601UtcFormat.setLenient(true);
        iso8601UtcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private static class JacksonJsonSingletonHelper {
        private static final JacksonJson JACKSON_JSON = new JacksonJson();

        private JacksonJsonSingletonHelper() {
        }

        static {
            JacksonJsonSingletonHelper.JACKSON_JSON.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);
            JacksonJsonSingletonHelper.JACKSON_JSON.objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        }
    }

    public static class UserListDeserializer
    extends JsonDeserializer<List<User>> {
        private static final ObjectMapper mapper = new JacksonJson().getObjectMapper();

        @Override
        public List<User> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jsonParser.readValueAsTree();
            int numUsers = tree.size();
            ArrayList<User> users = new ArrayList<User>(numUsers);
            for (int i = 0; i < numUsers; ++i) {
                JsonNode node = tree.get(i);
                JsonNode userNode = node.get("user");
                User user = mapper.treeToValue((TreeNode)userNode, User.class);
                users.add(user);
            }
            return users;
        }
    }

    public static class UserListSerializer
    extends JsonSerializer<List<User>> {
        @Override
        public void serialize(List<User> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            for (User user : value) {
                jgen.writeStartObject();
                jgen.writeObjectField("user", user);
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
        }
    }

    public static class JsonDateDeserializer
    extends JsonDeserializer<Date> {
        @Override
        public Date deserialize(JsonParser jsonparser, DeserializationContext context) throws IOException, JsonProcessingException {
            try {
                return ISO8601.toDate(jsonparser.getText());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class JsonDateSerializer
    extends JsonSerializer<Date> {
        @Override
        public void serialize(Date date, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String iso8601String = ISO8601.toString(date);
            gen.writeString(iso8601String);
        }
    }

    public static class DateOnlySerializer
    extends JsonSerializer<Date> {
        @Override
        public void serialize(Date date, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String dateString = ISO8601.dateOnly(date);
            gen.writeString(dateString);
        }
    }
}

