/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Link;
import gitlabbt.org.gitlab4j.api.models.ReleaseLinkParams;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ReleaseLinksApi
extends AbstractApi {
    public ReleaseLinksApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Link> getLinks(Object projectIdOrPath, String tagName) throws GitLabApiException {
        return this.getLinks(projectIdOrPath, tagName, this.getDefaultPerPage()).all();
    }

    public Pager<Link> getLinks(Object projectIdOrPath, String tagName, int itemsPerPage) throws GitLabApiException {
        return new Pager<Link>(this, Link.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases", this.urlEncode(tagName), "assets", "links");
    }

    public Stream<Link> getLinksStream(Object projectIdOrPath, String tagName) throws GitLabApiException {
        return this.getLinks(projectIdOrPath, tagName, this.getDefaultPerPage()).stream();
    }

    public Link getLink(Object projectIdOrPath, String tagName, Integer linkId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases", this.urlEncode(tagName), "assets", "links", linkId);
        return response.readEntity(Link.class);
    }

    public Optional<Link> getOptionalLink(Object projectIdOrPath, String tagName, Integer linkId) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getLink(projectIdOrPath, tagName, linkId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Link createLink(Object projectIdOrPath, ReleaseLinkParams params) throws GitLabApiException {
        String tagName = params.getTagName();
        if (tagName == null || tagName.trim().isEmpty()) {
            throw new RuntimeException("params.tagName cannot be null or empty");
        }
        String name = params.getName();
        if (name == null || name.trim().isEmpty()) {
            throw new RuntimeException("params.name cannot be null or empty");
        }
        String url = params.getUrl();
        if (url == null || url.trim().isEmpty()) {
            throw new RuntimeException("params.url cannot be null or empty");
        }
        Response response = this.post(Response.Status.CREATED, params, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases", this.urlEncode(tagName), "assets", "links");
        return response.readEntity(Link.class);
    }

    public Link updateLink(Object projectIdOrPath, Integer linkId, ReleaseLinkParams params) throws GitLabApiException {
        String tagName = params.getTagName();
        if (tagName == null || tagName.trim().isEmpty()) {
            throw new RuntimeException("params.tagName cannot be null or empty");
        }
        if (linkId == null) {
            throw new RuntimeException("linkId cannot be null");
        }
        Response response = this.put(Response.Status.OK, params, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases", this.urlEncode(tagName), "assets", "links", linkId);
        return response.readEntity(Link.class);
    }

    public void deleteLink(Object projectIdOrPath, String tagName, Integer linkId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "releases", this.urlEncode(tagName), "assets", "links", linkId);
    }
}

