/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.service.helper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class DateHelper {
    public static final DateHelper INSTANCE = new DateHelper();

    private DateHelper() {
    }

    public boolean isExpiredMoreThanTwoMonths(LocalDate expirationDate) {
        return LocalDate.now().isAfter(expirationDate.plusMonths(2L));
    }

    public Date getCurrentDate() {
        LocalDateTime now = LocalDateTime.now();
        return this.convertLocalDateTimeToDate(now);
    }

    public LocalDate getCurrentLocalDate() {
        return LocalDate.now();
    }

    private Date convertLocalDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public LocalDate convertDateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

