/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.protocol;

import java.io.IOException;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.HttpResponse;
import jirasync.org.apache.http.HttpResponseInterceptor;
import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.protocol.HttpContext;
import jirasync.org.apache.http.protocol.HttpDateGenerator;
import jirasync.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

