/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import java.util.Collections;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.SearchResult;
import jirasync.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class SearchResultJsonParser
implements JsonObjectParser<SearchResult> {
    private static final int DEFAULT_MAX_RESULTS = 50;

    @Override
    public SearchResult parse(JSONObject json) throws JSONException {
        Iterable<Issue> issues;
        String nextPageToken = null;
        int startAt = 0;
        if (json.has("nextPageToken")) {
            nextPageToken = json.optString("nextPageToken", null);
        }
        if (json.has("startAt")) {
            startAt = json.optInt("startAt", 0);
        }
        int maxResults = json.has("maxResults") ? json.optInt("maxResults", 50) : 50;
        int total = json.has("total") ? json.optInt("total", 0) : 0;
        JSONArray issuesJsonArray = json.getJSONArray("issues");
        if (issuesJsonArray.length() > 0) {
            IssueJsonParser issueParser = new IssueJsonParser(json.optJSONObject("names"), json.optJSONObject("schema"));
            GenericJsonArrayParser<Issue> issuesParser = GenericJsonArrayParser.create(issueParser);
            issues = issuesParser.parse(issuesJsonArray);
        } else {
            issues = Collections.emptyList();
        }
        return new SearchResult(startAt, nextPageToken, maxResults, total, issues);
    }
}

