/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;

public class JsonPatchBuilder {
    List<Operation> operations = new ArrayList<Operation>();

    public List<Operation> getOperations() {
        return this.operations;
    }

    public JsonPatchBuilder add(String path, Object value) {
        this.addOperation(Operation.add(path, value));
        return this;
    }

    private JsonPatchBuilder addOperation(Operation operation) {
        this.operations.add(operation);
        return this;
    }

    @JsonSerialize
    public static class Operation {
        public final Kind op;
        public final String path;
        public final String from;
        public final Object value;

        private Operation(Kind op, String path, String from, Object value) {
            this.op = op;
            this.path = path;
            this.from = from;
            this.value = value;
        }

        public static Operation add(String path, Object value) {
            return new Operation(Kind.add, path, null, value);
        }

        public Operation() {
            this.from = null;
            this.op = null;
            this.path = null;
            this.value = null;
        }
    }

    public static enum Kind {
        add,
        remove,
        replace,
        move,
        copy,
        test;

    }
}

